/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.EvaluationManagementLog;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.WrittenTest_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.icalendar.EvaluationEventBean;
import org.fenixedu.academic.dto.InfoEvaluation;
import org.fenixedu.academic.dto.InfoWrittenTest;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class WrittenTest
extends WrittenTest_Base {
    public WrittenTest(Date testDate, Date testStartTime, Date testEndTime, List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, List<Space> rooms, GradeScale gradeScale, String description) {
        this.checkEvaluationDate(testDate, executionCoursesToAssociate);
        this.setAttributesAndAssociateRooms(testDate, testStartTime, testEndTime, executionCoursesToAssociate, curricularCourseScopesToAssociate, rooms);
        this.setDescription(description);
        if (gradeScale == null) {
            this.setGradeScale(GradeScale.TYPE20);
        } else {
            this.setGradeScale(gradeScale);
        }
        this.checkIntervalBetweenEvaluations();
        this.logCreate();
    }

    public void edit(Date testDate, Date testStartTime, Date testEndTime, List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, List<Space> rooms, GradeScale gradeScale, String description) {
        this.checkEvaluationDate(testDate, executionCoursesToAssociate);
        this.getAssociatedExecutionCoursesSet().clear();
        this.getAssociatedCurricularCourseScopeSet().clear();
        this.getAssociatedContextsSet().clear();
        this.setAttributesAndAssociateRooms(testDate, testStartTime, testEndTime, executionCoursesToAssociate, curricularCourseScopesToAssociate, rooms);
        this.setDescription(description);
        if (gradeScale == null) {
            this.setGradeScale(GradeScale.TYPE20);
        } else {
            this.setGradeScale(gradeScale);
        }
        this.checkIntervalBetweenEvaluations();
        this.logEdit();
    }

    public void setDayDate(Date date) {
        User requestor = Authenticate.getUser();
        if (!(requestor != null && this.hasTimeTableManagerPrivledges(requestor) || this.hasCoordinatorPrivledges(requestor) || this.isTeacher(requestor) && this.allowedPeriod(date))) {
            throw new DomainException("not.authorized.to.set.this.date", new String[0]);
        }
        super.setDayDate(date);
    }

    private void checkEvaluationDate(Date writtenEvaluationDate, List<ExecutionCourse> executionCoursesToAssociate) {
        for (ExecutionCourse executionCourse : executionCoursesToAssociate) {
            long endDate;
            DateTime endDateTime;
            long beginDate = executionCourse.getExecutionPeriod().getBeginDate().getTime();
            Interval interval = new Interval(beginDate, (endDateTime = new DateTime(endDate = executionCourse.getExecutionPeriod().getEndDate().getTime())).plusDays(1).getMillis());
            if (interval.contains(writtenEvaluationDate.getTime())) continue;
            throw new DomainException("error.invalidWrittenTestDate", new String[0]);
        }
    }

    private boolean isTeacher(User requestor) {
        Person person;
        Teacher teacher;
        if (requestor != null && (teacher = (person = requestor.getPerson()).getTeacher()) != null) {
            for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
                if (!teacher.hasProfessorshipForExecutionCourse(executionCourse)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allowedPeriod(Date date) {
        YearMonthDay yearMonthDay = new YearMonthDay(date.getTime());
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
            ExecutionYear executionYear = executionCourse.getExecutionPeriod().getExecutionYear();
            for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                Date startExamsPeriod;
                DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
                ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
                if (executionSemester.getSemester() == 1) {
                    startExamsPeriod = executionDegree.getPeriodExamsFirstSemester().getStart();
                } else if (executionSemester.getSemester() == 2) {
                    startExamsPeriod = executionDegree.getPeriodExamsSecondSemester().getStart();
                } else {
                    throw new DomainException("unsupported.execution.period.semester", new String[0]);
                }
                if (new YearMonthDay(startExamsPeriod.getTime()).isAfter((ReadablePartial)yearMonthDay)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasCoordinatorPrivledges(User requestor) {
        Person person;
        if (requestor != null && RoleType.COORDINATOR.isMember(requestor.getPerson().getUser()) && (person = requestor.getPerson()) != null) {
            for (Coordinator coordinator : person.getCoordinatorsSet()) {
                ExecutionDegree executionDegree = coordinator.getExecutionDegree();
                for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
                    if (executionCourse.getExecutionPeriod().getExecutionYear() != executionDegree.getExecutionYear()) continue;
                    DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
                    for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                        if (degreeCurricularPlan != curricularCourse.getDegreeCurricularPlan()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean hasTimeTableManagerPrivledges(User requestor) {
        return requestor != null && RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(requestor.getPerson().getUser());
    }

    public EvaluationType getEvaluationType() {
        return EvaluationType.TEST_TYPE;
    }

    public boolean canTeacherChooseRoom(ExecutionCourse executionCourse, Teacher teacher) {
        if (executionCourse.teacherLecturesExecutionCourse(teacher)) {
            for (Lesson lesson : executionCourse.getLessons()) {
                if (!lesson.isAllIntervalIn(new Interval((ReadableInstant)this.getBeginningDateTime(), (ReadableInstant)this.getEndDateTime()))) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Space> getTeacherAvailableRooms(Teacher teacher) {
        ArrayList<Space> rooms = new ArrayList<Space>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            if (!executionCourse.teacherLecturesExecutionCourse(teacher)) continue;
            for (Lesson lesson : executionCourse.getLessons()) {
                if (lesson.getRoomOccupation() == null || !lesson.isAllIntervalIn(new Interval((ReadableInstant)this.getBeginningDateTime(), (ReadableInstant)this.getEndDateTime()))) continue;
                rooms.add(lesson.getRoomOccupation().getRoom());
            }
        }
        return rooms;
    }

    public Collection<Space> getAvailableRooms() {
        ArrayList<Space> rooms = new ArrayList<Space>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            for (Lesson lesson : executionCourse.getLessons()) {
                if (lesson.getRoomOccupation() == null || !lesson.isAllIntervalIn(new Interval((ReadableInstant)this.getBeginningDateTime(), (ReadableInstant)this.getEndDateTime()))) continue;
                rooms.add(lesson.getRoomOccupation().getRoom());
            }
        }
        return rooms;
    }

    public void teacherEditRooms(Teacher teacher, ExecutionSemester executionSemester, List<Space> rooms) {
        Collection<Space> teacherAvailableRooms = this.getTeacherAvailableRooms(teacher);
        List associatedRooms = this.getAssociatedRooms();
        for (Space room : rooms) {
            if (associatedRooms.contains(room)) continue;
            if (!teacherAvailableRooms.contains(room)) {
                throw new DomainException("error.room.does.not.belong.to.teachers.avaliable.rooms", new String[0]);
            }
            this.associateNewRoom(room);
        }
        for (Space room : associatedRooms) {
            if (rooms.contains(room) || !this.canTeacherRemoveRoom(executionSemester, teacher, room)) continue;
            this.removeRoomOccupation(room);
        }
        for (ExecutionCourse ec : this.getAssociatedExecutionCoursesSet()) {
            EvaluationManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.evaluation.generic.edited.rooms", this.getPresentationName(), ec.getName(), ec.getDegreePresentationString());
        }
    }

    public boolean canBeAssociatedToRoom(Space space) {
        HashSet<Class<? extends EventSpaceOccupation>> classes = new HashSet<Class<? extends EventSpaceOccupation>>();
        classes.add(LessonSpaceOccupation.class);
        classes.add(LessonInstanceSpaceOccupation.class);
        return SpaceUtils.isFree(space, this.getBeginningDateTime().toYearMonthDay(), this.getEndDateTime().toYearMonthDay(), this.getBeginningDateHourMinuteSecond(), this.getEndDateHourMinuteSecond(), this.getDayOfWeek(), null, null, null, classes);
    }

    public boolean canTeacherRemoveRoom(ExecutionSemester executionSemester, Teacher teacher, Space room) {
        for (Lesson lesson : WrittenTest.getAssociatedLessons(room, executionSemester)) {
            if (!lesson.isAllIntervalIn(new Interval((ReadableInstant)this.getBeginningDateTime(), (ReadableInstant)this.getEndDateTime())) || !lesson.getExecutionCourse().teacherLecturesExecutionCourse(teacher)) continue;
            return true;
        }
        return false;
    }

    private static List<Lesson> getAssociatedLessons(Space space, ExecutionSemester executionSemester) {
        ArrayList<Lesson> lessons = new ArrayList<Lesson>();
        for (Occupation spaceOccupation : space.getOccupationSet()) {
            LessonSpaceOccupation roomOccupation;
            Lesson lesson;
            if (!(spaceOccupation instanceof LessonSpaceOccupation) || (lesson = (roomOccupation = (LessonSpaceOccupation)spaceOccupation).getLesson()).getExecutionPeriod() != executionSemester) continue;
            lessons.add(lesson);
        }
        return lessons;
    }

    public List<EvaluationEventBean> getAllEvents(Registration registration) {
        return this.getAllEvents(this.getDescription(), registration);
    }

    public boolean getCanRequestRoom() {
        return this.getRequestRoomSentDate() == null;
    }

    public String getRequestRoomSentDateString() {
        return this.getRequestRoomSentDate().toString("dd/MM/yyyy HH:mm");
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.written.test", (String[])new String[0]) + " " + this.getDescription();
    }

    public InfoEvaluation newInfoFromDomain() {
        return InfoWrittenTest.newInfoFromDomain(this);
    }
}

