/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester_Base;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicSemesterCE;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadExecutionPeriods;
import org.fenixedu.academic.util.Month;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class ExecutionSemester
extends ExecutionSemester_Base
implements Comparable<ExecutionSemester> {
    public static final Comparator<ExecutionSemester> COMPARATOR_BY_SEMESTER_AND_YEAR = new Comparator<ExecutionSemester>(){

        @Override
        public int compare(ExecutionSemester o1, ExecutionSemester o2) {
            AcademicInterval ai1 = o1.getAcademicInterval();
            AcademicInterval ai2 = o2.getAcademicInterval();
            int c = ai1.getStartDateTimeWithoutChronology().compareTo((ReadableInstant)ai2.getStartDateTimeWithoutChronology());
            return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
        }
    };
    private static transient ExecutionSemester currentExecutionPeriod = null;
    private static transient ExecutionSemester markSheetManagmentExecutionPeriod = null;
    private static transient ExecutionSemester firstBolonhaExecutionPeriod = null;
    private static transient ExecutionSemester firstBolonhaTransitionExecutionPeriod = null;
    private static transient ExecutionSemester firstEnrolmentsExecutionPeriod = null;

    private ExecutionSemester() {
        this.setRootDomainObjectForExecutionPeriod(Bennu.getInstance());
    }

    public ExecutionSemester(ExecutionYear executionYear, AcademicInterval academicInterval, String name) {
        this();
        this.setExecutionYear(executionYear);
        this.setAcademicInterval(academicInterval);
        this.setBeginDateYearMonthDay(academicInterval.getBeginYearMonthDayWithoutChronology());
        this.setEndDateYearMonthDay(academicInterval.getEndYearMonthDayWithoutChronology());
        this.setName(name);
    }

    private void checkDatesIntersection(YearMonthDay begin, YearMonthDay end) {
        List infoExecutionPeriods = ReadExecutionPeriods.run();
        if (infoExecutionPeriods != null && !infoExecutionPeriods.isEmpty()) {
            Collections.sort(infoExecutionPeriods, InfoExecutionPeriod.COMPARATOR_BY_YEAR_AND_SEMESTER);
            for (InfoExecutionPeriod infoExecutionPeriod : infoExecutionPeriods) {
                ExecutionSemester executionSemester = infoExecutionPeriod.getExecutionPeriod();
                YearMonthDay beginDate = executionSemester.getBeginDateYearMonthDay();
                YearMonthDay endDate = executionSemester.getEndDateYearMonthDay();
                if (begin.isAfter((ReadablePartial)endDate) || end.isBefore((ReadablePartial)beginDate) || executionSemester.equals(this)) continue;
                throw new DomainException("error.ExecutionPeriod.intersection.dates", new String[0]);
            }
        }
    }

    public void editPeriod(YearMonthDay begin, YearMonthDay end) throws DomainException {
        if (begin == null || end == null || end.isBefore((ReadablePartial)begin)) {
            throw new DomainException("error.ExecutionPeriod.invalid.dates", new String[0]);
        }
        this.checkDatesIntersection(begin, end);
        this.setBeginDateYearMonthDay(begin);
        this.setEndDateYearMonthDay(end);
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        if (executionYear == null) {
            throw new DomainException("error.ExecutionPeriod.empty.executionYear", new String[0]);
        }
        super.setExecutionYear(executionYear);
    }

    public Integer getSemester() {
        return this.getAcademicInterval().getAcademicSemesterOfAcademicYear();
    }

    public ExecutionSemester getNextExecutionPeriod() {
        AcademicSemesterCE semester = this.getAcademicInterval().plusSemester(1);
        return semester != null ? ExecutionSemester.getExecutionPeriod(semester) : null;
    }

    public List<Month> getSemesterMonths() {
        int monthEnd;
        int monthStart = this.getAcademicInterval().getStart().getMonthOfYear();
        if (monthStart > (monthEnd = this.getAcademicInterval().getEnd().getMonthOfYear())) {
            monthEnd += 12;
        }
        ArrayList<Month> result = new ArrayList<Month>();
        for (int i = monthStart; i <= monthEnd; ++i) {
            result.add(Month.fromInt(i > 12 ? i - 12 : i));
        }
        return result;
    }

    public ExecutionSemester getPreviousExecutionPeriod() {
        AcademicSemesterCE semester = this.getAcademicInterval().minusSemester(1);
        return semester != null ? ExecutionSemester.getExecutionPeriod(semester) : null;
    }

    public boolean hasPreviousExecutionPeriod() {
        return this.getPreviousExecutionPeriod() != null;
    }

    public boolean hasNextExecutionPeriod() {
        return this.getNextExecutionPeriod() != null;
    }

    @Override
    public int compareTo(ExecutionSemester object) {
        if (object == null) {
            return 1;
        }
        return COMPARATOR_BY_SEMESTER_AND_YEAR.compare(this, object);
    }

    public String getQualifiedName() {
        return this.getName() + " " + this.getExecutionYear().getYear();
    }

    public boolean containsDay(Date day) {
        return this.containsDay(YearMonthDay.fromDateFields((Date)day));
    }

    public boolean containsDay(DateTime dateTime) {
        return this.containsDay(dateTime.toYearMonthDay());
    }

    public boolean containsDay(YearMonthDay date) {
        return !this.getBeginDateYearMonthDay().isAfter((ReadablePartial)date) && !this.getEndDateYearMonthDay().isBefore((ReadablePartial)date);
    }

    public DateMidnight getThisMonday() {
        DateTime beginningOfSemester = this.getBeginDateYearMonthDay().toDateTimeAtMidnight();
        DateTime endOfSemester = this.getEndDateYearMonthDay().toDateTimeAtMidnight();
        if (beginningOfSemester.isAfterNow() || endOfSemester.isBeforeNow()) {
            return null;
        }
        DateMidnight now = new DateMidnight();
        return now.withField(DateTimeFieldType.dayOfWeek(), 1);
    }

    public Interval getCurrentWeek() {
        DateMidnight thisMonday = this.getThisMonday();
        return thisMonday == null ? null : new Interval((ReadableInstant)thisMonday, (ReadableInstant)thisMonday.plusWeeks(1));
    }

    public Interval getPreviousWeek() {
        DateMidnight thisMonday = this.getThisMonday();
        return thisMonday == null ? null : new Interval((ReadableInstant)thisMonday.minusWeeks(1), (ReadableInstant)thisMonday);
    }

    public boolean isAfter(ExecutionSemester executionSemester) {
        return this.compareTo(executionSemester) > 0;
    }

    public boolean isAfterOrEquals(ExecutionSemester executionSemester) {
        return this.compareTo(executionSemester) >= 0;
    }

    public boolean isBefore(ExecutionSemester executionSemester) {
        return this.compareTo(executionSemester) < 0;
    }

    public boolean isBeforeOrEquals(ExecutionSemester executionSemester) {
        return this.compareTo(executionSemester) <= 0;
    }

    public boolean isOneYearAfter(ExecutionSemester executionSemester) {
        ExecutionSemester nextExecutionPeriod = executionSemester.getNextExecutionPeriod();
        return nextExecutionPeriod == null ? false : this == nextExecutionPeriod.getNextExecutionPeriod();
    }

    public boolean isCurrent() {
        return this.getState().equals(PeriodState.CURRENT);
    }

    public boolean isClosed() {
        return this.getState().equals(PeriodState.CLOSED);
    }

    public boolean isNotOpen() {
        return this.getState().equals(PeriodState.NOT_OPEN);
    }

    public boolean isFor(Integer semester) {
        return this.getSemester().equals(semester);
    }

    public boolean isFor(String year) {
        return this.getExecutionYear().isFor(year);
    }

    public boolean isForSemesterAndYear(Integer semester, String year) {
        return this.isFor(semester) && this.isFor(year);
    }

    public boolean isInTimePeriod(Date begin, Date end) {
        return this.isInTimePeriod(YearMonthDay.fromDateFields((Date)begin), YearMonthDay.fromDateFields((Date)end));
    }

    public boolean isInTimePeriod(YearMonthDay begin, YearMonthDay end) {
        return this.getBeginDateYearMonthDay().isBefore((ReadablePartial)end) && this.getEndDateYearMonthDay().isAfter((ReadablePartial)begin);
    }

    public boolean isInTimePeriod(LocalDate begin, LocalDate end) {
        return this.getBeginDateYearMonthDay().isBefore((ReadablePartial)end) && this.getEndDateYearMonthDay().isAfter((ReadablePartial)begin);
    }

    public boolean isFirstOfYear() {
        return this.getExecutionYear().getFirstExecutionPeriod() == this;
    }

    public ExecutionCourse getExecutionCourseByInitials(String courseInitials) {
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            if (!executionCourse.getSigla().equalsIgnoreCase(courseInitials)) continue;
            return executionCourse;
        }
        return null;
    }

    public List<ExecutionCourse> getExecutionCoursesWithNoCurricularCourses() {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            if (!executionCourse.getAssociatedCurricularCoursesSet().isEmpty()) continue;
            result.add(executionCourse);
        }
        return result;
    }

    public List<ExecutionCourse> getExecutionCoursesByDegreeCurricularPlanAndSemesterAndCurricularYearAndName(DegreeCurricularPlan degreeCurricularPlan, CurricularYear curricularYear, String name) {
        String normalizedName = name != null ? StringNormalizer.normalize((String)name).replaceAll("%", ".*") : null;
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            String executionCourseName = StringNormalizer.normalize((String)executionCourse.getNome());
            if (normalizedName == null || !executionCourseName.matches(normalizedName) || !executionCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(curricularYear, degreeCurricularPlan)) continue;
            result.add(executionCourse);
        }
        return result;
    }

    public Collection<MarkSheet> getWebMarkSheetsNotPrinted() {
        HashSet<MarkSheet> markSheets = new HashSet<MarkSheet>();
        for (MarkSheet sheet : this.getMarkSheetsSet()) {
            if (!sheet.getSubmittedByTeacher().booleanValue() || sheet.getPrinted().booleanValue()) continue;
            markSheets.add(sheet);
        }
        return markSheets;
    }

    public Collection<MarkSheet> getWebMarkSheetsNotPrinted(Person person, DegreeCurricularPlan dcp) {
        HashSet<MarkSheet> markSheets = new HashSet<MarkSheet>();
        for (MarkSheet sheet : this.getMarkSheetsSet()) {
            if (!sheet.getSubmittedByTeacher().booleanValue() || sheet.getPrinted().booleanValue() || dcp != null && !sheet.isFor(dcp) || !sheet.getCurricularCourse().hasAnyExecutionDegreeFor(this.getExecutionYear())) continue;
            ExecutionDegree executionDegree = sheet.getCurricularCourse().getExecutionDegreeFor(this.getExecutionYear().getAcademicInterval());
            if (!AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.MANAGE_MARKSHEETS, person.getUser()).collect(Collectors.toSet()).contains(executionDegree.getDegree())) continue;
            markSheets.add(sheet);
        }
        return markSheets;
    }

    public Collection<ExecutionCourse> getExecutionCoursesWithDegreeGradesToSubmit(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            if (!executionCourse.hasAnyDegreeGradeToSubmit(this, degreeCurricularPlan)) continue;
            executionCourses.add(executionCourse);
        }
        return executionCourses;
    }

    public Collection<MarkSheet> getMarkSheetsToConfirm(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<MarkSheet> markSheets = new ArrayList<MarkSheet>();
        for (MarkSheet markSheet : this.getMarkSheetsSet()) {
            if (degreeCurricularPlan != null && !markSheet.getCurricularCourse().getDegreeCurricularPlan().equals((Object)degreeCurricularPlan) || !markSheet.isNotConfirmed()) continue;
            markSheets.add(markSheet);
        }
        return markSheets;
    }

    public List<Attends> getAttendsByDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<Attends> attendsList = new ArrayList<Attends>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            for (Attends attends : executionCourse.getAttendsSet()) {
                if (attends.getEnrolment() == null || !attends.getEnrolment().getDegreeCurricularPlanOfStudent().equals((Object)degreeCurricularPlan)) continue;
                attendsList.add(attends);
            }
        }
        return attendsList;
    }

    public List<Enrolment> getEnrolmentsWithAttendsByDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<Enrolment> enrolmentsList = new ArrayList<Enrolment>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            for (Attends attends : executionCourse.getAttendsSet()) {
                if (attends.getEnrolment() == null || !attends.getEnrolment().getDegreeCurricularPlanOfStudent().equals((Object)degreeCurricularPlan)) continue;
                enrolmentsList.add(attends.getEnrolment());
            }
        }
        return enrolmentsList;
    }

    public OccupationPeriod getLessonsPeriod() {
        OccupationPeriod lessonsPeriod = null;
        Collection<ExecutionDegree> degrees = this.getExecutionYear().getExecutionDegreesMatching(DegreeType::isPreBolonhaDegree);
        degrees.addAll(this.getExecutionYear().getExecutionDegreesMatching(DegreeType::isBolonhaDegree));
        degrees.addAll(this.getExecutionYear().getExecutionDegreesMatching(DegreeType::isIntegratedMasterDegree));
        degrees.addAll(this.getExecutionYear().getExecutionDegreesMatching(DegreeType::isBolonhaMasterDegree));
        for (ExecutionDegree executionDegree : degrees) {
            if (this.getSemester() == 1) {
                OccupationPeriod lessonsPeriodFirstSemester = executionDegree.getPeriodLessonsFirstSemester();
                lessonsPeriod = lessonsPeriod == null || lessonsPeriodFirstSemester.isGreater(lessonsPeriod) ? lessonsPeriodFirstSemester : lessonsPeriod;
                continue;
            }
            OccupationPeriod lessonsPeriodSecondSemester = executionDegree.getPeriodLessonsSecondSemester();
            lessonsPeriod = lessonsPeriod == null || lessonsPeriodSecondSemester.isGreater(lessonsPeriod) ? lessonsPeriodSecondSemester : lessonsPeriod;
        }
        return lessonsPeriod;
    }

    public String getYear() {
        return this.getExecutionYear().getYear();
    }

    public void delete() {
        if (!this.getAssociatedExecutionCoursesSet().isEmpty()) {
            throw new Error("cannot.delete.execution.period.because.execution.courses.exist");
        }
        if (!this.getEnrolmentsSet().isEmpty()) {
            throw new Error("cannot.delete.execution.period.because.enrolments.exist");
        }
        if (!this.getTeachersWithIncompleteEvaluationWorkGroupSet().isEmpty()) {
            throw new DomainException("error.executionPeriod.cannotDeleteExecutionPeriodUsedInAccessControl", new String[0]);
        }
        super.setExecutionYear(null);
        this.setRootDomainObjectForExecutionPeriod(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public int getNumberOfProfessorships(CurricularCourse curricularCourse) {
        int count = 0;
        for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionPeriod(this)) {
            count += executionCourse.getProfessorshipsSet().size();
        }
        return count;
    }

    public EnrolmentPeriod getEnrolmentPeriod(Class<? extends EnrolmentPeriod> clazz, DegreeCurricularPlan degreeCurricularPlan) {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodSet()) {
            if (!((Object)((Object)enrolmentPeriod)).getClass().equals(clazz) || enrolmentPeriod.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return enrolmentPeriod;
        }
        return null;
    }

    public static ExecutionSemester getExecutionPeriod(AcademicSemesterCE entry) {
        if (entry != null) {
            entry = (AcademicSemesterCE)((Object)entry.getOriginalTemplateEntry());
            for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
                if (!executionSemester.getAcademicInterval().getAcademicCalendarEntry().equals((Object)entry)) continue;
                return executionSemester;
            }
        }
        return null;
    }

    public static ExecutionSemester readActualExecutionSemester() {
        if (currentExecutionPeriod == null || currentExecutionPeriod.getRootDomainObject() != Bennu.getInstance() || !currentExecutionPeriod.isCurrent()) {
            for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
                if (!executionSemester.isCurrent()) continue;
                currentExecutionPeriod = executionSemester;
                break;
            }
        }
        return currentExecutionPeriod;
    }

    private static ExecutionSemester readFromProperties(ExecutionSemester executionSemester, String yearString, String semesterString) {
        if (executionSemester == null || executionSemester.getRootDomainObject() != Bennu.getInstance()) {
            executionSemester = yearString == null || yearString.length() == 0 || semesterString == null || semesterString.length() == 0 ? null : ExecutionSemester.readBySemesterAndExecutionYear(Integer.valueOf(semesterString), yearString);
        }
        return executionSemester;
    }

    public static ExecutionSemester readMarkSheetManagmentExecutionPeriod() {
        markSheetManagmentExecutionPeriod = ExecutionSemester.readFromProperties(markSheetManagmentExecutionPeriod, FenixEduAcademicConfiguration.getConfiguration().getYearForFromMarkSheetManagment(), FenixEduAcademicConfiguration.getConfiguration().getSemesterForFromMarkSheetManagment());
        return markSheetManagmentExecutionPeriod;
    }

    public static ExecutionSemester readFirstBolonhaExecutionPeriod() {
        firstBolonhaExecutionPeriod = ExecutionSemester.readFromProperties(firstBolonhaExecutionPeriod, FenixEduAcademicConfiguration.getConfiguration().getStartYearForBolonhaDegrees(), FenixEduAcademicConfiguration.getConfiguration().getStartSemesterForBolonhaDegrees());
        return firstBolonhaExecutionPeriod;
    }

    public static ExecutionSemester readFirstBolonhaTransitionExecutionPeriod() {
        firstBolonhaTransitionExecutionPeriod = ExecutionSemester.readFromProperties(firstBolonhaTransitionExecutionPeriod, FenixEduAcademicConfiguration.getConfiguration().getStartYearForBolonhaTransition(), FenixEduAcademicConfiguration.getConfiguration().getStartSemesterForBolonhaTransition());
        return firstBolonhaTransitionExecutionPeriod;
    }

    public static ExecutionSemester readFirstEnrolmentsExecutionPeriod() {
        firstEnrolmentsExecutionPeriod = ExecutionSemester.readFromProperties(firstEnrolmentsExecutionPeriod, FenixEduAcademicConfiguration.getConfiguration().getYearForFromEnrolments(), FenixEduAcademicConfiguration.getConfiguration().getSemesterForFromEnrolments());
        return firstEnrolmentsExecutionPeriod;
    }

    public static ExecutionSemester readFirstExecutionSemester() {
        Set exeutionPeriods = Bennu.getInstance().getExecutionPeriodsSet();
        return exeutionPeriods.isEmpty() ? null : (ExecutionSemester)Collections.min(exeutionPeriods);
    }

    public static ExecutionSemester readLastExecutionSemester() {
        Set exeutionPeriods = Bennu.getInstance().getExecutionPeriodsSet();
        int size = exeutionPeriods.size();
        return size == 0 ? null : (size == 1 ? (ExecutionSemester)exeutionPeriods.iterator().next() : (ExecutionSemester)Collections.max(exeutionPeriods));
    }

    public static List<ExecutionSemester> readNotClosedExecutionPeriods() {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (executionSemester.isClosed()) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public static List<ExecutionSemester> readNotOpenExecutionPeriods() {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (executionSemester.isNotOpen()) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public static List<ExecutionSemester> readPublicExecutionPeriods() {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (executionSemester.isNotOpen()) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public static List<ExecutionSemester> readNotClosedPublicExecutionPeriods() {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (executionSemester.isClosed() || executionSemester.isNotOpen()) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public static List<ExecutionSemester> readExecutionPeriodsInTimePeriod(LocalDate beginDate, LocalDate endDate) {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (!executionSemester.isInTimePeriod(beginDate, endDate)) continue;
            result.add(executionSemester);
        }
        return result;
    }

    @Deprecated
    public static List<ExecutionSemester> readExecutionPeriodsInTimePeriod(Date beginDate, Date endDate) {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (!executionSemester.isInTimePeriod(beginDate, endDate)) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public static List<ExecutionSemester> readExecutionPeriod(YearMonthDay beginDate, YearMonthDay endDate) {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (!executionSemester.getBeginDateYearMonthDay().isEqual((ReadablePartial)beginDate) || !executionSemester.getEndDateYearMonthDay().isEqual((ReadablePartial)endDate)) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public static ExecutionSemester readByNameAndExecutionYear(String name, String year) {
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (!executionSemester.getName().equals(name) || !executionSemester.isFor(year)) continue;
            return executionSemester;
        }
        return null;
    }

    public static ExecutionSemester readBySemesterAndExecutionYear(Integer semester, String year) {
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (!executionSemester.isForSemesterAndYear(semester, year)) continue;
            return executionSemester;
        }
        return null;
    }

    public static ExecutionSemester readByDateTime(DateTime dateTime) {
        YearMonthDay yearMonthDay = dateTime.toYearMonthDay();
        return ExecutionSemester.readByYearMonthDay(yearMonthDay);
    }

    public static ExecutionSemester readByYearMonthDay(YearMonthDay yearMonthDay) {
        for (ExecutionSemester executionSemester : Bennu.getInstance().getExecutionPeriodsSet()) {
            if (!executionSemester.containsDay(yearMonthDay)) continue;
            return executionSemester;
        }
        return null;
    }

    public Stream<TeacherAuthorization> getTeacherAuthorizationStream() {
        return this.getTeacherAuthorizationSet().stream();
    }

    public Stream<TeacherAuthorization> getRevokedTeacherAuthorizationStream() {
        return this.getRevokedTeacherAuthorizationSet().stream();
    }

    public <E extends ExecutionInterval> E convert(Class<E> input) {
        Comparable<ExecutionYear> result = null;
        if (ExecutionYear.class.equals(input)) {
            result = this.getExecutionYear();
        } else if (ExecutionSemester.class.equals(input)) {
            result = this;
        }
        return (E)result;
    }
}

