/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class Country
extends Country_Base {
    public static final String PORTUGAL = "PORTUGAL";
    public static final String NATIONALITY_PORTUGUESE = "PORTUGUESA";
    public static final String DEFAULT_COUNTRY_NATIONALITY = "PORTUGUESA";
    public static Comparator<Country> COMPARATOR_BY_NAME = new Comparator<Country>(){

        @Override
        public int compare(Country leftCountry, Country rightCountry) {
            int comparationResult = Collator.getInstance().compare(leftCountry.getName(), rightCountry.getName());
            return comparationResult == 0 ? leftCountry.getExternalId().compareTo(rightCountry.getExternalId()) : comparationResult;
        }
    };
    private static Set<Country> CPLP_COUNTRIES;

    private Country() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setDefaultCountry(false);
    }

    public Country(MultiLanguageString localizedName, MultiLanguageString countryNationality, String code, String threeLetterCode) {
        this();
        this.setCode(code);
        this.setCountryNationality(countryNationality);
        this.setName(localizedName.getPreferedContent());
        this.setLocalizedName(localizedName);
        this.setThreeLetterCode(threeLetterCode);
    }

    public static Country readDefault() {
        for (Country country : Bennu.getInstance().getCountrysSet()) {
            if (!country.isDefaultCountry()) continue;
            return country;
        }
        return null;
    }

    public static Country readCountryByNationality(String nationality) {
        for (Country country : Bennu.getInstance().getCountrysSet()) {
            if (!country.getNationality().equals(nationality)) continue;
            return country;
        }
        return null;
    }

    public static Set<Country> readDistinctCountries() {
        HashSet<Country> result = new HashSet<Country>();
        for (Country country : Bennu.getInstance().getCountrysSet()) {
            if (!country.getName().equalsIgnoreCase(PORTUGAL)) {
                result.add(country);
                continue;
            }
            if (!country.getCountryNationality().getContent(MultiLanguageString.pt).equalsIgnoreCase("PORTUGUESA")) continue;
            result.add(country);
        }
        return result;
    }

    @Deprecated
    public String getFilteredNationality(Locale locale) {
        String nationality = this.getCountryNationality().getContent(locale);
        if (this != Country.readDefault()) {
            return nationality;
        }
        String specialCase = BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.person.portugueseNationality", (String[])new String[0]).toUpperCase();
        return nationality.trim().contains(specialCase) ? specialCase : nationality;
    }

    public boolean isDefaultCountry() {
        return this.getDefaultCountry();
    }

    public static Country readByTwoLetterCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        Country defaultCountry = Country.readDefault();
        if (defaultCountry.getCode().equalsIgnoreCase(code)) {
            return defaultCountry;
        }
        for (Country country : Bennu.getInstance().getCountrysSet()) {
            if (!country.getCode().equalsIgnoreCase(code)) continue;
            return country;
        }
        return null;
    }

    public static Country readByThreeLetterCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        Country defaultCountry = Country.readDefault();
        if (defaultCountry.getThreeLetterCode().equalsIgnoreCase(code)) {
            return defaultCountry;
        }
        for (Country country : Bennu.getInstance().getCountrysSet()) {
            if (country.getThreeLetterCode() == null || !country.getThreeLetterCode().equalsIgnoreCase(code)) continue;
            return country;
        }
        return null;
    }

    @Deprecated
    public String getNationality() {
        return this.getCountryNationality().getPreferedContent();
    }

    public static synchronized Set<Country> getCPLPCountries() {
        if (CPLP_COUNTRIES == null) {
            CPLP_COUNTRIES = new HashSet<Country>();
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("PT"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("BR"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("AO"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("CV"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("GW"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("MZ"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("ST"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("TL"));
            CPLP_COUNTRIES.add(Country.readByTwoLetterCode("MO"));
        }
        return CPLP_COUNTRIES;
    }

    public static boolean isCPLPCountry(Country country) {
        return Country.getCPLPCountries().contains((Object)country);
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

