/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.Alert_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public abstract class Alert
extends Alert_Base {
    public Alert() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setRootDomainObjectForActiveAlerts(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
    }

    protected void init(MultiLanguageString subject, MultiLanguageString body) {
        this.checkParameters(subject, body);
        super.setSubject(subject);
        super.setBody(body);
        super.setActive(Boolean.TRUE);
    }

    private void checkParameters(MultiLanguageString subject, MultiLanguageString body) {
        String[] args = new String[]{};
        if (subject == null) {
            throw new DomainException("error.alert.Alert.subject.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (body == null) {
            throw new DomainException("error.alert.Alert.body.cannot.be.null", args1);
        }
    }

    public void setSubject(MultiLanguageString subject) {
        throw new DomainException("error.alert.Alert.cannot.modify.subject", new String[0]);
    }

    public void setBody(MultiLanguageString body) {
        throw new DomainException("error.alert.Alert.cannot.modify.body", new String[0]);
    }

    public void setActive(Boolean active) {
        throw new DomainException("error.org.fenixedu.academic.domain.alert.Alert.cannot.modify.active", new String[0]);
    }

    public MultiLanguageString getBody() {
        throw new DomainException("error.org.fenixedu.academic.domain.alert.Alert.use.getFormattedBody.instead", new String[0]);
    }

    public MultiLanguageString getSubject() {
        throw new DomainException("error.org.fenixedu.academic.domain.alert.Alert.use.getFormattedSubject.instead", new String[0]);
    }

    public MultiLanguageString getFormattedBody() {
        return super.getBody();
    }

    public MultiLanguageString getFormattedSubject() {
        return super.getSubject();
    }

    public void fire() {
        if (this.isToDiscard()) {
            this.discard();
            return;
        }
        if (!this.isToFire()) {
            return;
        }
        this.generateMessage();
        super.setFireDate(new DateTime());
        if (this.isToDiscard()) {
            this.discard();
        }
    }

    public void discard() {
        super.setRootDomainObjectForActiveAlerts(null);
        super.setActive(Boolean.valueOf(false));
    }

    public abstract String getDescription();

    protected abstract boolean isToDiscard();

    protected abstract boolean isToFire();

    protected abstract void generateMessage();

    public abstract boolean isToSendMail();

    public boolean isCancelable() {
        return this.isToFire();
    }
}

