/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FenixDigestUtils {
    private static final Logger logger = LoggerFactory.getLogger(FenixDigestUtils.class);

    public static String createDigest(String data) {
        return Hashing.sha1().hashString((CharSequence)data, Charsets.UTF_8).toString();
    }

    public static void main(String[] args) {
        String res = FenixDigestUtils.createDigest("2qq asdsad1a zxfgsdf df 2s2ds2ah hdfg 18sgdyh12 12t rwdfg2sfg 5ty fdgh 13ert11yertyhsg  asdsadsa sdr sw1rt t s");
        String string = FenixDigestUtils.getPrettyCheckSum(res);
        logger.info(string);
    }

    public static String getPrettyCheckSum(String digest) {
        int digestLength = digest.length();
        if (digestLength % 2 == 1) {
            digest = "0" + digest;
            ++digestLength;
        }
        byte[] result = new byte[digestLength / 2];
        int i = 0;
        int min = 0;
        int max = 2;
        while (max <= digestLength) {
            result[i] = (byte)Integer.parseInt(digest.substring(min, max), 16);
            min += 2;
            max += 2;
            ++i;
        }
        BigDecimal bigDecimal = new BigDecimal("17");
        BigDecimal bigDecimal2 = new BigDecimal("101");
        for (int i2 = result.length; i2 > 0; --i2) {
            short a = (short)(0xFF & result[i2 - 1]);
            bigDecimal = bigDecimal.multiply(bigDecimal2).add(BigDecimal.valueOf(a + i2));
        }
        BigDecimal result2 = bigDecimal.remainder(new BigDecimal("99997"));
        return result2.abs().toPlainString();
    }
}

