/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.academic.ui.struts.action.mobility.outbound.OutboundMobilityContextBean;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class OutboundMobilityCandidacyGroupProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        OutboundMobilityContextBean contextBean = (OutboundMobilityContextBean)source;
        if (contextBean.getCandidacyPeriods().size() == 1) {
            return this.getCandidacyContestGroupSet((OutboundMobilityCandidacyPeriod)contextBean.getCandidacyPeriods().iterator().next());
        }
        TreeSet<OutboundMobilityCandidacyContestGroup> result = new TreeSet<OutboundMobilityCandidacyContestGroup>();
        for (OutboundMobilityCandidacyPeriod candidacyPeriod : contextBean.getCandidacyPeriods()) {
            result.addAll(this.getCandidacyContestGroupSet(candidacyPeriod));
        }
        return result;
    }

    public SortedSet<OutboundMobilityCandidacyContestGroup> getCandidacyContestGroupSet(OutboundMobilityCandidacyPeriod period) {
        User user = Authenticate.getUser();
        if (AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_MOBILITY_OUTBOUND).isMember(user)) {
            return period.getOutboundMobilityCandidacyContestGroupSet();
        }
        TreeSet<OutboundMobilityCandidacyContestGroup> result = new TreeSet<OutboundMobilityCandidacyContestGroup>();
        if (user != null && user.getPerson() != null) {
            for (OutboundMobilityCandidacyContestGroup group : user.getPerson().getOutboundMobilityCandidacyContestGroupSet()) {
                if (!this.hasContestForPeriod(period, group)) continue;
                result.add(group);
            }
        }
        return result;
    }

    private boolean hasContestForPeriod(OutboundMobilityCandidacyPeriod period, OutboundMobilityCandidacyContestGroup group) {
        for (OutboundMobilityCandidacyContest contest : group.getOutboundMobilityCandidacyContestSet()) {
            if (contest.getOutboundMobilityCandidacyPeriod() != period) continue;
            return true;
        }
        return false;
    }

    public Converter getConverter() {
        return null;
    }
}

