/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import pt.ist.fenixWebFramework.rendererExtensions.AutoCompleteInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public class AutoCompleteInputRendererWithPostBack
extends AutoCompleteInputRenderer {
    private static final String HIDDEN_NAME = "postback";
    private String destination;

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public HtmlComponent render(Object object, Class type) {
        String prefix = HtmlComponent.getValidIdOrName((String)((MetaSlot)this.getInputContext().getMetaObject()).getKey().toString().replaceAll("\\.", "_").replaceAll("\\:", "_"));
        HtmlHiddenField hidden = new HtmlHiddenField(prefix + HIDDEN_NAME, "");
        HtmlBlockContainer container = (HtmlBlockContainer)super.render(object, type);
        HtmlHiddenField hiddenValue = null;
        for (HtmlComponent childComponent : container.getChildren()) {
            if (!(childComponent instanceof HtmlHiddenField) || !childComponent.getId().endsWith("_AutoComplete")) continue;
            hiddenValue = (HtmlHiddenField)childComponent;
        }
        hiddenValue.setOnChange("this.form." + prefix + HIDDEN_NAME + ".value='true';this.form.submit();");
        hiddenValue.setController((HtmlController)new PostBackController(hidden, this.getDestination()));
        container.addChild((HtmlComponent)hidden);
        return container;
    }

    private static class PostBackController
    extends HtmlController {
        private final HtmlHiddenField hidden;
        private final String destination;

        public PostBackController(HtmlHiddenField hidden, String destination) {
            this.hidden = hidden;
            this.destination = destination;
        }

        public void execute(IViewState viewState) {
            if (this.hidden.getValue() != null && this.hidden.getValue().equalsIgnoreCase("true")) {
                String destinationName = this.destination == null ? AutoCompleteInputRendererWithPostBack.HIDDEN_NAME : this.destination;
                ViewDestination destination = viewState.getDestination(destinationName);
                if (destination != null) {
                    viewState.setCurrentDestination(destination);
                } else {
                    viewState.setCurrentDestination("postBack");
                }
                this.hidden.setValue("false");
                viewState.setSkipValidation(true);
            }
        }
    }
}

