/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.json.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.json.JsonViewer;

@DefaultJsonAdapter(value=Shift.class)
public class ShiftJsonAdapter
implements JsonViewer<Shift> {
    public JsonElement view(Shift shift, JsonBuilder ctx) {
        JsonObject object = new JsonObject();
        object.addProperty("shortName", shift.getNome());
        object.addProperty("name", shift.getPresentationName());
        object.addProperty("externalId", shift.getExternalId());
        object.add("lessons", ctx.view(shift.getLessonsOrderedByWeekDayAndStartTime()));
        object.addProperty("capacity", (Number)shift.getLotacao());
        if (shift.getShiftGroupingProperties() != null && shift.getShiftGroupingProperties().getCapacity() != null) {
            object.addProperty("groupCapacity", (Number)shift.getShiftGroupingProperties().getCapacity());
        }
        object.add("shiftTypes", ctx.view(shift.getTypes()));
        return object;
    }
}

