/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.transactions;

import java.sql.Timestamp;
import org.fenixedu.academic.domain.transactions.PaymentTransaction;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.domain.transactions.ReimbursementTransaction;
import org.fenixedu.academic.domain.transactions.Transaction;
import org.fenixedu.academic.domain.transactions.TransactionType;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoPerson;
import org.fenixedu.academic.dto.InfoPersonAccount;
import org.fenixedu.academic.dto.transactions.InfoPaymentTransaction;
import org.fenixedu.academic.dto.transactions.InfoReimbursementTransaction;
import pt.ist.fenixframework.DomainObject;

public abstract class InfoTransaction
extends InfoObject {
    private Double value;
    private Timestamp transactionDate;
    private String remarks;
    private PaymentType paymentType;
    private TransactionType transactionType;
    private Boolean wasInternalBalance;
    private InfoPerson infoResponsiblePerson;
    private InfoPersonAccount infoPersonAccount;

    public static InfoTransaction newInfoFromDomain(Transaction transaction) {
        InfoTransaction infoTransaction = null;
        if (transaction instanceof PaymentTransaction) {
            infoTransaction = InfoPaymentTransaction.newInfoFromDomain((PaymentTransaction)((Object)transaction));
        } else if (transaction instanceof ReimbursementTransaction) {
            infoTransaction = InfoReimbursementTransaction.newInfoFromDomain((ReimbursementTransaction)((Object)transaction));
        }
        return infoTransaction;
    }

    protected void copyFromDomain(Transaction transaction) {
        super.copyFromDomain((DomainObject)transaction);
        this.paymentType = transaction.getPaymentType();
        this.remarks = transaction.getRemarks();
        if (transaction.getTransactionDate() != null) {
            this.setTransactionDate(new Timestamp(transaction.getTransactionDate().getTime()));
        }
        this.transactionType = transaction.getTransactionType();
        this.value = transaction.getValue();
        this.wasInternalBalance = transaction.getWasInternalBalance();
    }

    public InfoPersonAccount getInfoPersonAccount() {
        return this.infoPersonAccount;
    }

    public void setInfoPersonAccount(InfoPersonAccount infoPersonAccount) {
        this.infoPersonAccount = infoPersonAccount;
    }

    public InfoPerson getInfoResponsiblePerson() {
        return this.infoResponsiblePerson;
    }

    public void setInfoResponsiblePerson(InfoPerson infoResponsiblePerson) {
        this.infoResponsiblePerson = infoResponsiblePerson;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Timestamp getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Timestamp transactionDate) {
        this.transactionDate = transactionDate;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Boolean getWasInternalBalance() {
        return this.wasInternalBalance;
    }

    public void setWasInternalBalance(Boolean wasInternalBalance) {
        this.wasInternalBalance = wasInternalBalance;
    }
}

