/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.photographs;

import java.io.Serializable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PhotoState;
import org.fenixedu.academic.domain.PhotoType;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.person.HumanName;
import org.fenixedu.academic.domain.person.RoleType;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PhotographFilterBean
implements Serializable {
    private static final long serialVersionUID = -6023622162590978369L;
    private PhotoState state;
    private PhotoType type;
    private LocalDate startDate;
    private LocalDate endDate;
    private RoleType personType;
    private String name;

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public PhotoState getState() {
        return this.state;
    }

    public void setState(PhotoState state) {
        this.state = state;
    }

    public PhotoType getType() {
        return this.type;
    }

    public void setType(PhotoType type) {
        this.type = type;
    }

    public RoleType getPersonType() {
        return this.personType;
    }

    public void setPersonType(RoleType personType) {
        this.personType = personType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean processDates(Photograph photograph) {
        if (this.getStartDate() != null && this.getStartDate().isAfter((ReadablePartial)photograph.getStateChange().toDateMidnight().toLocalDate()) && this.getEndDate() != null && this.getStartDate().isAfter((ReadablePartial)this.getEndDate())) {
            return true;
        }
        return this.getEndDate() != null && this.getEndDate().isBefore((ReadablePartial)photograph.getStateChange().toDateMidnight().toLocalDate()) && this.getStartDate() != null && this.getEndDate().isBefore((ReadablePartial)this.getStartDate());
    }

    public boolean accepts(Photograph photograph) {
        if (this.getState() != null && photograph.getState() != this.getState()) {
            return false;
        }
        if (this.getType() != null && photograph.getPhotoType() != this.getType()) {
            return false;
        }
        if (this.processDates(photograph)) {
            return false;
        }
        Person person = photograph.getPerson();
        if (person != null) {
            if (this.getPersonType() != null && !this.getPersonType().isMember(person.getUser())) {
                return false;
            }
            return this.getName() == null || HumanName.namesMatch(person.getName(), this.name);
        }
        return false;
    }
}

