/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentDeclarationRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class EnrolmentDeclarationRequest
extends EnrolmentDeclarationRequest_Base {
    private static final int MAX_FREE_DECLARATIONS_PER_EXECUTION_YEAR = 4;

    protected EnrolmentDeclarationRequest() {
    }

    public EnrolmentDeclarationRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkRulesToCreate(bean);
    }

    private void checkRulesToCreate(DocumentRequestCreateBean bean) {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (!bean.getRegistration().hasAnyEnrolmentsIn(currentExecutionYear)) {
            throw new DomainException("EnrolmentDeclarationRequest.no.enrolments.for.registration.in.current.executionYear", new String[0]);
        }
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.ENROLMENT_DECLARATION;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final EventType getEventType() {
        return EventType.ENROLMENT_DECLARATION_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    public final Integer getNumberOfUnits() {
        return this.getEntriesToReport().size() + this.getExtraCurricularEntriesToReport().size() + this.getPropaedeuticEntriesToReport().size();
    }

    public final Collection<Enrolment> getEntriesToReport() {
        return this.getRegistration().getLatestCurricularCoursesEnrolments(this.getExecutionYear());
    }

    public final Collection<Enrolment> getExtraCurricularEntriesToReport() {
        HashSet<Enrolment> extraCurricular = new HashSet<Enrolment>();
        for (Enrolment entry : this.getRegistration().getLatestCurricularCoursesEnrolments(this.getExecutionYear())) {
            if (!entry.isExtraCurricular() || !entry.getEnrolmentWrappersSet().isEmpty()) continue;
            extraCurricular.add(entry);
        }
        return extraCurricular;
    }

    public final Collection<Enrolment> getPropaedeuticEntriesToReport() {
        HashSet<Enrolment> propaedeutic = new HashSet<Enrolment>();
        for (Enrolment entry : this.getRegistration().getLatestCurricularCoursesEnrolments(this.getExecutionYear())) {
            if (entry.isExtraCurricular() && entry.getEnrolmentWrappersSet().isEmpty() || !entry.isPropaedeutic()) continue;
            propaedeutic.add(entry);
        }
        return propaedeutic;
    }

    protected boolean hasFreeDeclarationRequests() {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        Set<DocumentRequest> schoolRegistrationDeclarations = this.getRegistration().getSucessfullyFinishedDocumentRequestsBy(currentExecutionYear, DocumentRequestType.SCHOOL_REGISTRATION_DECLARATION, false);
        Set<DocumentRequest> enrolmentDeclarations = this.getRegistration().getSucessfullyFinishedDocumentRequestsBy(currentExecutionYear, DocumentRequestType.ENROLMENT_DECLARATION, false);
        return schoolRegistrationDeclarations.size() + enrolmentDeclarations.size() < 4;
    }
}

