/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramUnit;
import org.fenixedu.academic.domain.phd.debts.PhdEventExemption;
import org.fenixedu.academic.domain.phd.debts.PhdEvent_Base;
import org.fenixedu.academic.util.LabelFormatter;

public abstract class PhdEvent
extends PhdEvent_Base {
    protected PhdEvent() {
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public Account getToAccount() {
        return this.getUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected PhdProgramUnit getUnit() {
        return this.getPhdProgram().getPhdProgramUnit();
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        return new LabelFormatter().appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(this.getPhdProgram().getName().getContent()).appendLabel(")");
    }

    protected abstract PhdProgram getPhdProgram();

    public PostingRule getPostingRule() {
        return this.getPhdProgram().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public boolean hasPhdEventExemption() {
        return this.getPhdEventExemption() != null;
    }

    public PhdEventExemption getPhdEventExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof PhdEventExemption)) continue;
            return (PhdEventExemption)((Object)exemption);
        }
        return null;
    }

    public boolean isPhdEvent() {
        return true;
    }

    public abstract PhdIndividualProgramProcess getPhdIndividualProgramProcess();

    public boolean isPhdThesisRequestFee() {
        return false;
    }
}

