/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.QualificationBean;
import org.fenixedu.academic.domain.phd.ExternalPhdProgram;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.ThesisSubject;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.domain.phd.candidacy.PhdThesisSubjectOrderBean;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.joda.time.LocalDate;

public class PhdProgramCandidacyProcessBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PersonBean personBean;
    private LocalDate candidacyDate;
    private PhdProgram program;
    private ExecutionYear executionYear;
    private Degree degree;
    private String thesisTitle;
    private PhdIndividualProgramCollaborationType collaborationType;
    private String otherCollaborationType;
    private ChoosePersonBean choosePersonBean;
    private String email;
    private String captcha;
    private String institutionId;
    private PhdProgramCandidacyProcessState state = PhdProgramCandidacyProcessState.STAND_BY_WITH_MISSING_INFORMATION;
    private PhdProgramPublicCandidacyHashCode candidacyHashCode;
    private PhdProgramFocusArea focusArea;
    private List<PhdThesisSubjectOrderBean> thesisSubjectBeans;
    private List<PhdParticipantBean> guidings;
    private List<QualificationBean> qualifications;
    private List<PhdCandidacyRefereeBean> candidacyReferees;
    private PhdProgramDocumentUploadBean curriculumVitae;
    private PhdProgramDocumentUploadBean identificationDocument;
    private PhdProgramDocumentUploadBean motivationLetter;
    private PhdProgramDocumentUploadBean socialSecurityDocument;
    private PhdProgramDocumentUploadBean researchPlan;
    private PhdProgramDocumentUploadBean dissertationOrFinalWorkDocument;
    private List<PhdProgramDocumentUploadBean> habilitationCertificateDocuments;
    private List<PhdProgramDocumentUploadBean> phdGuidingLetters;
    private ExternalPhdProgram externalPhdProgram;
    private Boolean migratedProcess = false;
    private Integer phdStudentNumber;
    private LocalDate whenRatified;
    private PhdProgramCandidacyProcess process;
    private PhdCandidacyPeriod phdCandidacyPeriod;
    private LocalDate stateDate;

    public PhdProgramCandidacyProcessBean() {
        this.setCandidacyDate(new LocalDate());
        this.thesisSubjectBeans = new ArrayList<PhdThesisSubjectOrderBean>();
    }

    public PhdProgramCandidacyProcessBean(PhdProgramCandidacyProcess process2) {
        this.setCandidacyDate(process2.getCandidacyDate());
        this.setWhenRatified(process2.getWhenRatified());
        this.setCandidacyHashCode(process2.getCandidacyHashCode());
        this.process = process2;
    }

    public LocalDate getCandidacyDate() {
        return this.candidacyDate;
    }

    public void setCandidacyDate(LocalDate candidacyDate) {
        this.candidacyDate = candidacyDate;
    }

    public PhdProgram getProgram() {
        return this.program;
    }

    public void setProgram(PhdProgram program) {
        this.program = program;
    }

    public PersonBean getPersonBean() {
        return this.personBean;
    }

    public void setPersonBean(PersonBean personBean) {
        this.personBean = personBean;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public boolean hasDegree() {
        return this.getDegree() != null;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public ExecutionDegree getExecutionDegree() {
        return this.hasDegree() ? null : this.getDegree().getLastActiveDegreeCurricularPlan().getExecutionDegreeByAcademicInterval(this.getExecutionYear().getAcademicInterval());
    }

    public String getThesisTitle() {
        return this.thesisTitle;
    }

    public void setThesisTitle(String thesisTitle) {
        this.thesisTitle = thesisTitle;
    }

    public PhdIndividualProgramCollaborationType getCollaborationType() {
        return this.collaborationType;
    }

    public void setCollaborationType(PhdIndividualProgramCollaborationType collaborationType) {
        this.collaborationType = collaborationType;
    }

    public boolean hasCollaborationType() {
        return this.getCollaborationType() != null;
    }

    public String getOtherCollaborationType() {
        return this.otherCollaborationType;
    }

    public void setOtherCollaborationType(String otherCollaborationType) {
        this.otherCollaborationType = otherCollaborationType;
    }

    public ChoosePersonBean getChoosePersonBean() {
        return this.choosePersonBean;
    }

    public void setChoosePersonBean(ChoosePersonBean choosePersonBean) {
        this.choosePersonBean = choosePersonBean;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCaptcha() {
        return this.captcha;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public boolean hasInstitutionId() {
        return !StringUtils.isEmpty((String)this.institutionId);
    }

    public PhdProgramCandidacyProcessState getState() {
        return this.state;
    }

    public void setState(PhdProgramCandidacyProcessState state) {
        this.state = state;
    }

    public PhdProgramPublicCandidacyHashCode getCandidacyHashCode() {
        return this.candidacyHashCode;
    }

    public void setCandidacyHashCode(PhdProgramPublicCandidacyHashCode candidacyHashCode) {
        this.candidacyHashCode = candidacyHashCode;
    }

    public PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.getCandidacyHashCode().getIndividualProgramProcess();
    }

    public boolean hasCandidacyHashCode() {
        return this.getCandidacyHashCode() != null;
    }

    public PhdProgramFocusArea getFocusArea() {
        return this.focusArea;
    }

    public boolean hasFocusArea() {
        return this.getFocusArea() != null;
    }

    public void setFocusArea(PhdProgramFocusArea focusArea) {
        this.focusArea = focusArea;
    }

    public List<PhdParticipantBean> getGuidings() {
        return this.guidings;
    }

    public void setGuidings(List<PhdParticipantBean> guidings) {
        this.guidings = guidings;
    }

    public boolean hasAnyGuiding() {
        return this.guidings != null && !this.guidings.isEmpty();
    }

    public void addGuiding(PhdParticipantBean guiding) {
        this.guidings.add(guiding);
    }

    public void removeGuiding(int index) {
        this.guidings.remove(index);
    }

    public List<QualificationBean> getQualifications() {
        return this.qualifications;
    }

    public void setQualifications(List<QualificationBean> qualifications) {
        this.qualifications = qualifications;
    }

    public void addQualification(QualificationBean qualification) {
        this.qualifications.add(qualification);
    }

    public void removeQualification(int index) {
        this.qualifications.remove(index);
    }

    public boolean hasAnyQualification() {
        return this.qualifications != null && !this.qualifications.isEmpty();
    }

    public void sortQualificationsByAttendedEnd() {
        Collections.sort(this.qualifications, QualificationBean.COMPARATOR_BY_MOST_RECENT_ATTENDED_END);
    }

    public List<PhdCandidacyRefereeBean> getCandidacyReferees() {
        return this.candidacyReferees;
    }

    public void setCandidacyReferees(List<PhdCandidacyRefereeBean> candidacyReferees) {
        this.candidacyReferees = candidacyReferees;
    }

    public void addCandidacyReferee(PhdCandidacyRefereeBean phdCandidacyRefereeBean) {
        this.candidacyReferees.add(phdCandidacyRefereeBean);
    }

    public void removeCandidacyReferee(int index) {
        this.candidacyReferees.remove(index);
    }

    public boolean hasAnyCandidacyReferee() {
        return this.candidacyReferees != null && !this.candidacyReferees.isEmpty();
    }

    public void clearPerson() {
        this.getPersonBean().setPerson(null);
    }

    public PhdProgramDocumentUploadBean getCurriculumVitae() {
        return this.curriculumVitae;
    }

    public void setCurriculumVitae(PhdProgramDocumentUploadBean curriculumVitae) {
        this.curriculumVitae = curriculumVitae;
    }

    public PhdProgramDocumentUploadBean getIdentificationDocument() {
        return this.identificationDocument;
    }

    public void setIdentificationDocument(PhdProgramDocumentUploadBean identificationDocument) {
        this.identificationDocument = identificationDocument;
    }

    public PhdProgramDocumentUploadBean getMotivationLetter() {
        return this.motivationLetter;
    }

    public void setMotivationLetter(PhdProgramDocumentUploadBean motivationLetter) {
        this.motivationLetter = motivationLetter;
    }

    public PhdProgramDocumentUploadBean getSocialSecurityDocument() {
        return this.socialSecurityDocument;
    }

    public void setSocialSecurityDocument(PhdProgramDocumentUploadBean socialSecurityDocument) {
        this.socialSecurityDocument = socialSecurityDocument;
    }

    public PhdProgramDocumentUploadBean getResearchPlan() {
        return this.researchPlan;
    }

    public void setResearchPlan(PhdProgramDocumentUploadBean researchPlan) {
        this.researchPlan = researchPlan;
    }

    public PhdProgramDocumentUploadBean getDissertationOrFinalWorkDocument() {
        return this.dissertationOrFinalWorkDocument;
    }

    public void setDissertationOrFinalWorkDocument(PhdProgramDocumentUploadBean dissertationOrFinalWorkDocument) {
        this.dissertationOrFinalWorkDocument = dissertationOrFinalWorkDocument;
    }

    public List<PhdProgramDocumentUploadBean> getHabilitationCertificateDocuments() {
        return this.habilitationCertificateDocuments;
    }

    public void setHabilitationCertificateDocuments(List<PhdProgramDocumentUploadBean> habilitationCertificateDocuments) {
        this.habilitationCertificateDocuments = habilitationCertificateDocuments;
    }

    public void addHabilitationCertificateDocument(PhdProgramDocumentUploadBean document) {
        this.habilitationCertificateDocuments.add(document);
    }

    public void removeHabilitationCertificateDocument(int index) {
        this.habilitationCertificateDocuments.remove(index);
    }

    public void removeHabilitationCertificateDocumentFiles() {
        for (PhdProgramDocumentUploadBean bean : this.getHabilitationCertificateDocuments()) {
            bean.setFile(null);
        }
    }

    public List<PhdProgramDocumentUploadBean> getPhdGuidingLetters() {
        return this.phdGuidingLetters;
    }

    public void setPhdGuidingLetters(List<PhdProgramDocumentUploadBean> phdGuidingLetters) {
        this.phdGuidingLetters = phdGuidingLetters;
    }

    public ExternalPhdProgram getExternalPhdProgram() {
        return this.externalPhdProgram;
    }

    public void setExternalPhdProgram(ExternalPhdProgram externalPhdProgram) {
        this.externalPhdProgram = externalPhdProgram;
    }

    public void removePhdGuidingLetters() {
        for (PhdProgramDocumentUploadBean bean : this.getPhdGuidingLetters()) {
            bean.setFile(null);
        }
    }

    public Boolean getMigratedProcess() {
        return this.migratedProcess;
    }

    public void setMigratedProcess(Boolean migratedProcess) {
        this.migratedProcess = migratedProcess;
    }

    public Integer getPhdStudentNumber() {
        return this.phdStudentNumber;
    }

    public void setPhdStudentNumber(Integer phdStudentNumber) {
        this.phdStudentNumber = phdStudentNumber;
    }

    public boolean hasPhdStudentNumber() {
        return this.getPhdStudentNumber() != null;
    }

    public List<PhdProgramDocumentUploadBean> getAllDocuments() {
        ArrayList<PhdProgramDocumentUploadBean> result = new ArrayList<PhdProgramDocumentUploadBean>();
        result.add(this.getCurriculumVitae());
        result.add(this.getIdentificationDocument());
        result.add(this.getMotivationLetter());
        if (this.getSocialSecurityDocument().hasAnyInformation()) {
            result.add(this.getSocialSecurityDocument());
        }
        if (this.getResearchPlan().hasAnyInformation()) {
            result.add(this.getResearchPlan());
        }
        if (this.getDissertationOrFinalWorkDocument().hasAnyInformation()) {
            result.add(this.getDissertationOrFinalWorkDocument());
        }
        for (PhdProgramDocumentUploadBean bean : this.getHabilitationCertificateDocuments()) {
            if (!bean.hasAnyInformation()) continue;
            result.add(bean);
        }
        for (PhdProgramDocumentUploadBean bean : this.getPhdGuidingLetters()) {
            if (!bean.hasAnyInformation()) continue;
            result.add(bean);
        }
        return result;
    }

    public LocalDate getWhenRatified() {
        return this.whenRatified;
    }

    public void setWhenRatified(LocalDate whenRatified) {
        this.whenRatified = whenRatified;
    }

    public PhdProgramCandidacyProcess getProcess() {
        return this.process;
    }

    public void setProcess(PhdProgramCandidacyProcess process2) {
        this.process = process2;
    }

    public PhdCandidacyPeriod getPhdCandidacyPeriod() {
        return this.phdCandidacyPeriod;
    }

    public void setPhdCandidacyPeriod(PhdCandidacyPeriod phdCandidacyPeriod) {
        this.phdCandidacyPeriod = phdCandidacyPeriod;
    }

    public LocalDate getStateDate() {
        return this.stateDate;
    }

    public void setStateDate(LocalDate stateDate) {
        this.stateDate = stateDate;
    }

    public List<PhdThesisSubjectOrderBean> getThesisSubjectBeans() {
        return this.thesisSubjectBeans;
    }

    public void addThesisSubjectBean(PhdThesisSubjectOrderBean thesisSubjectBean) {
        this.thesisSubjectBeans.add(thesisSubjectBean);
        this.sortThesisSubjectBeans();
    }

    public PhdThesisSubjectOrderBean getThesisSubjectBean(int order) {
        for (PhdThesisSubjectOrderBean bean : this.getThesisSubjectBeans()) {
            if (bean.getOrder() != order) continue;
            return bean;
        }
        return null;
    }

    public void sortThesisSubjectBeans() {
        Collections.sort(this.thesisSubjectBeans, PhdThesisSubjectOrderBean.COMPARATOR_BY_ORDER);
    }

    public void updateThesisSubjectBeans() {
        int order = 1;
        this.getThesisSubjectBeans().clear();
        if (this.hasFocusArea()) {
            for (ThesisSubject thesisSubject : this.getFocusArea().getThesisSubjectsSet()) {
                this.addThesisSubjectBean(new PhdThesisSubjectOrderBean(order++, thesisSubject));
            }
        }
    }
}

