/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.YearMonthDay;

public class UnitUtils {
    public static List<Unit> readAllExternalInstitutionUnits() {
        ArrayList<Unit> allExternalUnits = new ArrayList<Unit>();
        allExternalUnits.addAll(UnitUtils.readExternalInstitutionUnit().getAllSubUnits());
        return allExternalUnits;
    }

    public static Unit readExternalInstitutionUnitByName(String name) {
        for (Unit unit : UnitUtils.readAllExternalInstitutionUnits()) {
            if (!unit.getName().equals(name)) continue;
            return unit;
        }
        return null;
    }

    public static List<Unit> readAllUnitsWithoutParents() {
        ArrayList<Unit> allUnitsWithoutParent = new ArrayList<Unit>();
        for (Party party : Bennu.getInstance().getPartysSet()) {
            Unit unit;
            if (!party.isUnit() || !(unit = (Unit)((Object)party)).getParentUnits().isEmpty()) continue;
            allUnitsWithoutParent.add(unit);
        }
        return allUnitsWithoutParent;
    }

    public static List<Unit> readAllInternalActiveUnitsThatCanBeResponsibleOfSpaces() {
        ArrayList<Unit> result = new ArrayList<Unit>();
        YearMonthDay now = new YearMonthDay();
        Unit institutionUnit = UnitUtils.readInstitutionUnit();
        if (institutionUnit != null) {
            if (institutionUnit.getCanBeResponsibleOfSpaces().booleanValue() && institutionUnit.isActive(now)) {
                result.add(institutionUnit);
            }
            for (Unit subUnit : institutionUnit.getSubUnits()) {
                if (subUnit.getCanBeResponsibleOfSpaces().booleanValue() && subUnit.isActive(now)) {
                    result.add(subUnit);
                }
                UnitUtils.readAllInternalActiveSubUnitsThatCanBeResponsibleOfSpaces(result, subUnit, now);
            }
        }
        return result;
    }

    private static void readAllInternalActiveSubUnitsThatCanBeResponsibleOfSpaces(List<Unit> result, Unit subUnit, YearMonthDay now) {
        for (Unit unit : subUnit.getSubUnits()) {
            if (unit.getCanBeResponsibleOfSpaces().booleanValue() && unit.isActive(now)) {
                result.add(unit);
            }
            UnitUtils.readAllInternalActiveSubUnitsThatCanBeResponsibleOfSpaces(result, unit, now);
        }
    }

    public static List<Unit> readAllActiveUnitsByType(PartyTypeEnum type) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        YearMonthDay now = new YearMonthDay();
        PartyType partyType = PartyType.readPartyTypeByType(type);
        if (partyType != null) {
            Set parties = partyType.getPartiesSet();
            for (Party party : parties) {
                Unit unit;
                if (!party.isUnit() || !(unit = (Unit)((Object)party)).isActive(now)) continue;
                result.add(unit);
            }
        }
        return result;
    }

    public static List<Unit> readAllActiveUnitsByClassification(UnitClassification unitClassification) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        YearMonthDay now = new YearMonthDay();
        if (unitClassification != null) {
            for (Party party : Bennu.getInstance().getPartysSet()) {
                Unit unit;
                if (!party.isUnit() || (unit = (Unit)((Object)party)).getClassification() == null || !unit.getClassification().equals((Object)unitClassification) || !unit.isActive(now)) continue;
                result.add(unit);
            }
        }
        return result;
    }

    public static List<DepartmentUnit> readAllDepartmentUnits() {
        ArrayList<DepartmentUnit> result = new ArrayList<DepartmentUnit>();
        List<Unit> readAllActiveUnitsByType = UnitUtils.readAllActiveUnitsByType(PartyTypeEnum.DEPARTMENT);
        for (Unit unit : readAllActiveUnitsByType) {
            result.add((DepartmentUnit)((Object)unit));
        }
        return result;
    }

    public static Unit readUnitWithoutParentstByAcronym(String acronym) {
        for (Unit topUnit : UnitUtils.readAllUnitsWithoutParents()) {
            if (topUnit.getAcronym() == null || !topUnit.getAcronym().equals(acronym)) continue;
            return topUnit;
        }
        return null;
    }

    public static Unit readExternalInstitutionUnit() {
        return Bennu.getInstance().getExternalInstitutionUnit();
    }

    public static Unit readInstitutionUnit() {
        return Bennu.getInstance().getInstitutionUnit();
    }

    public static Unit readEarthUnit() {
        return Bennu.getInstance().getEarthUnit();
    }

    public static Set<Unit> readExternalUnitsByNameAndTypes(String unitName, List<PartyTypeEnum> types) {
        if (unitName == null) {
            return Collections.emptySet();
        }
        Collection<UnitName> units = UnitName.findExternalUnit(unitName.replace('%', ' '), Integer.MAX_VALUE);
        HashSet<Unit> result = new HashSet<Unit>();
        for (UnitName un : units) {
            Unit unit = un.getUnit();
            if (!types.contains((Object)unit.getType())) continue;
            result.add(unit);
        }
        return result;
    }

    public static List<Unit> getUnitFullPath(Unit unit, List<AccountabilityTypeEnum> validAccountabilityTypes) {
        Collection<Unit> parentUnits = unit.getParentUnits(validAccountabilityTypes);
        if (parentUnits.isEmpty()) {
            return Collections.emptyList();
        }
        if (parentUnits.size() == 1) {
            ArrayList<Unit> result = new ArrayList<Unit>();
            result.add(unit);
            result.addAll(0, UnitUtils.getUnitFullPath(parentUnits.iterator().next(), validAccountabilityTypes));
            return result;
        }
        throw new DomainException("error.unitUtils.unit.full.path.has.more.than.one.parent", new String[0]);
    }

    public static StringBuilder getUnitFullPathName(Unit unit, List<AccountabilityTypeEnum> validAccountabilityTypes) {
        if (unit == UnitUtils.readEarthUnit()) {
            return new StringBuilder(0);
        }
        Collection<Unit> parentUnits = unit.getParentUnits(validAccountabilityTypes);
        if (parentUnits.isEmpty()) {
            return new StringBuilder(unit.getName());
        }
        if (parentUnits.size() == 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(parentUnits.iterator().next() == UnitUtils.readEarthUnit() ? "" : " > ").append(unit.getName());
            builder.insert(0, UnitUtils.getUnitFullPathName(parentUnits.iterator().next(), validAccountabilityTypes));
            return builder;
        }
        throw new DomainException("error.unitUtils.unit.full.path.has.more.than.one.parent", new String[0]);
    }

    public static List<Unit> readExternalUnitsByNameAndTypesStartingAtEarth(String unitName, List<PartyTypeEnum> types) {
        if (unitName == null) {
            return Collections.emptyList();
        }
        String nameToSearch = Normalizer.normalize(unitName.replaceAll("%", ".*").toLowerCase(), Normalizer.Form.NFD).replaceAll("\\s", " ").replaceAll("[^\\p{ASCII}]", "");
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (UnitName name : Bennu.getInstance().getUnitNameSet()) {
            String current = Normalizer.normalize(name.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("\\s", " ").replaceAll("[^\\p{ASCII}]", "");
            if (!current.matches(nameToSearch) || !name.getIsExternalUnit().booleanValue() || !types.contains((Object)name.getUnit().getType())) continue;
            result.add(name.getUnit());
        }
        return result;
    }

    public static Collection<Unit> readAllUnitsWithClassification(UnitClassification classification) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (Party party : Bennu.getInstance().getPartysSet()) {
            Unit unit;
            UnitClassification unitClassification;
            if (!party.isUnit() || (unitClassification = (unit = (Unit)((Object)party)).getClassification()) == null || !unitClassification.equals((Object)classification)) continue;
            result.add(unit);
        }
        return result;
    }
}

