/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PlanetUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class PlanetUnit
extends PlanetUnit_Base {
    private PlanetUnit() {
        super.setType(PartyTypeEnum.PLANET);
    }

    public static PlanetUnit createNewPlanetUnit(MultiLanguageString planetName, String planetNameCard, Integer costCenterCode, String planetAcronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        PlanetUnit planetUnit = new PlanetUnit();
        planetUnit.init(planetName, planetNameCard, costCenterCode, planetAcronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        PlanetUnit.checkIfAlreadyExistsOnePlanetWithSameAcronymAndName(planetUnit);
        return planetUnit;
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        PlanetUnit.checkIfAlreadyExistsOnePlanetWithSameAcronymAndName(this);
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        throw new DomainException("error.unit.cannot.have.parentUnit", new String[0]);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.unit.empty.acronym", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public boolean isPlanetUnit() {
        return true;
    }

    private static void checkIfAlreadyExistsOnePlanetWithSameAcronymAndName(PlanetUnit planetUnit) {
        for (Unit unit : UnitUtils.readAllUnitsWithoutParents()) {
            if (unit.equals((Object)planetUnit) || !unit.isPlanetUnit() || !planetUnit.getAcronym().equalsIgnoreCase(unit.getAcronym()) && !planetUnit.getName().equalsIgnoreCase(unit.getName())) continue;
            throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
        }
    }
}

