/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup$callable$createCycleCourseGroupInformation;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroupInformation;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CycleCourseGroup
extends CycleCourseGroup_Base {
    public static final Advice advice$createCycleCourseGroupInformation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CycleCourseGroup() {
    }

    public CycleCourseGroup(RootCourseGroup parentCourseGroup, String name, String nameEn, CycleType cycleType, ExecutionSemester begin, ExecutionSemester end) {
        if (cycleType == null) {
            throw new DomainException("error.degreeStructure.CycleCourseGroup.cycle.type.cannot.be.null", new String[0]);
        }
        this.init((CourseGroup)((Object)parentCourseGroup), name, nameEn, begin, end);
        this.setCycleType(cycleType);
    }

    public void delete() {
        this.getSourceAffinitiesSet().clear();
        this.getDestinationAffinitiesSet().clear();
        super.delete();
    }

    public boolean isCycleCourseGroup() {
        return true;
    }

    public final String getGraduateTitleSuffix(ExecutionYear executionYear, Locale locale) {
        CycleCourseGroupInformation courseGroupInformationForSuffix = this.getMostRecentCycleCourseGroupInformation(executionYear, true);
        if (courseGroupInformationForSuffix != null) {
            return courseGroupInformationForSuffix.getGraduateTitleSuffix().getContent(locale);
        }
        return null;
    }

    public boolean isFirstCycle() {
        return this.getCycleType() == CycleType.FIRST_CYCLE;
    }

    public boolean isSecondCycle() {
        return this.getCycleType() == CycleType.SECOND_CYCLE;
    }

    public boolean isThirdCycle() {
        return this.getCycleType() == CycleType.THIRD_CYCLE;
    }

    public boolean isSpecializationCycle() {
        return this.getCycleType() == CycleType.SPECIALIZATION_CYCLE;
    }

    public Collection<CycleCourseGroup> getParentCycleCourseGroups() {
        return Collections.singletonList(this);
    }

    public Double getCurrentDefaultEcts() {
        return this.getDefaultEcts(ExecutionYear.readCurrentExecutionYear());
    }

    public List<CycleCourseGroupInformation> getCycleCourseGroupInformationOrderedByExecutionYear() {
        ArrayList<CycleCourseGroupInformation> groupInformationList = new ArrayList<CycleCourseGroupInformation>(this.getCycleCourseGroupInformationSet());
        Collections.sort(groupInformationList, CycleCourseGroupInformation.COMPARATOR_BY_EXECUTION_YEAR);
        return groupInformationList;
    }

    public CycleCourseGroupInformation getCycleCourseGroupInformationByExecutionYear(ExecutionYear executionYear) {
        for (CycleCourseGroupInformation cycleInformation : this.getCycleCourseGroupInformationSet()) {
            if (cycleInformation.getExecutionYear() != executionYear) continue;
            return cycleInformation;
        }
        return null;
    }

    public CycleCourseGroupInformation getMostRecentCycleCourseGroupInformation(ExecutionYear executionYear, boolean isForSuffix) {
        CycleCourseGroupInformation mostRecent = null;
        for (CycleCourseGroupInformation cycleInformation : this.getCycleCourseGroupInformationSet()) {
            if (cycleInformation.getExecutionYear().isAfter(executionYear) || mostRecent != null && !cycleInformation.getExecutionYear().isAfter(mostRecent.getExecutionYear())) continue;
            mostRecent = cycleInformation;
        }
        return mostRecent;
    }

    public CycleCourseGroupInformation createCycleCourseGroupInformation(ExecutionYear executionYear, String string, String string2) {
        return (CycleCourseGroupInformation)((Object)advice$createCycleCourseGroupInformation.perform((Callable)new CycleCourseGroup$callable$createCycleCourseGroupInformation(this, executionYear, string, string2)));
    }

    static /* synthetic */ CycleCourseGroupInformation advised$createCycleCourseGroupInformation(CycleCourseGroup this_, ExecutionYear executionYear, String graduatedTitleSuffix, String graduatedTitleSuffixEn) {
        if (this_.getCycleCourseGroupInformationByExecutionYear(executionYear) != null) {
            throw new DomainException("cycle.course.group.information.exists.in.execution.year", new String[0]);
        }
        return new CycleCourseGroupInformation(this_, executionYear, graduatedTitleSuffix, graduatedTitleSuffixEn);
    }

    public Set<CycleCourseGroup> getAllPossibleAffinities() {
        HashSet<CycleType> affinityCycles = new HashSet<CycleType>();
        for (CycleType cycleType : CycleType.values()) {
            if (cycleType.getSourceCycleAffinity() != this.getCycleType()) continue;
            affinityCycles.add(cycleType);
        }
        HashSet<CycleCourseGroup> result = new HashSet<CycleCourseGroup>();
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                for (CycleType affinityCycle : affinityCycles) {
                    CycleCourseGroup cycleCourseGroup = degreeCurricularPlan.getCycleCourseGroup(affinityCycle);
                    if (cycleCourseGroup == null || cycleCourseGroup == this) continue;
                    result.add(cycleCourseGroup);
                }
            }
        }
        return result;
    }

    public CycleCourseGroupInformation findCycleCourseGroupInformationBy(ExecutionInterval executionInterval) {
        for (CycleCourseGroupInformation each : this.getCycleCourseGroupInformationSet()) {
            if (!each.isFor(executionInterval)) continue;
            return each;
        }
        return null;
    }
}

