/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.ContactRoot;
import org.fenixedu.academic.domain.contacts.EmailAddress$callable$edit;
import org.fenixedu.academic.domain.contacts.EmailAddress_Base;
import org.fenixedu.academic.domain.contacts.EmailValidation;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EmailAddress
extends EmailAddress_Base {
    public static Comparator<EmailAddress> COMPARATOR_BY_EMAIL;
    public static final Advice advice$edit;

    public static EmailAddress createEmailAddress(Party party, String email, PartyContactType type, Boolean isDefault, Boolean visibleToPublic, Boolean visibleToStudents, Boolean visibleToStaff) {
        EmailAddress result = null;
        if (!StringUtils.isEmpty((String)email)) {
            result = new EmailAddress(party, type, visibleToPublic, visibleToStudents, visibleToStaff, isDefault, email);
        }
        return result;
    }

    public static EmailAddress createEmailAddress(Party party, String email, PartyContactType type, boolean isDefault) {
        for (EmailAddress emailAddress : party.getEmailAddresses()) {
            if (!emailAddress.getValue().equals(email)) continue;
            return emailAddress;
        }
        return !StringUtils.isEmpty((String)email) ? new EmailAddress(party, type, isDefault, email) : null;
    }

    protected EmailAddress() {
        new EmailValidation((PartyContact)((Object)this));
    }

    protected EmailAddress(Party party, PartyContactType type, boolean defaultContact, String value) {
        this();
        super.init(party, type, defaultContact);
        this.checkParameters(value);
        this.setValue(value);
    }

    protected EmailAddress(Party party, PartyContactType type, boolean visibleToPublic, boolean visibleToStudents, boolean visibleToStaff, boolean defaultContact, String value) {
        this();
        super.init(party, type, visibleToPublic, visibleToStudents, visibleToStaff, defaultContact);
        this.checkParameters(value);
        this.setValue(value);
    }

    private void checkParameters(String value) {
        if (!EmailValidator.getInstance().isValid(value)) {
            throw new DomainException("error.domain.contacts.EmailAddress.invalid.format", value);
        }
    }

    public void setDefaultContact(Boolean defaultContact) {
        super.setDefaultContact(defaultContact);
        this.updateProfileEmail();
    }

    public void setValue(String value) {
        super.setValue(value);
        this.updateProfileEmail();
    }

    public void setType(PartyContactType type) {
        if (PartyContactType.INSTITUTIONAL.equals((Object)type)) {
            throw new DomainException("error.domain.contacts.EmailAddress.can.only.have.one.institutional.emailAddress", new String[0]);
        }
        super.setType(type);
        this.updateProfileEmail();
    }

    public void setValid() {
        super.setValid();
        this.updateProfileEmail();
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public boolean hasValue(String emailAddressString) {
        return this.hasValue() && this.getValue().equalsIgnoreCase(emailAddressString);
    }

    public boolean isEmailAddress() {
        return true;
    }

    public void edit(String string) {
        Object object = advice$edit.perform((Callable)new EmailAddress$callable$edit(this, string));
    }

    static /* synthetic */ void advised$edit(EmailAddress this_, String value) {
        if (!this_.isInstitutionalType()) {
            if (!StringUtils.equals((String)value, (String)this_.getValue())) {
                this_.setValue(value);
                if (!this_.waitsValidation()) {
                    new EmailValidation((PartyContact)((Object)this_));
                }
            }
            this_.setLastModifiedDate(new DateTime());
        }
    }

    protected void checkRulesToDelete() {
        if (this.isInstitutionalType()) {
            throw new DomainException("error.domain.contacts.EmailAddress.cannot.delete.institution.emailAddress", this.getValue());
        }
        if (this.getParty().getPartyContacts(((Object)((Object)this)).getClass()).size() == 1) {
            throw new DomainException("error.domain.contacts.EmailAddress.cannot.remove.last.emailAddress", new String[0]);
        }
    }

    public static EmailAddress find(String emailAddressString) {
        for (PartyContact contact : ContactRoot.getInstance().getPartyContactsSet()) {
            EmailAddress emailAddress;
            if (!contact.isEmailAddress() || !(emailAddress = (EmailAddress)((Object)contact)).hasValue(emailAddressString)) continue;
            return emailAddress;
        }
        return null;
    }

    public String getPresentationValue() {
        return this.getValue();
    }

    private void updateProfileEmail() {
        if (this.getParty() != null && this.getParty() instanceof Person) {
            Person person = (Person)((Object)this.getParty());
            person.getProfile().setEmail(person.getEmailForSendingEmails());
        }
    }

    public void logCreate(Person person) {
        this.logCreateAux(person, "label.partyContacts.EmailAddress");
    }

    public void logEdit(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
        this.logEditAux(person, propertiesChanged, valueChanged, createdNewContact, newValue, "label.partyContacts.EmailAddress");
    }

    public void logDelete(Person person) {
        this.logDeleteAux(person, "label.partyContacts.EmailAddress");
    }

    public void logValid(Person person) {
        this.logValidAux(person, "label.partyContacts.EmailAddress");
    }

    public void logRefuse(Person person) {
        this.logRefuseAux(person, "label.partyContacts.EmailAddress");
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_EMAIL = new Comparator<EmailAddress>(){

            @Override
            public int compare(EmailAddress contact, EmailAddress otherContact) {
                String value = contact.getValue();
                String otherValue = otherContact.getValue();
                int result = 0;
                if (value != null && otherValue != null) {
                    result = value.compareTo(otherValue);
                } else if (value != null) {
                    result = 1;
                } else if (otherValue != null) {
                    result = -1;
                }
                return result == 0 ? PartyContact.COMPARATOR_BY_TYPE.compare((PartyContact)((Object)contact), (PartyContact)((Object)otherContact)) : result;
            }
        };
    }
}

