/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.caseHandling;

import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.caseHandling.ProcessLog_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ProcessLog
extends ProcessLog_Base {
    public static Comparator<ProcessLog> COMPARATOR_BY_WHEN = new Comparator<ProcessLog>(){

        @Override
        public int compare(ProcessLog leftProcessLog, ProcessLog rightProcessLog) {
            int comparationResult = leftProcessLog.getWhenDateTime().compareTo((ReadableInstant)rightProcessLog.getWhenDateTime());
            return comparationResult == 0 ? leftProcessLog.getExternalId().compareTo(rightProcessLog.getExternalId()) : comparationResult;
        }
    };

    public ProcessLog(Process process2, User userView, Activity<?> activity) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setProcess(process2);
        this.setUserName(userView != null ? userView.getUsername() : "PUBLICO");
        this.setActivity(activity.getClass().getName());
        this.setWhenDateTime(new DateTime());
    }

    public boolean isFor(Class<? extends Activity> clazz) {
        return this.getActivity().equals(clazz.getName());
    }

    @Deprecated
    public Date getWhen() {
        DateTime dt = this.getWhenDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setWhen(Date date) {
        if (date == null) {
            this.setWhenDateTime(null);
        } else {
            this.setWhenDateTime(new DateTime(date.getTime()));
        }
    }
}

