/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusVacancy$callable$createVacancy;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusVacancy_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentData;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ErasmusVacancy
extends ErasmusVacancy_Base {
    public static final Advice advice$createVacancy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private ErasmusVacancy() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public ErasmusVacancy(MobilityApplicationPeriod period, Degree degree, UniversityUnit unit, Integer numberOfVacancies) {
        this();
        this.setCandidacyPeriod(period);
        this.setDegree(degree);
        this.setUniversityUnit(unit);
        this.setNumberOfVacancies(numberOfVacancies);
        this.check();
    }

    private void check() {
        if (this.getCandidacyPeriod() == null) {
            throw new DomainException("error.erasmus.vacancy.candidacy.period.must.not.be.null", new String[0]);
        }
        if (this.getDegree() == null) {
            throw new DomainException("error.erasmus.vacancy.degree.must.not.be.null", new String[0]);
        }
        if (this.getUniversityUnit() == null) {
            throw new DomainException("error.erasmus.vacancy.university.unit.must.not.be.null", new String[0]);
        }
        if (this.getNumberOfVacancies() == null) {
            throw new DomainException("error.erasmus.vacancy.number.of.vacancies.must.not.be.null", new String[0]);
        }
    }

    public static ErasmusVacancy createVacancy(MobilityApplicationPeriod mobilityApplicationPeriod, Degree degree, UniversityUnit universityUnit, Integer n) {
        return (ErasmusVacancy)((Object)advice$createVacancy.perform((Callable)new ErasmusVacancy$callable$createVacancy(mobilityApplicationPeriod, degree, universityUnit, n)));
    }

    static /* synthetic */ ErasmusVacancy advised$createVacancy(MobilityApplicationPeriod period, Degree degree, UniversityUnit unit, Integer numberOfVacancies) {
        return new ErasmusVacancy(period, degree, unit, numberOfVacancies);
    }

    public List<MobilityIndividualApplicationProcess> getStudentApplicationProcesses() {
        ArrayList<MobilityIndividualApplicationProcess> processList = new ArrayList<MobilityIndividualApplicationProcess>();
        for (MobilityStudentData data : this.getCandidaciesSet()) {
            processList.add(data.getMobilityIndividualApplication().getCandidacyProcess());
        }
        return processList;
    }

    public boolean isVacancyAssociatedToAnyCandidacy() {
        return !this.getCandidaciesSet().isEmpty();
    }

    public void delete() {
        if (this.isVacancyAssociatedToAnyCandidacy()) {
            throw new DomainException("error.erasmus.vacancy.is.associated.to.candidacies", new String[0]);
        }
        this.setUniversityUnit(null);
        this.setDegree(null);
        this.setCandidacyPeriod(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

