/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.accountingTransactions.InstallmentAccountingTransaction;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR_Base;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.IGratuityPR;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.EntryWithInstallmentDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class GratuityWithPaymentPlanPR
extends GratuityWithPaymentPlanPR_Base
implements IGratuityPR {
    protected GratuityWithPaymentPlanPR() {
    }

    public GratuityWithPaymentPlanPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        this(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate);
    }

    public GratuityWithPaymentPlanPR(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        this();
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        BigDecimal discountPercentage = applyDiscount ? this.getDiscountPercentage(event) : BigDecimal.ZERO;
        return this.getPaymentPlan(event).calculateTotalAmount(event, when, discountPercentage);
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    public BigDecimal getDiscountPercentage(Event event) {
        PaymentPlan paymentPlan = this.getPaymentPlan(event);
        if (paymentPlan == null) {
            throw new DomainException("error.event.not.associated.paymentPlan", ((Object)((Object)event)).getClass().getName());
        }
        return ((GratuityEventWithPaymentPlan)((Object)event)).calculateDiscountPercentage(paymentPlan.calculateBaseAmount(event));
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        ArrayList<EntryDTO> result = new ArrayList<EntryDTO>();
        Map<Installment, Money> amountsByInstallment = this.getPaymentPlan(event).calculateInstallmentRemainingAmounts(event, when, this.getDiscountPercentage(event));
        for (Installment installment : this.getPaymentPlan(event).getInstallmentsSortedByEndDate()) {
            Money installmentAmount = amountsByInstallment.get((Object)installment);
            if (installmentAmount == null || !installmentAmount.isPositive()) continue;
            result.add(new EntryWithInstallmentDTO(EntryType.GRATUITY_FEE, event, installmentAmount, event.getDescriptionForEntryType(this.getEntryType()), installment));
        }
        if (this.needsTotalAmountEntry(this.getPaymentPlan(event), result, event, when)) {
            Money amountToPay = event.calculateAmountToPay(when);
            result.add(new EntryDTO(EntryType.GRATUITY_FEE, event, amountToPay, event.getPayedAmount(), amountToPay, event.getDescriptionForEntryType(this.getEntryType()), amountToPay));
        }
        return result;
    }

    private boolean needsTotalAmountEntry(PaymentPlan paymentPlan, List<EntryDTO> result, Event event, DateTime when) {
        return paymentPlan.getInstallmentsSet().size() != 1 && paymentPlan.getInstallmentsSet().size() == result.size();
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan = (GratuityEventWithPaymentPlan)((Object)event);
        if (entryDTOs.size() > 1) {
            HashSet<AccountingTransaction> result = new HashSet<AccountingTransaction>();
            for (EntryDTO each : entryDTOs) {
                if (!(each instanceof EntryWithInstallmentDTO)) {
                    throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR.cannot.mix.installments.with.total.payments", event.getDescriptionForEntryType(this.getEntryType()));
                }
                result.add(this.internalProcessInstallment(user, fromAccount, toAccount, each, gratuityEventWithPaymentPlan, transactionDetail));
            }
            return result;
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        if (entryDTO instanceof EntryWithInstallmentDTO) {
            return Collections.singleton(this.internalProcessInstallment(user, fromAccount, toAccount, entryDTO, gratuityEventWithPaymentPlan, transactionDetail));
        }
        return Collections.singleton(this.internalProcessTotal(user, fromAccount, toAccount, entryDTO, gratuityEventWithPaymentPlan, transactionDetail));
    }

    private AccountingTransaction internalProcessTotal(User user, Account fromAccount, Account toAccount, EntryDTO entryDTO, GratuityEventWithPaymentPlan event, AccountingTransactionDetailDTO transactionDetail) {
        event.changeGratuityTotalPaymentCodeState(event.getPaymentCodeStateFor(transactionDetail.getPaymentMode()));
        if (!transactionDetail.isSibsTransactionDetail()) {
            this.checkIfCanAddAmount(entryDTO, transactionDetail.getWhenRegistered(), (Event)((Object)event));
        }
        return super.makeAccountingTransaction(user, (Event)((Object)event), fromAccount, toAccount, this.getEntryType(), entryDTO.getAmountToPay(), transactionDetail);
    }

    private AccountingTransaction internalProcessInstallment(User user, Account fromAccount, Account toAccount, EntryDTO entryDTO, GratuityEventWithPaymentPlan event, AccountingTransactionDetailDTO transactionDetail) {
        EntryWithInstallmentDTO entryWithInstallmentDTO = (EntryWithInstallmentDTO)entryDTO;
        if (!transactionDetail.isSibsTransactionDetail()) {
            this.checkIfCanAddAmountForInstallment(entryWithInstallmentDTO, transactionDetail.getWhenRegistered(), (Event)((Object)event));
        }
        event.changeInstallmentPaymentCodeState(entryWithInstallmentDTO.getInstallment(), event.getPaymentCodeStateFor(transactionDetail.getPaymentMode()));
        return this.makeAccountingTransactionForInstallment(user, (Event)((Object)event), fromAccount, toAccount, this.getEntryType(), entryDTO.getAmountToPay(), entryWithInstallmentDTO.getInstallment(), transactionDetail);
    }

    private void checkIfCanAddAmount(EntryDTO entryDTO, DateTime whenRegistered, Event event) {
        if (entryDTO.getAmountToPay().compareTo(event.calculateAmountToPay(whenRegistered)) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR.amount.to.pay.must.match.value", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    private void checkIfCanAddAmountForInstallment(EntryWithInstallmentDTO entryDTO, DateTime whenRegistered, Event event) {
        Money installmentAmount = this.getPaymentPlan(event).calculateRemainingAmountFor(entryDTO.getInstallment(), event, whenRegistered, this.getDiscountPercentage(event));
        if (entryDTO.getAmountToPay().compareTo(installmentAmount) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR.amount.to.pay.must.match.value", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    private PaymentPlan getPaymentPlan(Event event) {
        return ((GratuityEventWithPaymentPlan)((Object)event)).getGratuityPaymentPlan();
    }

    public DegreeCurricularPlanServiceAgreementTemplate getServiceAgreementTemplate() {
        return (DegreeCurricularPlanServiceAgreementTemplate)((Object)super.getServiceAgreementTemplate());
    }

    protected AccountingTransaction makeAccountingTransactionForInstallment(User responsibleUser, Event event, Account from, Account to, EntryType entryType, Money amount, Installment installment, AccountingTransactionDetailDTO transactionDetail) {
        return new InstallmentAccountingTransaction(responsibleUser, event, this.makeEntry(entryType, amount.negate(), from), this.makeEntry(entryType, amount, to), installment, this.makeAccountingTransactionDetail(transactionDetail));
    }

    @Override
    public Money getDefaultGratuityAmount(ExecutionYear executionYear) {
        return this.getServiceAgreementTemplate().getDefaultPaymentPlan(executionYear).calculateOriginalTotalAmount();
    }

    public Money getDefaultGratuityAmount() {
        return this.getDefaultGratuityAmount(ExecutionYear.readByDateTime(this.getCreationDate()));
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getServiceAgreementTemplate().hasActivePostingRuleFor(EventType.STANDALONE_ENROLMENT_GRATUITY)) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR.standalone.cannot.delete", (String[])new String[0]));
        }
    }
}

