/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.ResidencePR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class ResidencePR
extends ResidencePR_Base {
    public ResidencePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money penaltyPerDay) {
        super.init(EntryType.RESIDENCE_FEE, EventType.RESIDENCE_PAYMENT, startDate, endDate, serviceAgreementTemplate);
        this.setPenaltyPerDay(penaltyPerDay);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money amounToPay = event.calculateAmountToPay(when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), amounToPay, amounToPay, event.getDescriptionForEntryType(this.getEntryType()), amounToPay));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        ResidenceEvent residenceEvent = (ResidenceEvent)((Object)event);
        Money baseValue = residenceEvent.getRoomValue();
        if (residenceEvent.getPaymentLimitDate().isAfter((ReadableInstant)when)) {
            return baseValue;
        }
        return baseValue.add(this.getPenaltyPerDay().multiply(BigDecimal.valueOf(Days.daysBetween((ReadableInstant)residenceEvent.getPaymentLimitDate(), (ReadableInstant)when).getDays())));
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.residencePR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime whenRegistered) {
        if (!event.calculateAmountToPay(whenRegistered).equals(amountToPay)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.amount.being.payed.must.be.equal.to.amout.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }
}

