/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Entry_Base;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Entry
extends Entry_Base {
    public static Comparator<Entry> COMPARATOR_BY_MOST_RECENT_WHEN_REGISTERED = new Comparator<Entry>(){

        @Override
        public int compare(Entry leftEntry, Entry rightEntry) {
            int comparationResult = leftEntry.getWhenRegistered().compareTo((ReadableInstant)rightEntry.getWhenRegistered());
            return comparationResult == 0 ? leftEntry.getExternalId().compareTo(rightEntry.getExternalId()) : comparationResult;
        }
    };

    private Entry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    Entry(EntryType entryType, Money amount, Account account) {
        this();
        this.init(entryType, amount, account);
    }

    private void init(EntryType entryType, Money amount, Account account) {
        this.checkParameters(entryType, amount, account);
        super.setEntryType(entryType);
        super.setOriginalAmount(amount);
        super.setAccount(account);
    }

    private void checkParameters(EntryType entryType, Money amount, Account account) {
        if (entryType == null) {
            throw new DomainException("error.accounting.entry.entryType.cannot.be.null", new String[0]);
        }
        if (amount == null) {
            throw new DomainException("error.accounting.entry.originalAmount.cannot.be.null", new String[0]);
        }
        if (account == null) {
            throw new DomainException("error.accounting.entry.account.cannot.be.null", new String[0]);
        }
    }

    public boolean isPositiveAmount() {
        return this.getOriginalAmount().isPositive();
    }

    public boolean isAmountWithAdjustmentPositive() {
        return this.getAmountWithAdjustment().isPositive();
    }

    public void setAccount(Account account) {
        throw new DomainException("error.accounting.entry.cannot.modify.account", new String[0]);
    }

    public void setAccountingTransaction(AccountingTransaction accountingTransaction) {
        throw new DomainException("error.accounting.entry.cannot.modify.accountingTransaction", new String[0]);
    }

    public void setOriginalAmount(Money amount) {
        throw new DomainException("error.accounting.entry.cannot.modify.originalAmount", new String[0]);
    }

    public void setEntryType(EntryType entryType) {
        throw new DomainException("error.accounting.entry.cannot.modify.entryType", new String[0]);
    }

    public DateTime getWhenRegistered() {
        return this.getAccountingTransaction().getWhenRegistered();
    }

    public DateTime getWhenProcessed() {
        return this.getAccountingTransaction().getWhenProcessed();
    }

    public void addReceipts(Receipt receipt) {
        throw new DomainException("error.accounting.Entry.cannot.add.receipt", new String[0]);
    }

    public Set<Receipt> getReceiptsSet() {
        return Collections.unmodifiableSet(super.getReceiptsSet());
    }

    public void removeReceipts(Receipt receipt) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Entry.cannot.remove.receipt", new String[0]);
    }

    public void setActiveReceipt(Receipt receipt) {
        if (this.getAdjustmentCreditNoteEntry() != null) {
            throw new DomainException("error.accounting.entry.is.already.associated.to.payed.creditNote", new String[0]);
        }
        if (this.isAssociatedToAnyActiveReceipt()) {
            throw new DomainExceptionWithLabelFormatter("error.Entry.cannot.be.associated.to.receipt.because.is.already.associated.to.another.active.receipt", this.getDescription());
        }
        super.addReceipts(receipt);
    }

    public Receipt getActiveReceipt() {
        for (Receipt receipt : this.getReceiptsSet()) {
            if (!receipt.isActive()) continue;
            return receipt;
        }
        return null;
    }

    public LabelFormatter getDescription() {
        return this.getAccountingTransaction().getDescriptionForEntryType(this.getEntryType());
    }

    public Money getAmountWithAdjustment() {
        return this.hasBeenAdjusted() ? this.getOriginalAmount().add(this.getTotalAdjustedAmount()) : this.getOriginalAmount();
    }

    private Money getTotalAdjustedAmount() {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getAccountingTransaction().getAdjustmentTransactionsSet()) {
            result = result.add(transaction.getEntryFor(this.getAccount()).getOriginalAmount());
        }
        return result;
    }

    public boolean isAdjusting() {
        return this.getAccountingTransaction().isAdjustingTransaction();
    }

    public boolean hasBeenAdjusted() {
        return this.getAccountingTransaction().hasBeenAdjusted();
    }

    private boolean canApplyAdjustment(Money amountToAdjust) {
        return this.isAdjustmentAppliable() && this.getAmountWithAdjustment().add(amountToAdjust).greaterOrEqualThan(Money.ZERO);
    }

    private boolean isAdjustmentAppliable() {
        return this.getPersonFromEvent() == this.getFromAccountOwner();
    }

    public boolean isReimbursementAppliable() {
        return this.isAdjustmentAppliable() && this.getAmountWithAdjustment().isPositive();
    }

    private Person getPersonFromEvent() {
        return this.getAccountingTransaction().getEvent().getPerson();
    }

    public Party getFromAccountOwner() {
        return this.getAccountingTransaction().getFromAccount().getParty();
    }

    public boolean canApplyReimbursement(Money amountToReimburse) {
        return this.canApplyAdjustment(amountToReimburse.negate());
    }

    protected boolean isAssociatedToAnyActiveReceipt() {
        for (Receipt receipt : this.getReceiptsSet()) {
            if (!receipt.isActive()) continue;
            return true;
        }
        return false;
    }

    void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        super.setAccount(null);
        super.setAccountingTransaction(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getReceiptsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.accounting.Entry.belongs.to.receipt", (String[])new String[0]));
        }
    }

    public PaymentMode getPaymentMode() {
        return this.getAccountingTransaction().getTransactionDetail().getPaymentMode();
    }
}

