/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl.rules;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.fenixedu.academic.domain.accessControl.rules.AccessOperation;
import org.fenixedu.academic.domain.accessControl.rules.AccessRuleSystem;
import org.fenixedu.academic.domain.accessControl.rules.AccessRule_Base;
import org.fenixedu.academic.domain.accessControl.rules.AccessTarget;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.NobodyGroup;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;

public abstract class AccessRule
extends AccessRule_Base {
    protected AccessRule() {
        this.setRuleSystem(AccessRuleSystem.getInstance());
        this.setCreated(new DateTime());
        this.setCreator(Authenticate.getUser());
    }

    public DateTime getCreated() {
        return super.getCreated();
    }

    public DateTime getRevoked() {
        return super.getRevoked();
    }

    public User getCreator() {
        return super.getCreator();
    }

    public AccessOperation<?, ?> getOperation() {
        return super.getOperation();
    }

    public <R extends AccessRule> Optional<R> changeOperation(AccessOperation<R, ?> operation) {
        return this.change(operation, this.getWhoCanAccess(), this.getWhatCanAffect());
    }

    public Group getWhoCanAccess() {
        return super.getPersistentGroup().toGroup();
    }

    protected boolean isMember(User user) {
        return this.getWhoCanAccess().isMember(user);
    }

    protected boolean isMember(User user, DateTime when) {
        return this.getWhoCanAccess().isMember(user, when);
    }

    public <R extends AccessRule, T extends AccessTarget> Optional<R> changeWhoCanAccess(Group whoCanAccess) {
        return this.change(this.getOperation(), whoCanAccess, this.getWhatCanAffect());
    }

    public abstract <T extends AccessTarget> Set<T> getWhatCanAffect();

    public <R extends AccessRule, T extends AccessTarget> Optional<R> changeWhatCanAffect(Set<T> whatCanAffect) {
        return this.change(this.getOperation(), this.getWhoCanAccess(), whatCanAffect);
    }

    public <T extends AccessRule> Optional<T> grant(User user) {
        return this.changeWhoCanAccess(this.getWhoCanAccess().grant(user));
    }

    public <T extends AccessRule> Optional<T> revoke(User user) {
        return this.changeWhoCanAccess(this.getWhoCanAccess().revoke(user));
    }

    protected <R extends AccessRule, T extends AccessTarget> Optional<R> change(AccessOperation<R, T> operation, Group whoCanAccess, Set<T> whatCanAffect) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(whoCanAccess);
        Objects.requireNonNull(whatCanAffect);
        this.revoke();
        if (!whoCanAccess.equals((Object)NobodyGroup.get())) {
            return operation.grant(whoCanAccess, whatCanAffect);
        }
        return Optional.empty();
    }

    public void revoke() {
        this.setRevoked(new DateTime());
        this.setDeletedFromRuleSystem(this.getRuleSystem());
        this.setRuleSystem(null);
    }
}

