/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import org.fenixedu.academic.util.FenixUtil;

public class ProposalState
extends FenixUtil {
    public static final int CRIADOR = 1;
    public static final int ACEITE = 2;
    public static final int EM_ESPERA = 3;
    public static final int REJEITADO = 4;
    private final Integer state;

    public ProposalState(int proposal_state) {
        this.state = new Integer(proposal_state);
    }

    public ProposalState(Integer proposal_state) {
        this.state = proposal_state;
    }

    public Integer getState() {
        return this.state;
    }

    public boolean equals(Object obj) {
        boolean resultado = false;
        if (obj instanceof ProposalState) {
            ProposalState state = (ProposalState)obj;
            resultado = this.getState().intValue() == state.getState().intValue();
        }
        return resultado;
    }

    public String toString() {
        int value = this.state;
        switch (value) {
            case 1: {
                return "C";
            }
            case 2: {
                return "A";
            }
            case 3: {
                return "EE";
            }
            case 4: {
                return "R";
            }
        }
        return "Error: Invalid proposal state";
    }

    public String getSiglaProposalState() {
        int value = this.state;
        switch (value) {
            case 1: {
                return "C";
            }
            case 2: {
                return "A";
            }
            case 3: {
                return "EE";
            }
            case 4: {
                return "R";
            }
        }
        return "Error: Invalid proposal state";
    }

    public String getFullNameProposalState() {
        int value = this.state;
        switch (value) {
            case 1: {
                return "CRIADOR";
            }
            case 2: {
                return "ACEITE";
            }
            case 3: {
                return "EM_ESPERA";
            }
            case 4: {
                return "REJEITADO";
            }
        }
        return "Error: Invalid proposal state";
    }
}

