/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.candidacy;

import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.RegexpValidator;

@Mapping(path="/editMissingCandidacyInformation", module="student")
@Forwards(value={@Forward(name="editMissingPersonalInformation", path="/student/candidacy/editMissingCandidacyInformation.jsp")})
public class EditMissingCandidacyInformationDA
extends FenixDispatchAction {
    protected static List<PersonalInformationBean> getPersonalInformationsWithMissingInfo() {
        return AccessControl.getPerson().getStudent().getPersonalInformationsWithMissingInformation();
    }

    public ActionForward prepareEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<PersonalInformationBean> list = EditMissingCandidacyInformationDA.getPersonalInformationsWithMissingInfo();
        request.setAttribute("personalInformationsWithMissingInformation", list);
        request.setAttribute("personalInformationBean", (Object)list.iterator().next());
        return mapping.findForward("editMissingPersonalInformation");
    }

    public ActionForward prepareEditInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("personalInformationsWithMissingInformation", EditMissingCandidacyInformationDA.getPersonalInformationsWithMissingInfo());
        request.setAttribute("personalInformationBean", this.getRenderedObject("personalInformationBean"));
        return mapping.findForward("editMissingPersonalInformation");
    }

    public ActionForward prepareEditPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("personalInformationsWithMissingInformation", EditMissingCandidacyInformationDA.getPersonalInformationsWithMissingInfo());
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        personalInformationBean.resetInstitutionAndDegree();
        request.setAttribute("personalInformationBean", (Object)personalInformationBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("editMissingPersonalInformation");
    }

    public ActionForward prepareEditInstitutionPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("personalInformationsWithMissingInformation", EditMissingCandidacyInformationDA.getPersonalInformationsWithMissingInfo());
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        personalInformationBean.resetDegree();
        request.setAttribute("personalInformationBean", (Object)personalInformationBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("editMissingPersonalInformation");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        Set<String> messages = personalInformationBean.validate();
        if (!messages.isEmpty()) {
            for (String each : messages) {
                this.addActionMessage(request, each);
            }
            return this.prepareEditInvalid(mapping, form, request, response);
        }
        try {
            personalInformationBean.updatePersonalInformation(true);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return this.prepareEditInvalid(mapping, form, request, response);
        }
        if (personalInformationBean.getStudent().hasAnyMissingPersonalInformation()) {
            RenderUtils.invalidateViewState();
            return this.prepareEdit(mapping, form, request, response);
        }
        ActionForward forward = new ActionForward();
        forward.setPath("/home.do");
        forward.setRedirect(true);
        forward.setModule("/");
        return forward;
    }

    public static class NumberOfFlunksRegexpValidator
    extends RegexpValidator {
        public NumberOfFlunksRegexpValidator() {
            this.setRegexp("(\\d{1,2})?");
            this.setMessage("error.CandidacyInformationBean.numberOfFlunksOnHighSchool.invalid.format");
            this.setKey(true);
            this.setBundle("APPLICATION_RESOURCES");
        }
    }

    public static class NumberOfCandidaciesRegexpValidator
    extends RegexpValidator {
        public NumberOfCandidaciesRegexpValidator() {
            this.setRegexp("(\\d{1,2})?");
            this.setMessage("error.CandidacyInformationBean.numberOfCandidaciesToHigherSchool.invalid.format");
            this.setKey(true);
            this.setBundle("APPLICATION_RESOURCES");
        }
    }

    public static class ConclusionYearRegexpValidator
    extends RegexpValidator {
        public ConclusionYearRegexpValidator() {
            this.setRegexp("(\\d{4})?");
            this.setMessage("error.CandidacyInformationBean.conclusionYear.invalid.format");
            this.setKey(true);
            this.setBundle("APPLICATION_RESOURCES");
        }

        public void performValidation() {
            String conclusionYear = this.getComponent().getValue();
            if (!StringUtils.isEmpty((String)conclusionYear)) {
                super.performValidation();
            } else {
                this.setValid(false);
                this.setMessage("renderers.validator.required");
            }
        }
    }

    public static class ConclusionGradeRegexpValidator
    extends RegexpValidator {
        public ConclusionGradeRegexpValidator() {
            this.setRegexp("(20)?(0*\\d{1})?(1\\d{1})?");
            this.setMessage("error.CandidacyInformationBean.conclusionGrade.invalid.format");
            this.setKey(true);
            this.setBundle("APPLICATION_RESOURCES");
        }

        public void performValidation() {
            String conclusionGrade = this.getComponent().getValue();
            if (!StringUtils.isEmpty((String)conclusionGrade)) {
                super.performValidation();
            } else {
                this.setValid(false);
                this.setMessage("renderers.validator.required");
            }
        }
    }
}

