/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.InfoSiteRoomTimeTable;
import org.fenixedu.academic.dto.RoomKey;
import org.fenixedu.academic.service.factory.RoomSiteComponentBuilder;
import org.fenixedu.academic.service.services.commons.ReadCurrentExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadExecutionPeriodByOID;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.exceptions.NonExistingActionException;
import org.fenixedu.academic.ui.struts.action.publico.spaces.FindSpacesDA;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/viewRoom", module="publico", formBean="indexForm", functionality=FindSpacesDA.class)
@Forwards(value={@Forward(name="roomViewer", path="/publico/viewRoom_bd.jsp")})
public class RoomSiteViewerDispatchAction
extends FenixContextDispatchAction {
    public ActionForward roomViewer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String roomId = request.getParameter("roomId");
        String roomName = request.getParameter("roomName");
        if (roomId == null) {
            roomId = (String)request.getAttribute("roomId");
        }
        if (roomName == null) {
            roomName = (String)request.getAttribute("roomName");
        }
        request.setAttribute("roomName", (Object)roomName);
        request.setAttribute("roomId", (Object)roomId);
        RoomKey roomKey = null;
        Space room = null;
        if (roomName != null || roomId != null) {
            InfoExecutionPeriod executionPeriod;
            String executionPeriodID;
            if (roomName != null) {
                roomKey = new RoomKey(roomName);
            }
            if (roomId != null && !FenixFramework.isDomainObjectValid((DomainObject)(room = (Space)FenixFramework.getDomainObject((String)roomId)))) {
                room = null;
            }
            InfoSiteRoomTimeTable bodyComponent = new InfoSiteRoomTimeTable();
            DynaActionForm indexForm = (DynaActionForm)form;
            Integer indexWeek = (Integer)indexForm.get("indexWeek");
            String executionPeriodIDString = request.getParameter("selectedExecutionPeriodID");
            if (executionPeriodIDString == null) {
                executionPeriodIDString = (String)request.getAttribute("selectedExecutionPeriodID");
            }
            String string = executionPeriodID = executionPeriodIDString != null ? executionPeriodIDString : null;
            if (executionPeriodID == null) {
                try {
                    executionPeriodID = indexForm.get("selectedExecutionPeriodID").equals("") ? null : (String)indexForm.get("selectedExecutionPeriodID");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Calendar today = new DateMidnight().toCalendar(null);
            ArrayList<Calendar> weeks = new ArrayList<Calendar>();
            if (executionPeriodID == null) {
                executionPeriod = ReadCurrentExecutionPeriod.run();
                executionPeriodID = executionPeriod.getExternalId();
                try {
                    indexForm.set("selectedExecutionPeriodID", (Object)executionPeriod.getExternalId().toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                executionPeriod = ReadExecutionPeriodByOID.run(executionPeriodID);
            }
            Calendar begin = Calendar.getInstance();
            begin.setTime(executionPeriod.getBeginDate());
            Calendar end = Calendar.getInstance();
            end.setTime(executionPeriod.getEndDate());
            ArrayList<LabelValueBean> weeksLabelValueList = new ArrayList<LabelValueBean>();
            begin.add(5, 2 - begin.get(7));
            int i = 0;
            boolean selectedWeek = false;
            while (begin.before(end) || begin.before(Calendar.getInstance())) {
                Calendar day = Calendar.getInstance();
                day.setTimeInMillis(begin.getTimeInMillis());
                weeks.add(day);
                String beginWeekString = DateFormatUtils.format((Date)begin.getTime(), (String)"dd/MM/yyyy");
                begin.add(5, 5);
                String endWeekString = DateFormatUtils.format((Date)begin.getTime(), (String)"dd/MM/yyyy");
                weeksLabelValueList.add(new LabelValueBean(beginWeekString + " - " + (String)endWeekString, new Integer(i).toString()));
                begin.add(5, 2);
                if (!selectedWeek && indexWeek == null && Calendar.getInstance().before(begin)) {
                    indexForm.set("indexWeek", (Object)new Integer(i));
                    selectedWeek = true;
                }
                ++i;
            }
            Set executionSemesters = rootDomainObject.getExecutionPeriodsSet();
            ArrayList<LabelValueBean> executionPeriodLabelValueBeans = new ArrayList<LabelValueBean>();
            for (ExecutionSemester ep : executionSemesters) {
                if (!ep.getState().equals(PeriodState.OPEN) && !ep.getState().equals(PeriodState.CURRENT)) continue;
                executionPeriodLabelValueBeans.add(new LabelValueBean(ep.getName() + " " + ep.getExecutionYear().getYear(), ep.getExternalId().toString()));
            }
            request.setAttribute("executionPeriodLabelList", executionPeriodLabelValueBeans);
            request.setAttribute("weeksLabelList", weeksLabelValueList);
            if (indexWeek != null) {
                int xpto = indexWeek;
                if (xpto < weeks.size()) {
                    today = (Calendar)weeks.get(xpto);
                } else {
                    today = (Calendar)weeks.iterator().next();
                    indexForm.set("indexWeek", (Object)new Integer(0));
                }
            }
            try {
                InfoSiteRoomTimeTable component = null;
                if (room != null) {
                    component = RoomSiteViewerDispatchAction.run(room, today, executionPeriodID);
                } else if (roomKey != null) {
                    component = RoomSiteViewerDispatchAction.run(roomKey, today, executionPeriodID);
                }
                request.setAttribute("component", (Object)component);
            }
            catch (NonExistingServiceException e) {
                throw new NonExistingActionException(e);
            }
            catch (FenixServiceException e) {
                throw new FenixActionException(e);
            }
            return mapping.findForward("roomViewer");
        }
        throw new FenixActionException();
    }

    private static InfoSiteRoomTimeTable run(RoomKey roomKey, Calendar someDay, String executionPeriodID) throws Exception {
        Space room = SpaceUtils.findAllocatableSpaceForEducationByName(roomKey.getNomeSala());
        return RoomSiteViewerDispatchAction.run(room, someDay, executionPeriodID);
    }

    private static InfoSiteRoomTimeTable run(Space room, Calendar someDay, String executionPeriodID) throws Exception {
        Calendar day = new DateTime(someDay.getTimeInMillis()).withField(DateTimeFieldType.dayOfWeek(), 1).toCalendar(null);
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodID);
        return RoomSiteComponentBuilder.getInfoSiteRoomTimeTable(day, room, executionSemester != null ? executionSemester : ExecutionSemester.readActualExecutionSemester());
    }
}

