/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons.student.enrollment.bolonha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentOptionalEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.CycleEnrolmentBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolBolonhaStudent;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolInAffinityCycle;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Forwards(value={@Forward(name="showDegreeModulesToEnrol", path="/academicAdminOffice/student/enrollment/bolonha/showDegreeModulesToEnrol.jsp"), @Forward(name="chooseOptionalCurricularCourseToEnrol", path="/academicAdminOffice/student/enrollment/bolonha/chooseOptionalCurricularCourseToEnrol.jsp"), @Forward(name="chooseCycleCourseGroupToEnrol", path="/academicAdminOffice/student/enrollment/bolonha/chooseCycleCourseGroupToEnrol.jsp"), @Forward(name="notAuthorized", path="/student/notAuthorized_bd.jsp")})
public abstract class AbstractBolonhaStudentEnrollmentDA
extends FenixDispatchAction {
    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)this.createStudentEnrolmentBean(form, studentCurricularPlan, executionSemester));
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    protected BolonhaStudentEnrollmentBean createStudentEnrolmentBean(ActionForm form, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        return new BolonhaStudentEnrollmentBean(studentCurricularPlan, executionSemester, this.getCurricularYearForCurricularCourses(), this.getCurricularRuleLevel(form));
    }

    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean) {
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)bolonhaStudentEnrollmentBean);
        request.setAttribute("action", (Object)this.getAction());
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    public ActionForward enrolInDegreeModules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean = this.getBolonhaStudentEnrollmentBeanFromViewState();
        try {
            RuleResult ruleResults = EnrolBolonhaStudent.run(bolonhaStudentEnrollmentBean.getStudentCurricularPlan(), bolonhaStudentEnrollmentBean.getExecutionPeriod(), bolonhaStudentEnrollmentBean.getDegreeModulesToEvaluate(), bolonhaStudentEnrollmentBean.getCurriculumModulesToRemove(), bolonhaStudentEnrollmentBean.getCurricularRuleLevel());
            if (!bolonhaStudentEnrollmentBean.getDegreeModulesToEvaluate().isEmpty() || !bolonhaStudentEnrollmentBean.getCurriculumModulesToRemove().isEmpty()) {
                this.addActionMessage("success", request, "label.save.success");
            }
            if (ruleResults.isWarning()) {
                this.addRuleResultMessagesToActionMessages("warning", request, ruleResults);
            }
            this.enroledWithSuccess(request, bolonhaStudentEnrollmentBean);
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("error", request, ex.getFalseResult());
            return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentEnrollmentBean);
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getKey(), ex.getArgs());
            return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentEnrollmentBean);
        }
        RenderUtils.invalidateViewState();
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentEnrollmentBean.getStudentCurricularPlan(), bolonhaStudentEnrollmentBean.getExecutionPeriod());
    }

    protected void enroledWithSuccess(HttpServletRequest request, BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean) {
    }

    protected BolonhaStudentEnrollmentBean getBolonhaStudentEnrollmentBeanFromViewState() {
        return (BolonhaStudentEnrollmentBean)this.getRenderedObject("bolonhaStudentEnrolments");
    }

    public ActionForward prepareChooseOptionalCurricularCourseToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentEnrollmentBean bean = this.getBolonhaStudentEnrollmentBeanFromViewState();
        request.setAttribute("optionalEnrolmentBean", (Object)new BolonhaStudentOptionalEnrollmentBean(bean.getStudentCurricularPlan(), bean.getExecutionPeriod(), bean.getOptionalDegreeModuleToEnrol()));
        request.setAttribute("curricularRuleLabels", this.getLabels(bean.getOptionalDegreeModuleToEnrol().getDegreeModule().getCurricularRules(bean.getExecutionPeriod())));
        return mapping.findForward("chooseOptionalCurricularCourseToEnrol");
    }

    private List<String> getLabels(List<CurricularRule> curricularRules) {
        ArrayList<String> result = new ArrayList<String>();
        for (CurricularRule curricularRule : curricularRules) {
            result.add(CurricularRuleLabelFormatter.getLabel(curricularRule));
        }
        return result;
    }

    public ActionForward enrolInOptionalCurricularCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        BolonhaStudentOptionalEnrollmentBean optionalStudentEnrollmentBean = this.getBolonhaStudentOptionalEnrollmentBeanFromViewState();
        try {
            RuleResult ruleResults = EnrolBolonhaStudent.run(optionalStudentEnrollmentBean.getStudentCurricularPlan(), optionalStudentEnrollmentBean.getExecutionPeriod(), this.buildOptionalDegreeModuleToEnrolList(optionalStudentEnrollmentBean), Collections.emptyList(), this.getCurricularRuleLevel(form));
            if (ruleResults.isWarning()) {
                this.addRuleResultMessagesToActionMessages("warning", request, ruleResults);
            }
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("error", request, ex.getFalseResult());
            request.setAttribute("optionalEnrolmentBean", (Object)optionalStudentEnrollmentBean);
            return mapping.findForward("chooseOptionalCurricularCourseToEnrol");
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getKey(), ex.getArgs());
            request.setAttribute("optionalEnrolmentBean", (Object)optionalStudentEnrollmentBean);
            return mapping.findForward("chooseOptionalCurricularCourseToEnrol");
        }
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, optionalStudentEnrollmentBean.getStudentCurricularPlan(), optionalStudentEnrollmentBean.getExecutionPeriod());
    }

    private List<IDegreeModuleToEvaluate> buildOptionalDegreeModuleToEnrolList(BolonhaStudentOptionalEnrollmentBean optionalStudentEnrollmentBean) {
        IDegreeModuleToEvaluate selectedDegreeModuleToEnrol = optionalStudentEnrollmentBean.getSelectedDegreeModuleToEnrol();
        OptionalDegreeModuleToEnrol optionalDegreeModuleToEnrol = new OptionalDegreeModuleToEnrol(selectedDegreeModuleToEnrol.getCurriculumGroup(), selectedDegreeModuleToEnrol.getContext(), optionalStudentEnrollmentBean.getExecutionPeriod(), optionalStudentEnrollmentBean.getSelectedOptionalCurricularCourse());
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        result.add(optionalDegreeModuleToEnrol);
        return result;
    }

    public ActionForward cancelChooseOptionalCurricularCourseToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentOptionalEnrollmentBean bolonhaStudentOptionalEnrollmentBean = this.getBolonhaStudentOptionalEnrollmentBeanFromViewState();
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentOptionalEnrollmentBean.getStudentCurricularPlan(), bolonhaStudentOptionalEnrollmentBean.getExecutionPeriod());
    }

    protected BolonhaStudentOptionalEnrollmentBean getBolonhaStudentOptionalEnrollmentBeanFromViewState() {
        return (BolonhaStudentOptionalEnrollmentBean)this.getRenderedObject("optionalEnrolment");
    }

    public ActionForward updateParametersToSearchOptionalCurricularCourses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentOptionalEnrollmentBean optionalBean = this.getBolonhaStudentOptionalEnrollmentBeanFromViewState();
        request.setAttribute("optionalEnrolmentBean", (Object)optionalBean);
        RenderUtils.invalidateViewState();
        request.setAttribute("curricularRuleLabels", this.getLabels(optionalBean.getSelectedDegreeModuleToEnrol().getDegreeModule().getCurricularRules(optionalBean.getExecutionPeriod())));
        return mapping.findForward("chooseOptionalCurricularCourseToEnrol");
    }

    public ActionForward prepareChooseCycleCourseGroupToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentEnrollmentBean studentEnrollmentBean = this.getBolonhaStudentEnrollmentBeanFromViewState();
        CycleEnrolmentBean cycleEnrolmentBean = new CycleEnrolmentBean(studentEnrollmentBean.getStudentCurricularPlan(), studentEnrollmentBean.getExecutionPeriod(), studentEnrollmentBean.getCycleTypeToEnrol().getSourceCycleAffinity(), studentEnrollmentBean.getCycleTypeToEnrol());
        request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
        return mapping.findForward("chooseCycleCourseGroupToEnrol");
    }

    protected ActionForward prepareChooseCycleCourseGroupToEnrol(ActionMapping mapping, HttpServletRequest request, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, CycleType sourceCycle, CycleType cycleToEnrol) {
        request.setAttribute("cycleEnrolmentBean", (Object)new CycleEnrolmentBean(studentCurricularPlan, executionSemester, sourceCycle, cycleToEnrol));
        return mapping.findForward("chooseCycleCourseGroupToEnrol");
    }

    public ActionForward enrolInCycleCourseGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CycleEnrolmentBean cycleEnrolmentBean = this.getCycleEnrolmentBeanFromViewState();
        try {
            EnrolInAffinityCycle.run(this.getLoggedPerson(request), cycleEnrolmentBean);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage(request, "error.NotAuthorized");
            request.setAttribute("withRules", (Object)request.getParameter("withRules"));
            request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
            return mapping.findForward("chooseCycleCourseGroupToEnrol");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("withRules", (Object)request.getParameter("withRules"));
            request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
            return mapping.findForward("chooseCycleCourseGroupToEnrol");
        }
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, cycleEnrolmentBean.getStudentCurricularPlan(), cycleEnrolmentBean.getExecutionPeriod());
    }

    public ActionForward enrolInCycleCourseGroupInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("cycleEnrolmentBean", (Object)this.getCycleEnrolmentBeanFromViewState());
        request.setAttribute("withRules", (Object)request.getParameter("withRules"));
        return mapping.findForward("chooseCycleCourseGroupToEnrol");
    }

    private CycleEnrolmentBean getCycleEnrolmentBeanFromViewState() {
        return (CycleEnrolmentBean)this.getRenderedObject("cycleEnrolmentBean");
    }

    public abstract ActionForward prepare(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4);

    protected abstract int[] getCurricularYearForCurricularCourses();

    protected abstract CurricularRuleLevel getCurricularRuleLevel(ActionForm var1);

    protected abstract String getAction();
}

