/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.accounting.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.fenixedu.commons.spreadsheet.converters.CellConverter;
import org.joda.time.LocalDate;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminPaymentsApp.class, path="sibs-reports", titleKey="label.payments.sibs.reports", accessGroup="academic(CREATE_SIBS_PAYMENTS_REPORT)")
@Mapping(path="/sibsReports", module="academicAdministration")
@Forwards(value={@Forward(name="report-by-year-month", path="/academicAdminOffice/accounting/reports/paymentsByYearAndMonth.jsp")})
public class ExportSibsPaymentsReport
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareReportByYearAndMonth(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("reportBean", (Object)new SibsPaymentsReportBean());
        return mapping.findForward("report-by-year-month");
    }

    public ActionForward reportByYearAndMonth(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SibsPaymentsReportBean bean = (SibsPaymentsReportBean)this.getRenderedObject("reportBean");
        request.setAttribute("reportBean", (Object)bean);
        SheetData<SibsPaymentFileProcessReport> spreadsheet = this.buildSpreadsheet(bean);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename(bean));
        ServletOutputStream writer = response.getOutputStream();
        new SpreadsheetBuilder().addSheet(this.getReportFilename(bean), spreadsheet).addConverter(Money.class, new CellConverter(){

            public Object convert(Object source) {
                return source != null ? ((Money)source).getAmount().doubleValue() : Double.valueOf(0.0).doubleValue();
            }
        }).build(WorkbookExportFormat.EXCEL, (OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private SheetData<SibsPaymentFileProcessReport> buildSpreadsheet(SibsPaymentsReportBean bean) {
        SheetData<SibsPaymentFileProcessReport> spreadsheet = new SheetData<SibsPaymentFileProcessReport>(this.getSibsPaymentFileProcessReports(bean)){

            private String getString(String key) {
                return BundleUtil.getString((String)"resources.ManagerResources", (String)key, (String[])new String[0]);
            }

            protected void makeLine(SibsPaymentFileProcessReport line) {
                this.addCell(this.getString("label.reports.date"), line.getWhenProcessedBySibs());
                this.addCell(this.getString("label.reports.version"), line.getFileVersion());
                this.addCell(this.getString("label.reports.gratuity.lic"), line.getDegreeGratuityTotalAmount());
                this.addCell(this.getString("label.reports.gratuity.lb"), line.getBolonhaDegreeGratuityTotalAmount());
                this.addCell(this.getString("label.reports.gratuity.mi"), line.getIntegratedBolonhaMasterDegreeGratuityTotalAmount());
                this.addCell(this.getString("label.reports.gratuity.mb"), line.getBolonhaMasterDegreeGratuityTotalAmount());
                this.addCell(this.getString("label.reports.grad.fee"), line.getAdministrativeOfficeTaxTotalAmount());
                this.addCell(this.getString("label.reports.insurance"), line.getGraduationInsuranceTotalAmount());
                this.addCell(this.getString("label.reports.proesp"), line.getSpecializationGratuityTotalAmount());
                this.addCell(this.getString("label.reports.propmest"), line.getMasterDegreeGratuityTotalAmount());
                this.addCell(this.getString("label.reports.propdout"), line.getPhdGratuityTotalAmount());
                this.addCell(this.getString("label.reports.propdfa"), line.getDfaGratuityTotalAmount());
                this.addCell(this.getString("label.reports.pgrad.fee"), line.getAfterGraduationInsuranceTotalAmount());
                this.addCell(this.getString("label.reports.residence"), line.getResidencePayment());
                this.addCell(this.getString("label.reports.degreeCandidacyForGraduatedPerson"), line.getDegreeCandidacyForGraduatedPersonAmount());
                this.addCell(this.getString("label.reports.degreeChangeIndividualCandidacy"), line.getDegreeChangeIndividualCandidacyAmount());
                this.addCell(this.getString("label.reports.degreeTransferIndividualCandidacy"), line.getDegreeTransferIndividualCandidacyAmount());
                this.addCell(this.getString("label.reports.secondCycleIndividualCandidacy"), line.getSecondCycleIndividualCandidacyAmount());
                this.addCell(this.getString("label.reports.standaloneEnrolmentGratuityEvent"), line.getStandaloneEnrolmentGratuityEventAmount());
                this.addCell(this.getString("label.reports.over23IndividualCandidacy"), line.getOver23IndividualCandidacyEventAmount());
                this.addCell(this.getString("label.reports.institutionAffiliation"), line.getInstitutionAffiliationEventAmount());
                this.addCell(this.getString("label.reports.phdProgramCandidacy"), line.getPhdProgramCandidacyEventAmount());
                this.addCell(this.getString("label.reports.rectorate"), line.getRectorateAmount());
                this.addCell(this.getString("label.reports.totrans"), line.getTransactionsTotalAmount());
                this.addCell(this.getString("label.reports.totarif"), line.getTotalCost());
            }
        };
        return spreadsheet;
    }

    private List<SibsPaymentFileProcessReport> getSibsPaymentFileProcessReports(SibsPaymentsReportBean bean) {
        LocalDate startDate = new LocalDate(bean.getYearAsInt(), bean.getMonthAsInt(), 1);
        LocalDate endDate = startDate.plusMonths(1).minusDays(1);
        List<SibsPaymentFileProcessReport> files = SibsPaymentFileProcessReport.readAllBetween(startDate, endDate);
        Collections.sort(files, SibsPaymentFileProcessReport.COMPARATOR_BY_SIBS_PROCESS_DATE);
        return files;
    }

    private String getReportFilename(SibsPaymentsReportBean bean) {
        return "SIBS-PAYMENTS-REPORTS-" + bean.getYear() + "-" + bean.getMonth() + ".xls";
    }

    public static class SibsPaymentsReportBean
    implements Serializable {
        private static final long serialVersionUID = -1884368228152926134L;
        private String year;
        private String month;

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        private int getYearAsInt() {
            return Integer.parseInt(this.getYear());
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        private int getMonthAsInt() {
            return Integer.parseInt(this.getMonth());
        }
    }
}

