/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.accounting;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceExemption;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeExemption;
import org.fenixedu.academic.domain.accounting.events.InsuranceExemption;
import org.fenixedu.academic.domain.accounting.events.InsuranceExemptionJustificationType;
import org.fenixedu.academic.dto.accounting.AdministrativeOfficeFeeAndInsuranceExemptionBean;
import org.fenixedu.academic.dto.accounting.InsuranceExemptionBean;
import org.fenixedu.academic.service.services.accounting.ExemptionsManagement$callable$createAdministrativeOfficeFeeAndInsuranceExemption;
import org.fenixedu.academic.service.services.accounting.ExemptionsManagement$callable$createInsuranceExemption;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExemptionsManagement {
    public static final Advice advice$createAdministrativeOfficeFeeAndInsuranceExemption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInsuranceExemption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void createAdministrativeOfficeFeeAndInsuranceExemption(Person person, AdministrativeOfficeFeeAndInsuranceExemptionBean administrativeOfficeFeeAndInsuranceExemptionBean) {
        Object object = advice$createAdministrativeOfficeFeeAndInsuranceExemption.perform((Callable)new ExemptionsManagement$callable$createAdministrativeOfficeFeeAndInsuranceExemption(person, administrativeOfficeFeeAndInsuranceExemptionBean));
    }

    static /* synthetic */ void advised$createAdministrativeOfficeFeeAndInsuranceExemption(Person responsible, AdministrativeOfficeFeeAndInsuranceExemptionBean exemptionBean) {
        AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = exemptionBean.getAdministrativeOfficeFeeAndInsuranceEvent();
        AdministrativeOfficeFeeAndInsuranceExemptionJustificationType justificationType = exemptionBean.getJustificationType();
        String reason = exemptionBean.getReason();
        YearMonthDay dispatchDate = exemptionBean.getDispatchDate();
        switch (exemptionBean.getApplyExemptionOn()) {
            case ADMINISTRATIVE_OFFICE_FEE: {
                new AdministrativeOfficeFeeExemption(responsible, administrativeOfficeFeeAndInsuranceEvent, justificationType, reason, dispatchDate);
                return;
            }
            case ADMINISTRATIVE_OFFICE_FEE_AND_INSURANCE: {
                new AdministrativeOfficeFeeAndInsuranceExemption(responsible, administrativeOfficeFeeAndInsuranceEvent, justificationType, reason, dispatchDate);
                return;
            }
            case INSURANCE_FEE: {
                InsuranceExemptionJustificationType insuranceJustificationType = null;
                switch (justificationType) {
                    case DIRECTIVE_COUNCIL_AUTHORIZATION: {
                        insuranceJustificationType = InsuranceExemptionJustificationType.DIRECTIVE_COUNCIL_AUTHORIZATION;
                        break;
                    }
                    case MIT_AGREEMENT: {
                        insuranceJustificationType = InsuranceExemptionJustificationType.MIT_AGREEMENT;
                    }
                }
                new InsuranceExemption(responsible, administrativeOfficeFeeAndInsuranceEvent, insuranceJustificationType, reason, dispatchDate);
            }
        }
    }

    public static void createInsuranceExemption(Person person, InsuranceExemptionBean insuranceExemptionBean) {
        Object object = advice$createInsuranceExemption.perform((Callable)new ExemptionsManagement$callable$createInsuranceExemption(person, insuranceExemptionBean));
    }

    static /* synthetic */ void advised$createInsuranceExemption(Person responsible, InsuranceExemptionBean exemptionBean) {
        new InsuranceExemption(responsible, exemptionBean.getInsuranceEvent(), exemptionBean.getJustificationType(), exemptionBean.getReason(), exemptionBean.getDispatchDate());
    }
}

