/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class Diploma
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected Diploma(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected DiplomaRequest getDocumentRequest() {
        return (DiplomaRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        DiplomaRequest diplomaRequest = this.getDocumentRequest();
        String universityName = this.getUniversity(diplomaRequest.getRequestDate()).getPartyName().getPreferedContent();
        this.addParameter("registryCode", diplomaRequest.hasRegistryCode() ? diplomaRequest.getRegistryCode().getCode() : null);
        this.addParameter("documentNumber", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.documentNumber", (String[])new String[0]));
        this.addParameter("conclusionDate", diplomaRequest.getConclusionDate().toString(this.getDatePattern(), this.getLocale()));
        this.addParameter("day", MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.university.actualDate", (String[])new String[0]), universityName, this.getFormatedCurrentDate()));
        if (diplomaRequest.hasFinalAverageDescription()) {
            this.addParameter("finalAverageDescription", StringUtils.capitalize((String)BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)diplomaRequest.getFinalAverage().toString(), (String[])new String[0])));
            this.addParameter("finalAverageQualified", diplomaRequest.getFinalAverageQualified());
        } else if (diplomaRequest.hasDissertationTitle()) {
            this.addParameter("dissertationTitle", diplomaRequest.getDissertationThesisTitle());
        }
        String finalAverage = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.finalAverage", (String[])new String[0]);
        this.addParameter("finalAverageDescription", MessageFormat.format(finalAverage, BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)diplomaRequest.getFinalAverage().toString(), (String[])new String[0]), diplomaRequest.getFinalAverage().toString(), BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)this.getQualifiedAverageGrade(this.getLocale()), (String[])new String[0])));
        this.addParameter("conclusionStatus", MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.conclusionStatus", (String[])new String[0]), this.getConclusionStatusAndDegreeType(diplomaRequest, this.getRegistration())));
        this.addParameter("degreeFilteredName", diplomaRequest.getDegreeFilteredName());
        String graduateTitle = diplomaRequest.getGraduateTitle(this.getLocale());
        this.addParameter("graduateTitle", graduateTitle);
        this.addParameter("message1", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.message1", (String[])new String[0]));
        this.addParameter("message2", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.message2", (String[])new String[0]));
        this.addParameter("message3", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.message3", (String[])new String[0]));
    }

    @Override
    protected void addIntroParameters() {
        String rectorGrant;
        String rectorGender;
        super.addIntroParameters();
        String institutionUnitName = this.getInstitutionName();
        Person principal = this.getUniversity(this.getDocumentRequest().getRequestDate()).getCurrentPrincipal();
        Person president = this.getUniversity(this.getDocumentRequest().getRequestDate()).getCurrentPresident();
        UniversityUnit university = this.getUniversity(this.getDocumentRequest().getRequestDate());
        String universityName = university.getPartyName().getPreferedContent();
        String presidentGender = president.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentMale", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentFemale", (String[])new String[0]);
        if (principal.isMale()) {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorMale", (String[])new String[0]);
            rectorGrant = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantMale", (String[])new String[0]);
        } else {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorFemale", (String[])new String[0]);
            rectorGrant = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantFemale", (String[])new String[0]);
        }
        this.addParameter("theRector", rectorGender);
        this.addParameter("president", MessageFormat.format(presidentGender, institutionUnitName));
        String firstParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.universityPrincipal", (String[])new String[0]);
        this.addParameter("firstParagraph", MessageFormat.format(firstParagraph, rectorGender, universityName, rectorGrant, principal.getValidatedName()));
        this.addParameter("universityPrincipal", (Object)principal);
        this.addParameter("universityPrincipalName", principal.getValidatedName());
        if (this.getUniversity(this.getDocumentRequest().getRequestDate()) != this.getUniversity(this.getDocumentRequest().getConclusionDate().toDateTimeAtCurrentTime())) {
            this.addParameter("UTLDescription", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.UTLDescription", (String[])new String[0]));
            this.addParameter("certification", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.certification.UTL", (String[])new String[0]));
        } else {
            this.addParameter("UTLDescription", "");
            this.addParameter("certification", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.certification.UL", (String[])new String[0]));
        }
    }

    @Override
    protected void setPersonFields() {
        Person person = this.getDocumentRequest().getPerson();
        this.addParameter("name", StringFormatter.prettyPrint(person.getName()));
        this.addParameter("nameOfFather", StringFormatter.prettyPrint(person.getNameOfFather()));
        this.addParameter("nameOfMother", StringFormatter.prettyPrint(person.getNameOfMother()));
        if (person.getCountry() == null) {
            throw new DomainException("error.personWithoutParishOfBirth", new String[0]);
        }
        String countryUpperCase = person.getCountry().getCountryNationality().getContent(this.getLanguage()).toLowerCase();
        String country = WordUtils.capitalize((String)countryUpperCase);
        String nationality = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.nationality", (String[])new String[0]);
        this.addParameter("birthLocale", MessageFormat.format(nationality, country));
    }

    private String getFormatedCurrentDate() {
        return new LocalDate().toString(this.getDatePattern(), this.getLocale());
    }

    private String getDatePattern() {
        StringBuilder result = new StringBuilder();
        result.append("dd '");
        result.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"label.of", (String[])new String[0]));
        result.append("' MMMM '");
        result.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"label.of", (String[])new String[0]));
        result.append("' yyyy");
        return result.toString();
    }

    private final String getConclusionStatusAndDegreeType(DiplomaRequest diplomaRequest, Registration registration) {
        StringBuilder result = new StringBuilder();
        if (registration.getDegreeType().isAdvancedFormationDiploma() || registration.getDegreeType().isAdvancedSpecializationDiploma()) {
            this.forDFA(result, diplomaRequest, registration);
        } else {
            this.forOthers(result, diplomaRequest, registration);
        }
        return result.toString();
    }

    private void forOthers(StringBuilder result, DiplomaRequest diplomaRequest, Registration registration) {
        DegreeType degreeType = registration.getDegreeType();
        if (degreeType.hasAnyCycleTypes() && diplomaRequest.getRequestedCycle() != null) {
            result.append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)diplomaRequest.getRequestedCycle().getQualifiedName(), (String[])new String[0]));
            result.append(" ").append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"of.masculine", (String[])new String[0])).append(" ");
        }
        result.append(degreeType.getPrefix(this.getLocale())).append(this.getDocumentRequest().getProgramConclusion().getDescription().getContent(this.getLocale()));
    }

    private void forDFA(StringBuilder result, DiplomaRequest diplomaRequest, Registration registration) {
        DegreeType degreeType = registration.getDegreeType();
        result.append(degreeType.getPrefix()).append(degreeType.getName().getContent());
        if (degreeType.hasExactlyOneCycleType()) {
            result.append(" (").append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)degreeType.getCycleType().getQualifiedName(), (String[])new String[0])).append(")");
        }
    }

    public String getQualifiedAverageGrade(Locale locale) {
        Integer finalGrade = this.getDocumentRequest().getFinalAverage();
        String qualifiedAverageGrade = finalGrade <= 13 ? "sufficient" : (finalGrade <= 15 ? "good" : (finalGrade <= 17 ? "verygood" : "excelent"));
        return "diploma.supplement.qualifiedgrade." + qualifiedAverageGrade;
    }

    @Override
    protected String getDegreeDescription() {
        if (this.getRegistration() == null) {
            return super.getDegreeDescription();
        }
        return this.getRegistration().getDegreeDescription(this.getRegistration().getStartExecutionYear(), this.getDocumentRequest().getProgramConclusion(), this.getLocale());
    }
}

