/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class ResourceAllocationRolePredicates {
    public static final AccessControlPredicate<Lesson> checkPermissionsToManageLessons = new AccessControlPredicate<Lesson>(){

        @Override
        public boolean evaluate(Lesson lesson) {
            return RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(AccessControl.getPerson().getUser());
        }
    };
    public static final AccessControlPredicate<Shift> checkPermissionsToManageShifts = new AccessControlPredicate<Shift>(){

        @Override
        public boolean evaluate(Shift shift) {
            return RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(AccessControl.getPerson().getUser());
        }
    };
    public static final AccessControlPredicate<SchoolClass> checkPermissionsToManageSchoolClass = new AccessControlPredicate<SchoolClass>(){

        @Override
        public boolean evaluate(SchoolClass schoolClass) {
            return RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(AccessControl.getPerson().getUser());
        }
    };
    public static final AccessControlPredicate<LessonInstance> checkPermissionsToManageLessonInstances = new AccessControlPredicate<LessonInstance>(){

        @Override
        public boolean evaluate(LessonInstance lessonInstance) {
            return RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(AccessControl.getPerson().getUser());
        }
    };
    public static final AccessControlPredicate<LessonInstance> checkPermissionsToManageLessonInstancesWithTeacherCheck = new AccessControlPredicate<LessonInstance>(){

        @Override
        public boolean evaluate(LessonInstance lessonInstance) {
            Person loggedPerson = AccessControl.getPerson();
            ExecutionCourse executionCourse = lessonInstance.getLesson().getExecutionCourse();
            if (loggedPerson.getProfessorshipsSet().size() > 0 && loggedPerson.hasProfessorshipForExecutionCourse(executionCourse)) {
                return true;
            }
            return RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(AccessControl.getPerson().getUser());
        }
    };
}

