/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import jvstm.cps.ConsistencyPredicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.NonAffiliatedTeacher;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit$callable$getOneUnitBasedSender;
import org.fenixedu.academic.domain.organizationalStructure.UnitAcronym;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UnitCostCenterCode;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.organizationalStructure.Unit_Base;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Unit
extends Unit_Base {
    public static final Advice advice$getOneUnitBasedSender = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected Unit() {
    }

    protected void init(MultiLanguageString name, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        this.setPartyName(name);
        if (acronym != null) {
            this.setAcronym(acronym);
        }
        if (this.getCostCenterCode() == null || !this.getCostCenterCode().equals(costCenterCode)) {
            this.setCostCenterCode(costCenterCode);
        }
        this.setIdentificationCardLabel(unitNameCard);
        this.setBeginDateYearMonthDay(beginDate);
        this.setEndDateYearMonthDay(endDate);
        this.setClassification(classification);
        this.setAdministrativeOffice(administrativeOffice);
        this.setCanBeResponsibleOfSpaces(canBeResponsibleOfSpaces);
        this.setCampus(campus);
        this.setDefaultWebAddressUrl(webAddress);
    }

    public void setPartyName(MultiLanguageString partyName) {
        if (partyName == null || partyName.isEmpty()) {
            throw new DomainException("error.Party.empty.partyName", new String[0]);
        }
        super.setPartyName(partyName);
        this.setName(partyName.getPreferedContent());
    }

    public String getName() {
        return this.getPartyName().getPreferedContent();
    }

    public void setName(String name) {
        if (name == null || StringUtils.isEmpty((String)name.trim())) {
            throw new DomainException("error.person.empty.name", new String[0]);
        }
        MultiLanguageString partyName = this.getPartyName();
        partyName = partyName == null ? new MultiLanguageString(Locale.getDefault(), name) : partyName.with(Locale.getDefault(), name);
        super.setPartyName(partyName);
        UnitName unitName = this.getUnitName();
        unitName = unitName == null ? new UnitName(this) : unitName;
        unitName.setName(name);
    }

    public void edit(MultiLanguageString name, String acronym) {
        this.setPartyName(name);
        this.setAcronym(acronym);
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        this.init(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, administrativeOffice, canBeResponsibleOfSpaces, campus);
    }

    public void setCanBeResponsibleOfSpaces(Boolean canBeResponsibleOfSpaces) {
        super.setCanBeResponsibleOfSpaces(canBeResponsibleOfSpaces != null ? canBeResponsibleOfSpaces : Boolean.FALSE);
    }

    public void setCostCenterCode(Integer costCenterCode) {
        UnitCostCenterCode otherUnitCostCenterCode = UnitCostCenterCode.find(costCenterCode);
        if (otherUnitCostCenterCode != null && otherUnitCostCenterCode.getUnit() != this) {
            throw new DomainException("error.costCenter.alreadyExists", new String[0]);
        }
        UnitCostCenterCode unitCostCenterCode = this.getUnitCostCenterCode();
        if (unitCostCenterCode == null && costCenterCode != null) {
            new UnitCostCenterCode(this, costCenterCode);
        } else if (unitCostCenterCode != null && costCenterCode != null) {
            unitCostCenterCode.setCostCenterCode(costCenterCode);
        } else if (unitCostCenterCode != null && costCenterCode == null) {
            unitCostCenterCode.delete();
        }
    }

    public Integer getCostCenterCode() {
        UnitCostCenterCode unitCostCenterCode = this.getUnitCostCenterCode();
        return unitCostCenterCode == null ? null : unitCostCenterCode.getCostCenterCode();
    }

    @ConsistencyPredicate
    protected boolean checkDateInterval() {
        YearMonthDay start = this.getBeginDateYearMonthDay();
        YearMonthDay end = this.getEndDateYearMonthDay();
        return start != null && (end == null || !start.isAfter((ReadablePartial)end));
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        if (this.hasAnyParentUnits()) {
            ((Accountability)((Object)this.getParentsSet().iterator().next())).delete();
        }
        this.getUnitName().delete();
        this.setRootDomainObjectForEarthUnit(null);
        this.setRootDomainObjectForExternalInstitutionUnit(null);
        this.setRootDomainObjectForInstitutionUnit(null);
        this.setCampus(null);
        this.setUnitAcronym(null);
        this.setAdministrativeOffice(null);
        super.delete();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getParentsSet().isEmpty() && (this.getParentsSet().size() != 1 || this.getParentUnits().size() != 1) && this.getChildsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.unit.cannot.be.deleted", (String[])new String[0]));
        }
        if (this.getUnitServiceAgreementTemplate() != null || !this.getOwnedReceiptsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.unit.cannot.be.deleted", (String[])new String[0]));
        }
        if (!(this.getAssociatedNonAffiliatedTeachersSet().isEmpty() && this.getExternalCurricularCoursesSet().isEmpty() && this.getPrecedentDegreeInformationsSet().isEmpty() && this.getCandidacyPrecedentDegreeInformationsSet().isEmpty() && this.getExternalRegistrationDatasSet().isEmpty() && this.getExternalCourseLoadRequestsSet().isEmpty() && this.getExternalProgramCertificateRequestsSet().isEmpty() && this.getUnitGroupSet().isEmpty())) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.unit.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public Space getCampus() {
        Space campus = super.getCampus();
        if (campus != null) {
            return campus;
        }
        Collection<Unit> parentUnits = this.getParentUnits();
        if (parentUnits.size() == 1) {
            campus = parentUnits.iterator().next().getCampus();
        }
        return campus;
    }

    public boolean isInternal() {
        if (this.equals((Object)UnitUtils.readInstitutionUnit())) {
            return true;
        }
        for (Unit parentUnit : this.getParentUnits()) {
            if (!parentUnit.isInternal()) continue;
            return true;
        }
        return false;
    }

    public boolean isNoOfficialExternal() {
        if (this.equals((Object)UnitUtils.readExternalInstitutionUnit())) {
            return true;
        }
        for (Unit parentUnit : this.getParentUnits()) {
            if (!parentUnit.isNoOfficialExternal()) continue;
            return true;
        }
        return false;
    }

    public boolean isOfficialExternal() {
        return !this.isInternal() && !this.isNoOfficialExternal();
    }

    public boolean isActive(YearMonthDay currentDate) {
        return !this.getBeginDateYearMonthDay().isAfter((ReadablePartial)currentDate) && (this.getEndDateYearMonthDay() == null || !this.getEndDateYearMonthDay().isBefore((ReadablePartial)currentDate));
    }

    public boolean isUnit() {
        return true;
    }

    public List<Unit> getTopUnits() {
        Unit unit = this;
        ArrayList<Unit> allTopUnits = new ArrayList<Unit>();
        if (unit.hasAnyParentUnits()) {
            for (Unit parentUnit : this.getParentUnits()) {
                if (!parentUnit.hasAnyParentUnits() && !allTopUnits.contains((Object)parentUnit)) {
                    allTopUnits.add(parentUnit);
                    continue;
                }
                if (!parentUnit.hasAnyParentUnits()) continue;
                for (Unit parentUnit2 : parentUnit.getTopUnits()) {
                    if (allTopUnits.contains((Object)parentUnit2)) continue;
                    allTopUnits.add(parentUnit2);
                }
            }
        }
        return allTopUnits;
    }

    public Department getDepartment() {
        return null;
    }

    public Degree getDegree() {
        return null;
    }

    public DepartmentUnit getDepartmentUnit() {
        if (this.isDepartmentUnit()) {
            return (DepartmentUnit)((Object)this);
        }
        for (Unit parentUnit : this.getParentUnits()) {
            DepartmentUnit departmentUnit;
            if (parentUnit.isDepartmentUnit()) {
                return (DepartmentUnit)((Object)parentUnit);
            }
            if (!parentUnit.hasAnyParentUnits() || (departmentUnit = parentUnit.getDepartmentUnit()) == null) continue;
            return departmentUnit;
        }
        return null;
    }

    public List<Unit> getInactiveSubUnits(YearMonthDay currentDate) {
        return this.getSubUnitsByState(currentDate, false);
    }

    public List<Unit> getActiveSubUnits(YearMonthDay currentDate) {
        return this.getSubUnitsByState(currentDate, true);
    }

    private List<Unit> getSubUnitsByState(YearMonthDay currentDate, boolean state) {
        ArrayList<Unit> allSubUnits = new ArrayList<Unit>();
        for (Unit subUnit : this.getSubUnits()) {
            if (subUnit.isActive(currentDate) != state) continue;
            allSubUnits.add(subUnit);
        }
        return allSubUnits;
    }

    public List<Unit> getInactiveParentUnits(YearMonthDay currentDate) {
        return this.getParentUnitsByState(currentDate, false);
    }

    public List<Unit> getActiveParentUnits(YearMonthDay currentDate) {
        return this.getParentUnitsByState(currentDate, true);
    }

    private List<Unit> getParentUnitsByState(YearMonthDay currentDate, boolean state) {
        ArrayList<Unit> allParentUnits = new ArrayList<Unit>();
        for (Unit subUnit : this.getParentUnits()) {
            if (subUnit.isActive(currentDate) != state) continue;
            allParentUnits.add(subUnit);
        }
        return allParentUnits;
    }

    public List<Unit> getInactiveSubUnits(YearMonthDay currentDate, AccountabilityTypeEnum accountabilityTypeEnum) {
        return this.getSubUnitsByState(currentDate, accountabilityTypeEnum, false);
    }

    public List<Unit> getActiveSubUnits(YearMonthDay currentDate, AccountabilityTypeEnum accountabilityTypeEnum) {
        return this.getSubUnitsByState(currentDate, accountabilityTypeEnum, true);
    }

    private List<Unit> getSubUnitsByState(YearMonthDay currentDate, AccountabilityTypeEnum accountabilityTypeEnum, boolean state) {
        ArrayList<Unit> allSubUnits = new ArrayList<Unit>();
        for (Unit subUnit : this.getSubUnits(accountabilityTypeEnum)) {
            if (subUnit.isActive(currentDate) != state) continue;
            allSubUnits.add(subUnit);
        }
        return allSubUnits;
    }

    public List<Unit> getActiveSubUnits(YearMonthDay currentDate, List<AccountabilityTypeEnum> accountabilityTypeEnums) {
        return this.getSubUnitsByState(currentDate, accountabilityTypeEnums, true);
    }

    public List<Unit> getInactiveSubUnits(YearMonthDay currentDate, List<AccountabilityTypeEnum> accountabilityTypeEnums) {
        return this.getSubUnitsByState(currentDate, accountabilityTypeEnums, false);
    }

    private List<Unit> getSubUnitsByState(YearMonthDay currentDate, List<AccountabilityTypeEnum> accountabilityTypeEnums, boolean state) {
        ArrayList<Unit> allSubUnits = new ArrayList<Unit>();
        for (Unit subUnit : this.getSubUnits(accountabilityTypeEnums)) {
            if (subUnit.isActive(currentDate) != state) continue;
            allSubUnits.add(subUnit);
        }
        return allSubUnits;
    }

    public List<Unit> getAllInactiveParentUnits(YearMonthDay currentDate) {
        HashSet<Unit> allInactiveParentUnits = new HashSet<Unit>();
        allInactiveParentUnits.addAll(this.getInactiveParentUnits(currentDate));
        for (Unit subUnit : this.getParentUnits()) {
            allInactiveParentUnits.addAll(subUnit.getAllInactiveParentUnits(currentDate));
        }
        return new ArrayList<Unit>(allInactiveParentUnits);
    }

    public List<Unit> getAllActiveParentUnits(YearMonthDay currentDate) {
        HashSet<Unit> allActiveParentUnits = new HashSet<Unit>();
        allActiveParentUnits.addAll(this.getActiveParentUnits(currentDate));
        for (Unit subUnit : this.getParentUnits()) {
            allActiveParentUnits.addAll(subUnit.getAllActiveParentUnits(currentDate));
        }
        return new ArrayList<Unit>(allActiveParentUnits);
    }

    public List<Unit> getAllInactiveSubUnits(YearMonthDay currentDate) {
        HashSet<Unit> allInactiveSubUnits = new HashSet<Unit>();
        allInactiveSubUnits.addAll(this.getInactiveSubUnits(currentDate));
        for (Unit subUnit : this.getSubUnits()) {
            allInactiveSubUnits.addAll(subUnit.getAllInactiveSubUnits(currentDate));
        }
        return new ArrayList<Unit>(allInactiveSubUnits);
    }

    public List<Unit> getAllActiveSubUnits(YearMonthDay currentDate) {
        HashSet<Unit> allActiveSubUnits = new HashSet<Unit>();
        allActiveSubUnits.addAll(this.getActiveSubUnits(currentDate));
        for (Unit subUnit : this.getSubUnits()) {
            allActiveSubUnits.addAll(subUnit.getAllActiveSubUnits(currentDate));
        }
        return new ArrayList<Unit>(allActiveSubUnits);
    }

    public List<Unit> getAllActiveSubUnits(YearMonthDay currentDate, AccountabilityTypeEnum accountabilityTypeEnum) {
        HashSet<Unit> allActiveSubUnits = new HashSet<Unit>();
        allActiveSubUnits.addAll(this.getActiveSubUnits(currentDate, accountabilityTypeEnum));
        for (Unit subUnit : this.getSubUnits(accountabilityTypeEnum)) {
            allActiveSubUnits.addAll(subUnit.getAllActiveSubUnits(currentDate));
        }
        return new ArrayList<Unit>(allActiveSubUnits);
    }

    public List<Unit> getAllActiveSubUnitsWithAllowedChildParties(YearMonthDay currentDate, PartyType childType) {
        HashSet<Unit> allActiveSubUnits = new HashSet<Unit>();
        allActiveSubUnits.addAll(this.getActiveSubUnitsWithAllowedChildParties(currentDate, childType));
        for (Unit subUnit : this.getSubUnits()) {
            allActiveSubUnits.addAll(subUnit.getAllActiveSubUnitsWithAllowedChildParties(currentDate, childType));
        }
        return new ArrayList<Unit>(allActiveSubUnits);
    }

    protected List<Unit> getActiveSubUnitsWithAllowedChildParties(YearMonthDay currentDate, PartyType childType) {
        ArrayList<Unit> allSubUnits = new ArrayList<Unit>();
        for (Unit subUnit : this.getSubUnits()) {
            if (!subUnit.isActive(currentDate) || !subUnit.getAllowedChildPartyTypes(null).contains((Object)childType)) continue;
            allSubUnits.add(subUnit);
        }
        return allSubUnits;
    }

    public Collection<PartyType> getAllowedChildPartyTypes(Boolean managedByUser) {
        return this.getPartyType().getAllowedChildPartyTypes(managedByUser);
    }

    public Accountability getMostRecentParentUnitAccountability() {
        return this.getParentUnitAccountabilities().isEmpty() ? null : Collections.max(this.getParentUnitAccountabilities(), Accountability.getComparatorByBeginDate());
    }

    public Collection<? extends Accountability> getParentUnitAccountabilities() {
        return this.getParentAccountabilitiesByParentClass(Unit.class);
    }

    public Collection<? extends Accountability> getChildUnitAccountabilities() {
        return this.getChildAccountabilitiesByChildClass(Unit.class);
    }

    public List<Unit> getAllInactiveSubUnits(YearMonthDay currentDate, AccountabilityTypeEnum accountabilityTypeEnum) {
        HashSet<Unit> allInactiveSubUnits = new HashSet<Unit>();
        allInactiveSubUnits.addAll(this.getInactiveSubUnits(currentDate, accountabilityTypeEnum));
        for (Unit subUnit : this.getSubUnits(accountabilityTypeEnum)) {
            allInactiveSubUnits.addAll(subUnit.getAllInactiveSubUnits(currentDate));
        }
        return new ArrayList<Unit>(allInactiveSubUnits);
    }

    public Collection<Unit> getAllSubUnits() {
        HashSet<Unit> allSubUnits = new HashSet<Unit>();
        Collection<Unit> subUnits = this.getSubUnits();
        allSubUnits.addAll(subUnits);
        for (Unit subUnit : subUnits) {
            allSubUnits.addAll(subUnit.getAllSubUnits());
        }
        return allSubUnits;
    }

    public Collection<Unit> getAllParentUnits() {
        HashSet<Unit> allParentUnits = new HashSet<Unit>();
        Collection<Unit> parentUnits = this.getParentUnits();
        allParentUnits.addAll(parentUnits);
        for (Unit subUnit : parentUnits) {
            allParentUnits.addAll(subUnit.getAllParentUnits());
        }
        return allParentUnits;
    }

    public Collection<Unit> getParentUnits() {
        return this.getParentParties(Unit.class);
    }

    public Collection<Unit> getParentUnits(String accountabilityTypeEnum) {
        return this.getParentParties(AccountabilityTypeEnum.valueOf(accountabilityTypeEnum), Unit.class);
    }

    public Collection<Unit> getParentUnits(AccountabilityTypeEnum accountabilityTypeEnum) {
        return this.getParentParties(accountabilityTypeEnum, Unit.class);
    }

    public Collection<Unit> getParentUnits(List<AccountabilityTypeEnum> accountabilityTypeEnums) {
        return this.getParentParties(accountabilityTypeEnums, Unit.class);
    }

    public Collection<Unit> getSubUnits() {
        return this.getChildParties(Unit.class);
    }

    public boolean hasSubUnit(Unit unit) {
        if (unit != null) {
            for (Unit child : this.getSubUnits()) {
                if (!child.equals((Object)unit)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Unit> getSubUnits(AccountabilityTypeEnum accountabilityTypeEnum) {
        return this.getChildParties(accountabilityTypeEnum, Unit.class);
    }

    public Collection<Unit> getSubUnits(List<AccountabilityTypeEnum> accountabilityTypeEnums) {
        return this.getChildParties(accountabilityTypeEnums, Unit.class);
    }

    public Collection<Unit> getSubUnits(PartyTypeEnum type) {
        return this.getChildParties(type, Unit.class);
    }

    public boolean hasAnyParentUnits() {
        return !this.getParentUnits().isEmpty();
    }

    public boolean hasAnySubUnits() {
        return !this.getSubUnits().isEmpty();
    }

    public Collection<Unit> getCurrentParentByOrganizationalStructureAccountabilityType() {
        return this.getCurrentParentParties(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, Unit.class);
    }

    public Collection<Unit> getParentUnitsByOrganizationalStructureAccountabilityType() {
        return this.getParentParties(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, Unit.class);
    }

    public UnitBasedSender getOneUnitBasedSender() {
        return (UnitBasedSender)((Object)advice$getOneUnitBasedSender.perform((Callable)new Unit$callable$getOneUnitBasedSender(this)));
    }

    static /* synthetic */ UnitBasedSender advised$getOneUnitBasedSender(Unit this_) {
        if (!this_.getUnitBasedSenderSet().isEmpty()) {
            return (UnitBasedSender)((Object)this_.getUnitBasedSenderSet().iterator().next());
        }
        return UnitBasedSender.newInstance(this_);
    }

    public int getUnitDepth() {
        int depth = 0;
        for (Unit unit : this.getParentUnits()) {
            depth = Math.max(depth, 1 + unit.getUnitDepth());
        }
        return depth;
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        List<Unit> subUnits;
        if (this.equals((Object)parentUnit)) {
            throw new DomainException("error.unit.equals.parentUnit", new String[0]);
        }
        if (this.getParentUnits(accountabilityType.getType()).contains((Object)parentUnit)) {
            throw new DomainException("error.unit.parentUnit.is.already.parentUnit", new String[0]);
        }
        YearMonthDay currentDate = new YearMonthDay();
        List<Unit> list = subUnits = parentUnit.isActive(currentDate) ? this.getAllActiveSubUnits(currentDate) : this.getAllInactiveSubUnits(currentDate);
        if (subUnits.contains((Object)parentUnit)) {
            throw new DomainException("error.unit.parentUnit.is.already.subUnit", new String[0]);
        }
        return new Accountability((Party)((Object)parentUnit), (Party)((Object)this), accountabilityType);
    }

    public NonAffiliatedTeacher findNonAffiliatedTeacherByName(String name) {
        for (NonAffiliatedTeacher nonAffiliatedTeacher : this.getAssociatedNonAffiliatedTeachersSet()) {
            if (!nonAffiliatedTeacher.getName().equalsIgnoreCase(name)) continue;
            return nonAffiliatedTeacher;
        }
        return null;
    }

    public Unit getChildUnitByAcronym(String acronym) {
        for (Unit subUnit : this.getSubUnits()) {
            if (subUnit.getAcronym() == null || !subUnit.getAcronym().equals(acronym)) continue;
            return subUnit;
        }
        return null;
    }

    public static List<Unit> readAllUnits() {
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        for (Party party : Bennu.getInstance().getPartysSet()) {
            if (!party.isUnit()) continue;
            allUnits.add((Unit)((Object)party));
        }
        return allUnits;
    }

    public static Unit readUnitByAcronymAndType(String acronym, PartyTypeEnum partyTypeEnum) {
        UnitAcronym unitAcronymByAcronym;
        if (acronym != null && !acronym.equals("") && partyTypeEnum != null && (partyTypeEnum.equals((Object)PartyTypeEnum.DEGREE_UNIT) || partyTypeEnum.equals((Object)PartyTypeEnum.DEPARTMENT) || partyTypeEnum.equals((Object)PartyTypeEnum.PLANET) || partyTypeEnum.equals((Object)PartyTypeEnum.COUNTRY) || partyTypeEnum.equals((Object)PartyTypeEnum.DEPARTMENT) || partyTypeEnum.equals((Object)PartyTypeEnum.UNIVERSITY) || partyTypeEnum.equals((Object)PartyTypeEnum.SCHOOL) || partyTypeEnum.equals((Object)PartyTypeEnum.RESEARCH_UNIT)) && (unitAcronymByAcronym = UnitAcronym.readUnitAcronymByAcronym(acronym)) != null) {
            for (Unit unit : unitAcronymByAcronym.getUnitsSet()) {
                if (unit.getType() == null || !unit.getType().equals((Object)partyTypeEnum)) continue;
                return unit;
            }
        }
        return null;
    }

    public static List<Unit> readUnitsByAcronym(String acronym, boolean shouldNormalize) {
        UnitAcronym unitAcronymByAcronym;
        ArrayList<Unit> result = new ArrayList<Unit>();
        if (!StringUtils.isEmpty((String)acronym.trim()) && (unitAcronymByAcronym = UnitAcronym.readUnitAcronymByAcronym(acronym, shouldNormalize)) != null) {
            result.addAll(unitAcronymByAcronym.getUnitsSet());
        }
        return result;
    }

    public static List<Unit> readUnitsByAcronym(String acronym) {
        return Unit.readUnitsByAcronym(acronym, false);
    }

    public static Unit readByCostCenterCode(Integer costCenterCode) {
        UnitCostCenterCode unitCostCenterCode = UnitCostCenterCode.find(costCenterCode);
        return unitCostCenterCode == null ? null : unitCostCenterCode.getUnit();
    }

    public static Unit createNewUnit(MultiLanguageString unitName, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        Unit unit = new Unit();
        unit.init(unitName, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, administrativeOffice, canBeResponsibleOfSpaces, campus);
        if (parentUnit != null && accountabilityType != null) {
            unit.addParentUnit(parentUnit, accountabilityType);
        }
        return unit;
    }

    public static Unit createNewNoOfficialExternalInstitution(String unitName) {
        return Unit.createNewNoOfficialExternalInstitution(unitName, null);
    }

    public static Unit createNewNoOfficialExternalInstitution(String unitName, Country country) {
        Unit externalInstitutionUnit = UnitUtils.readExternalInstitutionUnit();
        Unit noOfficialExternalInstitutionUnit = new Unit();
        noOfficialExternalInstitutionUnit.init(new MultiLanguageString(Locale.getDefault(), unitName), null, null, null, new YearMonthDay(), null, null, null, null, null, null);
        noOfficialExternalInstitutionUnit.addParentUnit(externalInstitutionUnit, AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE));
        noOfficialExternalInstitutionUnit.setCountry(country);
        return noOfficialExternalInstitutionUnit;
    }

    public static Unit findFirstExternalUnitByName(String unitName) {
        if (unitName == null || unitName.length() == 0) {
            return null;
        }
        for (Party party : Bennu.getInstance().getExternalInstitutionUnit().getSubUnits()) {
            if (party.isPerson() || !unitName.equalsIgnoreCase(party.getName())) continue;
            Unit unit = (Unit)((Object)party);
            return unit;
        }
        return null;
    }

    public static Unit findFirstUnitByName(String unitNameString) {
        if (StringUtils.isEmpty((String)unitNameString)) {
            return null;
        }
        Collection<UnitName> unitNames = UnitName.find(unitNameString, Integer.MAX_VALUE);
        for (UnitName unitName : unitNames) {
            Unit unit = unitName.getUnit();
            if (!StringNormalizer.normalize((String)unitNameString).equalsIgnoreCase(StringNormalizer.normalize((String)unit.getName()))) continue;
            return unit;
        }
        return null;
    }

    public String getNameWithAcronym() {
        String name = this.getName().trim();
        return this.getAcronym() == null || StringUtils.isEmpty((String)this.getAcronym().trim()) ? name : name + " (" + this.getAcronym().trim() + ")";
    }

    public String getPresentationName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNameWithAcronym());
        if (this.getCostCenterCode() != null) {
            builder.append(" [c.c. ").append(this.getCostCenterCode()).append("]");
        }
        return builder.toString();
    }

    public String getPresentationNameWithParents() {
        String parentUnits = this.getParentUnitsPresentationName();
        return !StringUtils.isEmpty((String)parentUnits.trim()) ? parentUnits + " - " + this.getPresentationName() : this.getPresentationName();
    }

    public String getPresentationNameWithParentsAndBreakLine() {
        String parentUnits = this.getParentUnitsPresentationNameWithBreakLine();
        return !StringUtils.isEmpty((String)parentUnits.trim()) ? parentUnits + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.html.breakLine", (String[])new String[0]) + this.getPresentationName() : this.getPresentationName();
    }

    public String getParentUnitsPresentationNameWithBreakLine() {
        return this.getParentUnitsPresentationName(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.html.breakLine", (String[])new String[0]));
    }

    public String getParentUnitsPresentationName() {
        return this.getParentUnitsPresentationName(" - ");
    }

    private String getParentUnitsPresentationName(String separator) {
        StringBuilder builder = new StringBuilder();
        List<Unit> parentUnits = this.getParentUnitsPath();
        int index = 1;
        for (Unit unit : parentUnits) {
            if (!unit.isAggregateUnit()) {
                if (index == 1) {
                    builder.append(unit.getNameWithAcronym());
                } else {
                    builder.append(separator + unit.getNameWithAcronym());
                }
            }
            ++index;
        }
        return builder.toString();
    }

    public String getUnitPath(String separator) {
        return this.getUnitPath(separator, true);
    }

    public String getUnitPath(String separator, boolean addInstitutionalUnit) {
        StringBuilder builder = new StringBuilder();
        List<Unit> parentUnits = this.getParentUnitsPath(addInstitutionalUnit);
        int index = 1;
        for (Unit unit : parentUnits) {
            if (!unit.isAggregateUnit()) {
                if (index == 1) {
                    builder.append(unit.getAcronym());
                } else {
                    builder.append(separator + unit.getAcronym());
                }
            }
            ++index;
        }
        builder.append("/");
        builder.append(this.getAcronym());
        return builder.toString();
    }

    public List<Unit> getParentUnitsPath() {
        return this.getParentUnitsPath(true);
    }

    public List<Unit> getParentUnitsPath(boolean addInstitutionalUnit) {
        ArrayList<Unit> parentUnits = new ArrayList<Unit>();
        Unit searchedUnit = this;
        Unit externalInstitutionUnit = UnitUtils.readExternalInstitutionUnit();
        Unit institutionUnit = UnitUtils.readInstitutionUnit();
        Unit earthUnit = UnitUtils.readEarthUnit();
        while (searchedUnit.getParentUnits().size() == 1) {
            Unit parentUnit = searchedUnit.getParentUnits().iterator().next();
            if (addInstitutionalUnit || parentUnit != institutionUnit) {
                parentUnits.add(0, parentUnit);
            }
            if (parentUnit == institutionUnit || parentUnit == externalInstitutionUnit || parentUnit == earthUnit) break;
            searchedUnit = parentUnit;
        }
        if (searchedUnit.getParentUnits().size() > 1) {
            if (searchedUnit.isInternal() && addInstitutionalUnit) {
                parentUnits.add(0, institutionUnit);
            } else if (searchedUnit.isNoOfficialExternal()) {
                parentUnits.add(0, externalInstitutionUnit);
            } else {
                parentUnits.add(0, earthUnit);
            }
        }
        return parentUnits;
    }

    public String getDirectParentUnitsPresentationName() {
        StringBuilder builder = new StringBuilder();
        for (Unit unit : this.getParentUnits()) {
            if (unit.isAggregateUnit()) continue;
            builder.append(unit.getNameWithAcronym());
        }
        return builder.toString();
    }

    public String getShortPresentationName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Unit unit : this.getParentUnits()) {
            if (unit.isAggregateUnit() || unit == Bennu.getInstance().getInstitutionUnit()) continue;
            stringBuilder.append(unit.getName());
            stringBuilder.append(" - ");
        }
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public SortedSet<Unit> getSortedExternalChilds() {
        TreeSet<Unit> result = new TreeSet<Unit>(COMPARATOR_BY_NAME_AND_ID);
        for (Unit unit : this.getSubUnits()) {
            if (unit.isInternal()) continue;
            result.add(unit);
        }
        return result;
    }

    public List<ExternalCurricularCourse> getAllExternalCurricularCourses() {
        return new ArrayList<ExternalCurricularCourse>(this.getExternalCurricularCoursesSet());
    }

    public MultiLanguageString getNameI18n() {
        return this.getPartyName();
    }

    public boolean isEarth() {
        return this.equals((Object)Bennu.getInstance().getEarthUnit());
    }

    public String getPartyPresentationName() {
        return this.getPresentationNameWithParents();
    }

    public List<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.addAll(this.getDefaultGroups());
        return groups;
    }

    protected List<Group> getDefaultGroups() {
        return new ArrayList<Group>();
    }

    public static MultiLanguageString getInstitutionName() {
        return Optional.ofNullable(Bennu.getInstance().getInstitutionUnit()).map(Unit::getNameI18n).orElseGet(() -> MultiLanguageString.fromLocalizedString(BundleUtil.getLocalizedString((String)"resources.GlobalResources", (String)"error.institutionUnit.notconfigured", (String[])new String[0])));
    }

    public static String getInstitutionAcronym() {
        return Optional.ofNullable(Bennu.getInstance().getInstitutionUnit()).map(Unit_Base::getAcronym).orElseGet(() -> BundleUtil.getString((String)"resources.GlobalResources", (String)"error.institutionUnit.notconfigured", (String[])new String[0]));
    }

    public Country getCountry() {
        if (super.getCountry() != null) {
            return super.getCountry();
        }
        for (Unit unit : this.getParentUnits()) {
            Country country = unit.getCountry();
            if (country == null) continue;
            return country;
        }
        return null;
    }

    public void setAcronym(String acronym) {
        super.setAcronym(acronym);
        UnitAcronym unitAcronym = UnitAcronym.readUnitAcronymByAcronym(acronym);
        if (unitAcronym == null) {
            unitAcronym = new UnitAcronym(acronym);
        }
        this.setUnitAcronym(unitAcronym);
    }

    public Boolean hasParentUnit(Unit parentUnit) {
        for (Unit parent : this.getParentUnits()) {
            if (!parent.equals((Object)parentUnit)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Unit getParentUnit(String unitNormalizedName, Class<? extends Unit> clazz) {
        if (StringUtils.isEmpty((String)unitNormalizedName)) {
            return null;
        }
        for (UnitName unitName : UnitName.find(unitNormalizedName, Integer.MAX_VALUE)) {
            Unit unit = unitName.getUnit();
            if (!((Object)((Object)unit)).getClass().equals(clazz)) continue;
            return unit;
        }
        return null;
    }

    public static Unit getParentUnitByNormalizedName(Unit childUnit, String parentNormalizedName) {
        for (Unit possibleParent : childUnit.getParentUnits()) {
            if (!parentNormalizedName.equalsIgnoreCase(StringNormalizer.normalize((String)possibleParent.getName()))) continue;
            return possibleParent;
        }
        return null;
    }

    public void deleteParentUnitRelation(Unit parentUnit) {
        for (Accountability relation : this.getParentsSet()) {
            if (!relation.getParentParty().equals((Object)parentUnit)) continue;
            relation.delete();
            return;
        }
    }

    public Boolean isOfficial() {
        return Boolean.FALSE;
    }

    @Deprecated
    public Date getBeginDate() {
        YearMonthDay ymd = this.getBeginDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setBeginDate(Date date) {
        if (date == null) {
            this.setBeginDateYearMonthDay(null);
        } else {
            this.setBeginDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEndDate() {
        YearMonthDay ymd = this.getEndDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEndDate(Date date) {
        if (date == null) {
            this.setEndDateYearMonthDay(null);
        } else {
            this.setEndDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    public boolean isAdministrativeOfficeUnit() {
        return this.getAdministrativeOffice() != null;
    }
}

