/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AggregateUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class AggregateUnit
extends AggregateUnit_Base {
    private AggregateUnit() {
        super.setType(PartyTypeEnum.AGGREGATE_UNIT);
    }

    public static AggregateUnit createNewAggregateUnit(MultiLanguageString name, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        AggregateUnit aggregateUnit = new AggregateUnit();
        aggregateUnit.init(name, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        aggregateUnit.addParentUnit(parentUnit, accountabilityType);
        return aggregateUnit;
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public boolean isAggregateUnit() {
        return true;
    }

    public Collection<PartyType> getAllowedChildPartyTypes(Boolean managedByUser) {
        HashSet<PartyType> result = new HashSet<PartyType>();
        for (Unit iter : this.getParentUnits()) {
            result.addAll(iter.getAllowedChildPartyTypes(managedByUser));
        }
        return result;
    }
}

