/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import org.fenixedu.academic.domain.degreeStructure.CycleType;

public class CycleTypes {
    private final ImmutableSet<CycleType> types;

    public CycleTypes(JsonElement json) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonElement el : json.getAsJsonArray()) {
            builder.add((Object)CycleType.valueOf(el.getAsString()));
        }
        this.types = builder.build();
    }

    public CycleTypes(Collection<CycleType> types) {
        this.types = ImmutableSet.copyOf(types);
    }

    public CycleTypes() {
        this.types = ImmutableSet.of();
    }

    public Collection<CycleType> getTypes() {
        return this.types;
    }

    public JsonElement toJson() {
        JsonArray array = new JsonArray();
        this.types.stream().map(Enum::name).map(JsonPrimitive::new).forEach(type -> array.add((JsonElement)type));
        return array;
    }
}

