/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultMessage;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultType;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class RuleResult {
    private RuleResultType result;
    private Set<RuleResultMessage> messages;
    private Map<DegreeModule, EnrolmentResultType> enrolmentResultTypeByDegreeModule = new HashMap<DegreeModule, EnrolmentResultType>();

    private RuleResult() {
        this.messages = new HashSet<RuleResultMessage>();
    }

    private RuleResult(RuleResultType resultType, Map<DegreeModule, EnrolmentResultType> enrolmentResultTypeByDegreeModule, Set<RuleResultMessage> messages) {
        this();
        this.result = resultType;
        this.enrolmentResultTypeByDegreeModule = enrolmentResultTypeByDegreeModule;
        this.messages = messages;
    }

    private RuleResult(RuleResultType result, EnrolmentResultType enrolmentResultType, DegreeModule degreeModule) {
        this();
        if (result == null) {
            throw new DomainException("error.curricularRules.executors.RuleResult.result.cannot.be.null", new String[0]);
        }
        if (enrolmentResultType == null) {
            throw new DomainException("error.curricularRules.ruleExecutors.RuleResult.enrolmentResultType.cannot.be.null", new String[0]);
        }
        if (degreeModule == null) {
            throw new DomainException("error.curricularRules.executors.RuleResult.degreeModule.cannot.be.null", new String[0]);
        }
        this.result = result;
        this.enrolmentResultTypeByDegreeModule.put(degreeModule, enrolmentResultType);
    }

    private RuleResult(RuleResultType result, EnrolmentResultType enrolmentResultType, DegreeModule degreeModule, Set<RuleResultMessage> messages) {
        this(result, enrolmentResultType, degreeModule);
        this.messages.addAll(messages);
    }

    public RuleResultType getResult() {
        return this.result;
    }

    public Set<RuleResultMessage> getMessages() {
        return this.messages;
    }

    public RuleResult and(RuleResult ruleResult) {
        RuleResultType andResult = this.getResult().and(ruleResult.getResult());
        HashSet<RuleResultMessage> messages = new HashSet<RuleResultMessage>(this.getMessages());
        messages.addAll(ruleResult.getMessages());
        return new RuleResult(andResult, this.andMerge(this.enrolmentResultTypeByDegreeModule, ruleResult.enrolmentResultTypeByDegreeModule), messages);
    }

    private Map<DegreeModule, EnrolmentResultType> andMerge(Map<DegreeModule, EnrolmentResultType> left, Map<DegreeModule, EnrolmentResultType> right) {
        for (Map.Entry<DegreeModule, EnrolmentResultType> each : right.entrySet()) {
            if (left.containsKey((Object)each.getKey())) {
                left.put(each.getKey(), left.get((Object)each.getKey()).and(each.getValue()));
                continue;
            }
            left.put(each.getKey(), each.getValue());
        }
        return left;
    }

    public RuleResult or(RuleResult ruleResult) {
        RuleResultType orResult = this.getResult().or(ruleResult.getResult());
        HashSet<RuleResultMessage> messages = new HashSet<RuleResultMessage>(this.getMessages());
        messages.addAll(ruleResult.getMessages());
        return new RuleResult(orResult, this.orMerge(this.enrolmentResultTypeByDegreeModule, ruleResult.enrolmentResultTypeByDegreeModule), messages);
    }

    private Map<DegreeModule, EnrolmentResultType> orMerge(Map<DegreeModule, EnrolmentResultType> left, Map<DegreeModule, EnrolmentResultType> right) {
        for (Map.Entry<DegreeModule, EnrolmentResultType> each : right.entrySet()) {
            if (left.containsKey((Object)each.getKey())) {
                left.put(each.getKey(), left.get((Object)each.getKey()).or(each.getValue()));
                continue;
            }
            left.put(each.getKey(), each.getValue());
        }
        return left;
    }

    public boolean isTrue() {
        return this.getResult() == RuleResultType.TRUE;
    }

    public boolean isFalse() {
        return this.getResult() == RuleResultType.FALSE;
    }

    public boolean isNA() {
        return this.getResult() == RuleResultType.NA;
    }

    public boolean isWarning() {
        return this.getResult() == RuleResultType.WARNING;
    }

    public EnrolmentResultType getEnrolmentResultTypeFor(DegreeModule degreeModule) {
        return this.enrolmentResultTypeByDegreeModule.containsKey((Object)degreeModule) ? this.enrolmentResultTypeByDegreeModule.get((Object)degreeModule) : EnrolmentResultType.VALIDATED;
    }

    public boolean isTemporaryEnrolmentResultType(DegreeModule degreeModule) {
        return this.getEnrolmentResultTypeFor(degreeModule) == EnrolmentResultType.TEMPORARY;
    }

    public boolean isImpossibleEnrolmentResultType(DegreeModule degreeModule) {
        return this.getEnrolmentResultTypeFor(degreeModule) == EnrolmentResultType.IMPOSSIBLE;
    }

    public boolean isValidated(DegreeModule degreeModule) {
        return this.getEnrolmentResultTypeFor(degreeModule) == EnrolmentResultType.VALIDATED;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RuleResult) {
            return this.result == ((RuleResult)obj).getResult();
        }
        return false;
    }

    public boolean hasAnyImpossibleEnrolment() {
        return this.enrolmentResultTypeByDegreeModule.values().contains((Object)EnrolmentResultType.IMPOSSIBLE);
    }

    public static RuleResult createInitialTrue() {
        return new RuleResult(RuleResultType.TRUE, new HashMap<DegreeModule, EnrolmentResultType>(), Collections.EMPTY_SET);
    }

    public static RuleResult createTrue(DegreeModule degreeModule) {
        return new RuleResult(RuleResultType.TRUE, EnrolmentResultType.VALIDATED, degreeModule);
    }

    public static RuleResult createTrue(EnrolmentResultType enrolmentResultType, DegreeModule degreeModule) {
        return new RuleResult(RuleResultType.TRUE, enrolmentResultType, degreeModule);
    }

    public static RuleResult createImpossible(DegreeModule degreeModule, String message, String ... args) {
        return RuleResult.createTrue(EnrolmentResultType.IMPOSSIBLE, degreeModule, message, args);
    }

    public static RuleResult createImpossibleWithLiteralMessage(DegreeModule degreeModule, String message) {
        return new RuleResult(RuleResultType.TRUE, EnrolmentResultType.IMPOSSIBLE, degreeModule, Collections.singleton(new RuleResultMessage(message, false, new String[0])));
    }

    public static RuleResult createTrue(EnrolmentResultType enrolmentResultType, DegreeModule degreeModule, String message, String ... args) {
        return new RuleResult(RuleResultType.TRUE, enrolmentResultType, degreeModule, Collections.singleton(new RuleResultMessage(message, true, args)));
    }

    public static RuleResult createFalse(DegreeModule degreeModuleToEvaluate) {
        return RuleResult.createFalse(EnrolmentResultType.VALIDATED, degreeModuleToEvaluate);
    }

    public static RuleResult createInitialFalse() {
        return new RuleResult(RuleResultType.FALSE, new HashMap<DegreeModule, EnrolmentResultType>(), Collections.EMPTY_SET);
    }

    public static RuleResult createFalse(EnrolmentResultType enrolmentResultType, DegreeModule degreeModule) {
        return new RuleResult(RuleResultType.FALSE, enrolmentResultType, degreeModule);
    }

    public static RuleResult createFalse(DegreeModule degreeModule, String message, String ... args) {
        return RuleResult.createFalse(EnrolmentResultType.VALIDATED, degreeModule, message, args);
    }

    public static RuleResult createFalse(EnrolmentResultType enrolmentResultType, DegreeModule degreeModule, String message, String ... args) {
        return new RuleResult(RuleResultType.FALSE, enrolmentResultType, degreeModule, Collections.singleton(new RuleResultMessage(message, args)));
    }

    public static RuleResult createFalseWithLiteralMessage(DegreeModule degreeModule, String message) {
        return new RuleResult(RuleResultType.FALSE, EnrolmentResultType.VALIDATED, degreeModule, Collections.singleton(new RuleResultMessage(message, false, new String[0])));
    }

    public static RuleResult createNA(DegreeModule degreeModule) {
        return new RuleResult(RuleResultType.NA, EnrolmentResultType.NULL, degreeModule);
    }

    public static RuleResult createWarning(DegreeModule degreeModule, Set<RuleResultMessage> ruleResultMessages) {
        return new RuleResult(RuleResultType.WARNING, EnrolmentResultType.VALIDATED, degreeModule, ruleResultMessages);
    }

    public static RuleResult createWarning(DegreeModule degreeModule, String message, String ... args) {
        return RuleResult.createWarning(degreeModule, Collections.singleton(new RuleResultMessage(message, args)));
    }
}

