/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentPlan_Base;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRuleManager;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public abstract class PaymentPlan
extends PaymentPlan_Base {
    protected PaymentPlan() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenCreated(new DateTime());
    }

    protected void init(ExecutionYear executionYear, Boolean defaultPlan) {
        this.checkParameters(executionYear, defaultPlan);
        super.setDefaultPlan(defaultPlan);
        super.setExecutionYear(executionYear);
    }

    private void checkParameters(ExecutionYear executionYear, Boolean defaultPlan) {
        if (executionYear == null) {
            throw new DomainException("error.accounting.PaymentPlan.executionYear.cannot.be.null", new String[0]);
        }
        if (defaultPlan == null) {
            throw new DomainException("error.accounting.PaymentPlan.defaultPlan.cannot.be.null", new String[0]);
        }
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        throw new DomainException("error.accounting.PaymentCondition.cannot.modify.executionYear", new String[0]);
    }

    public void setDefaultPlan(Boolean defaultPlan) {
        throw new DomainException("error.domain.accounting.PaymentPlan.cannot.modify.defaultPlan", new String[0]);
    }

    public List<Installment> getInstallmentsSortedByEndDate() {
        ArrayList<Installment> result = new ArrayList<Installment>(this.getInstallmentsSet());
        Collections.sort(result, Installment.COMPARATOR_BY_END_DATE);
        return result;
    }

    public Installment getLastInstallment() {
        return this.getInstallmentsSet().size() == 0 ? null : Collections.max(this.getInstallmentsSet(), Installment.COMPARATOR_BY_ORDER);
    }

    public Installment getFirstInstallment() {
        return this.getInstallmentsSet().size() == 0 ? null : Collections.min(this.getInstallmentsSet(), Installment.COMPARATOR_BY_ORDER);
    }

    public int getLastInstallmentOrder() {
        Installment installment = this.getLastInstallment();
        return installment == null ? 0 : installment.getOrder();
    }

    public void addInstallments(Installment installment) {
        throw new DomainException("error.accounting.PaymentPlan.cannot.add.installment", new String[0]);
    }

    public Set<Installment> getInstallmentsSet() {
        return Collections.unmodifiableSet(super.getInstallmentsSet());
    }

    public void removeInstallments(Installment installment) {
        throw new DomainException("error.accounting.PaymentPlan.cannot.remove.installment", new String[0]);
    }

    public boolean isDefault() {
        return this.getDefaultPlan();
    }

    public Money calculateOriginalTotalAmount() {
        Money result = Money.ZERO;
        for (Installment installment : this.getInstallmentsSet()) {
            result = result.add(installment.getAmount());
        }
        return result;
    }

    public Money calculateBaseAmount(Event event) {
        Money result = Money.ZERO;
        for (Installment installment : this.getInstallmentsSet()) {
            result = result.add(installment.calculateBaseAmount(event));
        }
        return result;
    }

    public Money calculateTotalAmount(Event event, DateTime when, BigDecimal discountPercentage) {
        Money result = Money.ZERO;
        for (Money amount : this.calculateInstallmentTotalAmounts(event, when, discountPercentage).values()) {
            result = result.add(amount);
        }
        return result;
    }

    private Map<Installment, Money> calculateInstallmentTotalAmounts(Event event, DateTime when, BigDecimal discountPercentage) {
        HashMap<Installment, Money> result = new HashMap<Installment, Money>();
        CashFlowBox cashFlowBox = new CashFlowBox(event, when, discountPercentage);
        for (Installment installment : this.getInstallmentsSortedByEndDate()) {
            result.put(installment, cashFlowBox.calculateTotalAmountFor(installment));
        }
        return result;
    }

    public Map<Installment, Money> calculateInstallmentRemainingAmounts(Event event, DateTime when, BigDecimal discountPercentage) {
        HashMap<Installment, Money> result = new HashMap<Installment, Money>();
        CashFlowBox cashFlowBox = new CashFlowBox(event, when, discountPercentage);
        for (Installment installment : this.getInstallmentsSortedByEndDate()) {
            if (cashFlowBox.subtractMoneyFor(installment)) continue;
            result.put(installment, cashFlowBox.subtractRemainingFor(installment));
        }
        return result;
    }

    public Money calculateRemainingAmountFor(Installment installment, Event event, DateTime when, BigDecimal discountPercentage) {
        Map<Installment, Money> amountsByInstallment = this.calculateInstallmentRemainingAmounts(event, when, discountPercentage);
        Money installmentAmount = amountsByInstallment.get((Object)installment);
        return installmentAmount != null ? installmentAmount : Money.ZERO;
    }

    public boolean isInstallmentInDebt(Installment installment, Event event, DateTime when, BigDecimal discountPercentage) {
        return this.calculateRemainingAmountFor(installment, event, when, discountPercentage).isPositive();
    }

    public Installment getInstallmentByOrder(int order) {
        for (Installment installment : this.getInstallmentsSet()) {
            if (installment.getInstallmentOrder() != order) continue;
            return installment;
        }
        return null;
    }

    public boolean isToApplyPenalty(Event event, Installment installment) {
        return true;
    }

    protected void removeParameters() {
        super.setExecutionYear(null);
    }

    public boolean isGratuityPaymentPlan() {
        return false;
    }

    public boolean isCustomGratuityPaymentPlan() {
        return false;
    }

    private boolean hasExecutionYear(ExecutionYear executionYear) {
        return this.getExecutionYear() != null && this.getExecutionYear().equals(executionYear);
    }

    public final boolean isAppliableFor(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        if (!this.hasExecutionYear(executionYear)) {
            return false;
        }
        Collection<PaymentPlanRule> specificRules = this.getSpecificPaymentPlanRules();
        if (specificRules.isEmpty()) {
            return false;
        }
        for (PaymentPlanRule rule : specificRules) {
            if (rule.isAppliableFor(studentCurricularPlan, executionYear)) continue;
            return false;
        }
        for (PaymentPlanRule rule : this.getNotSpecificPaymentRules()) {
            if (!rule.isEvaluatedInNotSpecificPaymentRules() || !rule.isAppliableFor(studentCurricularPlan, executionYear)) continue;
            return false;
        }
        return true;
    }

    protected Collection<PaymentPlanRule> getNotSpecificPaymentRules() {
        return CollectionUtils.subtract(PaymentPlanRuleManager.getAllPaymentPlanRules(), this.getSpecificPaymentPlanRules());
    }

    protected abstract Collection<PaymentPlanRule> getSpecificPaymentPlanRules();

    public String getDescription() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)(((Object)((Object)this)).getClass().getSimpleName() + ".description"), (String[])new String[0]);
    }

    public boolean isFor(ExecutionYear executionYear) {
        return this.getExecutionYear() != null && this.getExecutionYear().equals(executionYear);
    }

    public abstract ServiceAgreementTemplate getServiceAgreementTemplate();

    public void delete() {
        if (!this.getGratuityEventsWithPaymentPlanSet().isEmpty()) {
            throw new DomainException("error.accounting.PaymentPlan.cannot.delete.with.already.associated.gratuity.events", new String[0]);
        }
        while (!this.getInstallmentsSet().isEmpty()) {
            this.getInstallmentsSet().iterator().next().delete();
        }
        this.removeParameters();
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isForPartialRegime() {
        return false;
    }

    public boolean isForFirstTimeInstitutionStudents() {
        return false;
    }

    public boolean hasSingleInstallment() {
        return this.getInstallmentsSet().size() == 1;
    }

    private class CashFlowBox {
        public DateTime when;
        public Money amount;
        public DateTime currentTransactionDate;
        public List<AccountingTransaction> transactions;
        public BigDecimal discountPercentage;
        public Event event;
        public Money discountValue;
        public boolean usedDiscountValue;
        private Money discountedValue;

        public CashFlowBox(Event event, DateTime when, BigDecimal discountPercentage) {
            this.event = event;
            this.transactions = new ArrayList<AccountingTransaction>(event.getSortedNonAdjustingTransactions());
            this.when = when;
            this.discountPercentage = discountPercentage;
            this.discountValue = event.getTotalDiscount();
            this.discountedValue = Money.ZERO;
            this.usedDiscountValue = false;
            if (this.transactions.isEmpty()) {
                this.amount = Money.ZERO;
                this.currentTransactionDate = when;
            } else {
                AccountingTransaction transaction = this.transactions.remove(0);
                this.amount = transaction.getAmountWithAdjustment();
                this.currentTransactionDate = transaction.getWhenRegistered();
            }
        }

        private boolean hasMoneyFor(Money amount) {
            return this.amount.greaterOrEqualThan(amount);
        }

        private boolean hasDiscountValue() {
            return this.discountValue.isPositive();
        }

        public boolean subtractMoneyFor(Installment installment) {
            if (this.hasDiscountValue() && this.discountValue.greaterOrEqualThan(installment.getAmount())) {
                this.usedDiscountValue = true;
                this.discountValue = this.discountValue.subtract(installment.getAmount());
                return true;
            }
            Money installmentAmount = installment.calculateAmount(this.event, this.currentTransactionDate, this.discountPercentage, PaymentPlan.this.isToApplyPenalty(this.event, installment));
            if (this.hasDiscountValue()) {
                installmentAmount = installmentAmount.subtract(this.discountValue);
                this.discountedValue = this.discountValue;
            }
            if (this.hasMoneyFor(installmentAmount)) {
                this.amount = this.amount.subtract(installmentAmount);
                this.discountValue = Money.ZERO;
                return true;
            }
            if (this.transactions.isEmpty()) {
                return false;
            }
            AccountingTransaction transaction = this.transactions.remove(0);
            this.amount = this.amount.add(transaction.getAmountWithAdjustment());
            this.currentTransactionDate = transaction.getWhenRegistered();
            return this.subtractMoneyFor(installment);
        }

        public Money subtractRemainingFor(Installment installment) {
            Money result = installment.calculateAmount(this.event, this.when, this.discountPercentage, PaymentPlan.this.isToApplyPenalty(this.event, installment)).subtract(this.discountValue).subtract(this.amount);
            this.amount = this.discountValue = Money.ZERO;
            return result;
        }

        public Money calculateTotalAmountFor(Installment installment) {
            Money result;
            if (this.subtractMoneyFor(installment)) {
                if (this.usedDiscountValue) {
                    result = Money.ZERO;
                } else {
                    result = installment.calculateAmount(this.event, this.currentTransactionDate, this.discountPercentage, PaymentPlan.this.isToApplyPenalty(this.event, installment)).subtract(this.discountedValue);
                    this.discountedValue = Money.ZERO;
                }
            } else {
                result = installment.calculateAmount(this.event, this.when, this.discountPercentage, PaymentPlan.this.isToApplyPenalty(this.event, installment)).subtract(this.discountedValue);
                this.discountedValue = Money.ZERO;
            }
            this.usedDiscountValue = false;
            return result;
        }
    }
}

