/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import org.fenixedu.academic.util.FenixUtil;
import org.fenixedu.academic.util.LabelFormatter;

public class Season
extends FenixUtil {
    public static final int SEASON1 = 1;
    public static final int SEASON2 = 2;
    public static final int SPECIAL_SEASON = 3;
    private static String[] SEASON_KEYS = new String[]{"label.firstSeason", "label.secondSeason", "label.specialSeason"};
    public static final String SEASON1_STRING = "1\u00aa \u00c9poca";
    public static final String SEASON2_STRING = "2\u00aa \u00c9poca";
    public static final String SPECIAL_SEASON_STRING = "\u00c9poca Especial";
    public static final String DEFAULT = "[Escolha a Epoca]";
    public static final Season SEASON1_OBJ = new Season(1);
    public static final Season SEASON2_OBJ = new Season(2);
    public static final Season SPECIAL_SEASON_OBJ = new Season(3);
    private final Integer season;

    public Season(int season) {
        this.season = new Integer(season);
    }

    public Season(Integer season) {
        this.season = season;
    }

    public Season(String season) {
        if (season.equals(SEASON1_STRING)) {
            this.season = 1;
        } else if (season.equals(SEASON2_STRING)) {
            this.season = 2;
        } else if (season.equals(SPECIAL_SEASON_STRING)) {
            this.season = 3;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Season) {
            Season aux = (Season)o;
            return this.season.equals(aux.getseason());
        }
        return false;
    }

    public String toString() {
        if (this.season == 1) {
            return SEASON1_STRING;
        }
        if (this.season == 2) {
            return SEASON2_STRING;
        }
        if (this.season == 3) {
            return SPECIAL_SEASON_STRING;
        }
        return "ERROR";
    }

    public Integer getseason() {
        return this.season;
    }

    public Integer getSeason() {
        return this.season;
    }

    public String getKey() {
        return SEASON_KEYS[this.season - 1];
    }

    public LabelFormatter getDescription() {
        return new LabelFormatter().appendLabel(SEASON_KEYS[this.season - 1], "resources.ApplicationResources");
    }
}

