/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher.candidacy.erasmus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.candidacy.erasmus.ErasmusCandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.teacher.TeacherApplication;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=TeacherApplication.TeacherMobilityApp.class, path="mobility-process", titleKey="label.applications")
@Mapping(path="/caseHandlingMobilityApplicationProcess", module="teacher", formBeanClass=ErasmusCandidacyProcessDA.ErasmusCandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/erasmus/mainCandidacyProcess.jsp")})
public class ErasmusCandidacyProcessDA
extends org.fenixedu.academic.ui.struts.action.candidacy.erasmus.ErasmusCandidacyProcessDA {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!AccessControl.getPerson().getTeacher().isErasmusCoordinator()) {
            response.sendError(403);
            return null;
        }
        this.setChooseDegreeBean(request);
        ActionForward forward = super.execute(mapping, actionForm, request, response);
        this.setChooseDegreeBean(request);
        request.setAttribute("chooseDegreeBeanSchemaName", (Object)"ErasmusChooseDegreeBean.coordinator.selectDegree");
        return forward;
    }

    protected List<IndividualCandidacyProcess> getChildProcesses(final CandidacyProcess process2, HttpServletRequest request) {
        Collection<IndividualCandidacyProcess> processes = super.getChildProcesses(process2, request);
        ArrayList<IndividualCandidacyProcess> result = new ArrayList<IndividualCandidacyProcess>();
        CollectionUtils.select(processes, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                IndividualCandidacyProcess child = (IndividualCandidacyProcess)((Object)arg0);
                return ((MobilityApplicationProcess)((Object)process2)).getDegreesAssociatedToTeacherAsCoordinator(ErasmusCandidacyProcessDA.this.getTeacher()).contains(((MobilityIndividualApplicationProcess)((Object)child)).getCandidacy().getSelectedDegree());
            }
        }, result);
        return result;
    }

    private Teacher getTeacher() {
        return AccessControl.getPerson().getTeacher();
    }

    public DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        String degreeCurricularPlanOID = DegreeCoordinatorIndex.findDegreeCurricularPlanID(request);
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanOID);
        if (degreeCurricularPlanOID != null) {
            return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanOID);
        }
        return null;
    }

    @Override
    public ActionForward prepareCreateNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        throw new DomainException("error.permission.denied", new String[0]);
    }

    public static class ErasmusCandidacyDegreesProvider
    implements DataProvider {
        public Object provide(Object source, Object currentValue) {
            CandidacyProcessDA.ChooseDegreeBean bean = (CandidacyProcessDA.ChooseDegreeBean)source;
            Teacher teacher = Authenticate.getUser().getPerson().getTeacher();
            return ((MobilityApplicationProcess)((Object)bean.getCandidacyProcess())).getDegreesAssociatedToTeacherAsCoordinator(teacher);
        }

        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }
    }
}

