/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.coordinator.CoordinatorApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=CoordinatorApplication.CoordinatorManagementApp.class, path="choose-degree", titleKey="label.degrees")
@Mapping(path="/index", module="coordinator")
@Forwards(value={@Forward(name="ChooseDegree", path="/coordinator/chooseDegreePage.jsp")})
public class CoordinatorDegreeManagement
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("degrees", CoordinatorDegreeManagement.readCoordinatedDegrees());
        return mapping.findForward("ChooseDegree");
    }

    public static Set<DegreeCurricularPlan> readCoordinatedDegrees() throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan;
        ExecutionDegree executionDegree;
        Person person = AccessControl.getPerson();
        TreeSet<DegreeCurricularPlan> activeDegreeCurricularPlans = new TreeSet<DegreeCurricularPlan>(DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        for (Coordinator coordinator : person.getCoordinatorsSet()) {
            executionDegree = coordinator.getExecutionDegree();
            degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            if (degreeCurricularPlan.getState() != DegreeCurricularPlanState.ACTIVE) continue;
            activeDegreeCurricularPlans.add(degreeCurricularPlan);
        }
        for (ScientificCommission commission : person.getScientificCommissionsSet()) {
            executionDegree = commission.getExecutionDegree();
            degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            if (degreeCurricularPlan.getState() != DegreeCurricularPlanState.ACTIVE) continue;
            activeDegreeCurricularPlans.add(degreeCurricularPlan);
        }
        return activeDegreeCurricularPlans;
    }
}

