/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.academicAdministration.DegreeJurisdictionManagementDispacthAction$callable$changeDegreeJurisdiction;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.class, path="degree-jurisdiction", titleKey="label.degreeJurisdiction.title", accessGroup="academic(MANAGE_AUTHORIZATIONS)")
@Mapping(path="/degreeJurisdiction", module="academicAdministration")
@Forwards(value={@Forward(name="manageJurisdictions", path="/academicAdministration/degreeJurisdictions/manageJurisdictions.jsp")})
public class DegreeJurisdictionManagementDispacthAction
extends FenixDispatchAction {
    public static final Advice advice$changeDegreeJurisdiction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward manageJurisdictions(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        JsonObject json;
        JsonArray programs = new JsonArray();
        for (Degree degree : Bennu.getInstance().getDegreesSet()) {
            json = new JsonObject();
            json.addProperty("id", degree.getExternalId());
            json.addProperty("name", degree.getPresentationName());
            json.addProperty("acronym", degree.getSigla());
            json.addProperty("office", degree.getAdministrativeOffice().getExternalId());
            programs.add((JsonElement)json);
        }
        for (PhdProgram program : Bennu.getInstance().getPhdProgramsSet()) {
            json = new JsonObject();
            json.addProperty("id", program.getExternalId());
            json.addProperty("name", program.getPresentationName());
            json.addProperty("acronym", program.getAcronym());
            json.addProperty("office", program.getAdministrativeOffice().getExternalId());
            programs.add((JsonElement)json);
        }
        request.setAttribute("programs", (Object)programs);
        JsonArray offices = new JsonArray();
        int i = 0;
        for (AdministrativeOffice office : Bennu.getInstance().getAdministrativeOfficesSet()) {
            JsonObject json2 = new JsonObject();
            json2.addProperty("id", office.getExternalId());
            json2.addProperty("name", office.getName().getContent());
            json2.addProperty("acronym", this.acronym(office.getUnit().getName()));
            json2.addProperty("idx", (Number)i++);
            offices.add((JsonElement)json2);
        }
        request.setAttribute("offices", (Object)offices);
        return mapping.findForward("manageJurisdictions");
    }

    private String acronym(String name) {
        StringBuilder builder = new StringBuilder();
        for (char c : StringNormalizer.normalizeAndRemoveAccents((String)name).toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public ActionForward changeDegreeJurisdiction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JsonObject json = new JsonParser().parse((Reader)request.getReader()).getAsJsonObject();
        String programOid = json.get("program").getAsString();
        String officeOid = json.get("office").getAsString();
        this.changeDegreeJurisdiction(programOid, officeOid);
        return null;
    }

    private void changeDegreeJurisdiction(String string, String string2) {
        Object object = advice$changeDegreeJurisdiction.perform((Callable)new DegreeJurisdictionManagementDispacthAction$callable$changeDegreeJurisdiction(this, string, string2));
    }

    static /* synthetic */ void advised$changeDegreeJurisdiction(DegreeJurisdictionManagementDispacthAction this_, String programOid, String officeOid) {
        Degree degree;
        AcademicProgram program = (AcademicProgram)FenixFramework.getDomainObject((String)programOid);
        AdministrativeOffice office = (AdministrativeOffice)FenixFramework.getDomainObject((String)officeOid);
        program.setAdministrativeOffice(office);
        if (program instanceof Degree && (degree = (Degree)((Object)program)).getPhdProgram() != null) {
            degree.getPhdProgram().setAdministrativeOffice(office);
        }
    }
}

