/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.student.curriculum;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlForm;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class StudentCurricularPlanRenderer
extends InputRenderer {
    private static final String SCPLANTEMPORARYDISMISSAL = "scplantemporarydismissal";
    private static final String SCPLANDISMISSAL = "scplandismissal";
    private static final String SCPLANENROLLMENT = "scplanenrollment";
    private static final String SCPLANGROUP = "scplangroup";
    private static final String SCPLAN = "scplan";
    private static final String CELL_CLASSES = "scplancolident, scplancolcurricularcourse, scplancoldegreecurricularplan, scplancolenrollmentstate, scplancolenrollmenttype, scplancolgrade, scplancolweight, scplancolects, scplancolenrolmentevaluationtype, scplancolyear, scplancolsemester, scplancolexamdate, scplancolgraderesponsible, scplancolstatistics";
    private OrganizationType organizedBy = OrganizationType.GROUPS;
    private EnrolmentStateFilterType enrolmentStateFilter = EnrolmentStateFilterType.ALL;
    private boolean detailed = true;
    private ViewType viewType = ViewType.ALL;
    private String studentCurricularPlanClass = "scplan";
    private String curriculumGroupRowClass = "scplangroup";
    private String enrolmentRowClass = "scplanenrollment";
    private String dismissalRowClass = "scplandismissal";
    private String temporaryDismissalRowClass = "scplantemporarydismissal";
    private String cellClasses = "scplancolident, scplancolcurricularcourse, scplancoldegreecurricularplan, scplancolenrollmentstate, scplancolenrollmenttype, scplancolgrade, scplancolweight, scplancolects, scplancolenrolmentevaluationtype, scplancolyear, scplancolsemester, scplancolexamdate, scplancolgraderesponsible, scplancolstatistics";
    private boolean selectable;
    private String selectionName;

    public void setOrganizedBy(String organizedBy) {
        this.organizedBy = OrganizationType.valueOf(organizedBy);
    }

    public void setOrganizedByEnum(OrganizationType organizationType) {
        this.organizedBy = organizationType;
    }

    public boolean isOrganizedByGroups() {
        return this.organizedBy == OrganizationType.GROUPS;
    }

    public boolean isOrganizedByExecutionYears() {
        return this.organizedBy == OrganizationType.EXECUTION_YEARS;
    }

    public void setEnrolmentStateFilter(String type) {
        this.enrolmentStateFilter = EnrolmentStateFilterType.valueOf(type);
    }

    public void setEnrolmentStateFilterEnum(EnrolmentStateFilterType enrolmentStateFilter) {
        this.enrolmentStateFilter = enrolmentStateFilter;
    }

    private boolean isToShowAllEnrolmentStates() {
        return this.enrolmentStateFilter == EnrolmentStateFilterType.ALL;
    }

    private boolean isToShowApprovedOnly() {
        return this.enrolmentStateFilter == EnrolmentStateFilterType.APPROVED;
    }

    private boolean isToShowApprovedOrEnroledStatesOnly() {
        return this.enrolmentStateFilter == EnrolmentStateFilterType.APPROVED_OR_ENROLED;
    }

    public void setViewType(String type) {
        this.viewType = ViewType.valueOf(type);
    }

    public void setViewTypeEnum(ViewType viewType) {
        this.viewType = viewType;
    }

    private boolean isToShowDismissals() {
        return this.viewType == ViewType.DISMISSALS || this.viewType == ViewType.ALL;
    }

    private boolean isToShowEnrolments() {
        return this.viewType == ViewType.ENROLMENTS || this.viewType == ViewType.ALL;
    }

    private String getStudentCurricularPlanClass() {
        return this.studentCurricularPlanClass;
    }

    public void setStudentCurricularPlanClass(String studentCurricularPlanClass) {
        this.studentCurricularPlanClass = studentCurricularPlanClass;
    }

    private String getCurriculumGroupRowClass() {
        return this.curriculumGroupRowClass;
    }

    public void setCurriculumGroupRowClass(String curriculumGroupRowClass) {
        this.curriculumGroupRowClass = curriculumGroupRowClass;
    }

    private String getEnrolmentRowClass() {
        return this.enrolmentRowClass;
    }

    public void setEnrolmentRowClass(String enrolmentRowClass) {
        this.enrolmentRowClass = enrolmentRowClass;
    }

    private String getDismissalRowClass() {
        return this.dismissalRowClass;
    }

    public void setDismissalRowClass(String dismissalRowClass) {
        this.dismissalRowClass = dismissalRowClass;
    }

    private String getTemporaryDismissalRowClass() {
        return this.temporaryDismissalRowClass;
    }

    public void setTemporaryDismissalRowClass(String temporaryDismissalRowClass) {
        this.temporaryDismissalRowClass = temporaryDismissalRowClass;
    }

    public void setCellClasses(String cellClasses) {
        this.cellClasses = cellClasses;
    }

    private String[] getCellClasses() {
        return this.cellClasses.split(",");
    }

    private String getTabCellClass() {
        return this.getCellClasses()[0];
    }

    private String getLabelCellClass() {
        return this.getCellClasses()[1];
    }

    private String getDegreeCurricularPlanCellClass() {
        return this.getCellClasses()[2];
    }

    private String getEnrolmentStateCellClass() {
        return this.getCellClasses()[3];
    }

    private String getEnrolmentTypeCellClass() {
        return this.getCellClasses()[4];
    }

    private String getGradeCellClass() {
        return this.getCellClasses()[5];
    }

    private String getWeightCellClass() {
        return this.getCellClasses()[6];
    }

    private String getEctsCreditsCellClass() {
        return this.getCellClasses()[7];
    }

    private String getLastEnrolmentEvaluationTypeCellClass() {
        return this.getCellClasses()[8];
    }

    private String getEnrolmentExecutionYearCellClass() {
        return this.getCellClasses()[9];
    }

    private String getEnrolmentSemesterCellClass() {
        return this.getCellClasses()[10];
    }

    private String getCreationDateCellClass() {
        return this.getCellClasses()[11];
    }

    private String getCreatorCellClass() {
        return this.getCellClasses()[12];
    }

    private String getStatisticsLinkCellClass() {
        return this.getCellClasses()[13];
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getSelectionName() {
        return this.selectionName;
    }

    public void setSelectionName(String selectionName) {
        this.selectionName = selectionName;
    }

    protected Layout getLayout(Object object, Class type) {
        return new StudentCurricularPlanLayout();
    }

    private boolean canGenerate(CurriculumGroup curriculumGroup, StudentCurricularPlan studentCurricularPlan) {
        if (!curriculumGroup.isNoCourseGroupCurriculumGroup() || this.isViewerAllowedToViewFullStudentCurriculum(studentCurricularPlan)) {
            return true;
        }
        return ((NoCourseGroupCurriculumGroup)((Object)curriculumGroup)).isVisible();
    }

    private void addTabsToRow(HtmlTableRow row, int level) {
        for (int i = 0; i < level; ++i) {
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setUrl("/images/scp_spacer.gif");
            HtmlImage spacerImage = new HtmlImage();
            spacerImage.setSource(link.calculateUrl());
            HtmlTableCell tabCell = row.createCell();
            tabCell.setClasses(this.getTabCellClass());
            tabCell.setBody((HtmlComponent)spacerImage);
        }
    }

    private void generateHeadersForGradeWeightAndEctsCredits(HtmlTableRow groupRow) {
        this.generateCellWithText(groupRow, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade", (String[])new String[0]), this.getGradeCellClass());
        this.generateCellWithText(groupRow, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.weight", (String[])new String[0]), this.getWeightCellClass());
        this.generateCellWithText(groupRow, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.ects", (String[])new String[0]), this.getEctsCreditsCellClass());
    }

    private void generateCellWithText(HtmlTableRow row, String text, String cssClass) {
        this.generateCellWithText(row, text, cssClass, 1);
    }

    private void generateCellWithText(HtmlTableRow row, String text, String cssClass, Integer colSpan) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(cssClass);
        cell.setText(text);
        cell.setColspan(colSpan);
    }

    private void generateCellWithSpan(HtmlTableRow row, String text, String cssClass) {
        this.generateCellWithSpan(row, text, null, cssClass);
    }

    private void generateCellWithSpan(HtmlTableRow row, String text, String title, String cssClass) {
        this.generateCellWithSpan(row, text, title, cssClass, 1);
    }

    private void generateCellWithSpan(HtmlTableRow row, String text, String title, String cssClass, Integer colSpan) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(cssClass);
        cell.setColspan(colSpan);
        HtmlInlineContainer span = new HtmlInlineContainer();
        span.addChild((HtmlComponent)new HtmlText(text));
        span.setTitle(title);
        cell.setBody((HtmlComponent)span);
    }

    private boolean isViewerAllowedToViewFullStudentCurriculum(StudentCurricularPlan studentCurricularPlan) {
        Person person = AccessControl.getPerson();
        return RoleType.MANAGER.isMember(person.getUser()) || AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.VIEW_FULL_STUDENT_CURRICULUM, person.getUser()).collect(Collectors.toSet()).contains(studentCurricularPlan.getDegree());
    }

    private class StudentCurricularPlanLayout
    extends Layout {
        private static final String EMPTY_INFO = "-";
        private static final String SPACER_IMAGE_PATH = "/images/scp_spacer.gif";
        private static final int MAX_LINE_SIZE = 26;
        private static final int MAX_COL_SPAN_FOR_TEXT_ON_GROUPS_WITH_CHILDS = 17;
        private static final int MAX_COL_SPAN_FOR_TEXT_ON_CURRICULUM_LINES = 14;
        private static final int HEADERS_SIZE = 3;
        private static final int COLUMNS_BETWEEN_TEXT_AND_GRADE = 3;
        private static final int COLUMNS_BETWEEN_TEXT_AND_ECTS = 5;
        private static final int COLUMNS_FROM_ECTS_AND_ENROLMENT_EVALUATION_DATE = 4;
        private static final int COLUMNS_BETWEEN_TEXT_AND_ENROLMENT_EVALUATION_DATE = 9;
        private static final int LATEST_ENROLMENT_EVALUATION_COLUMNS = 3;
        private static final String DATE_FORMAT = "yyyy/MM/dd";
        private static final int ENROLLMENT_EVALUATION_TYPE_NEXT_COLUMN_SPAN = 3;
        private static final int GRADE_NEXT_COLUMN_SPAN = 3;
        private StudentCurricularPlan studentCurricularPlan;
        private ExecutionYear executionYearContext;
        private ExecutionSemester executionPeriodContext;

        private StudentCurricularPlanLayout() {
        }

        public HtmlComponent createComponent(Object object, Class type) {
            InputContext inputContext = StudentCurricularPlanRenderer.this.getInputContext();
            HtmlForm htmlForm = inputContext.getForm();
            htmlForm.getSubmitButton().setVisible(false);
            htmlForm.getCancelButton().setVisible(false);
            this.studentCurricularPlan = (StudentCurricularPlan)((Object)object);
            HtmlBlockContainer container = new HtmlBlockContainer();
            if (this.studentCurricularPlan == null) {
                container.addChild((HtmlComponent)this.createHtmlTextItalic(BundleUtil.getString((String)"resources.StudentResources", (String)"message.no.curricularplan", (String[])new String[0])));
                return container;
            }
            this.executionYearContext = this.initializeExecutionYear();
            this.executionPeriodContext = this.executionYearContext.getLastExecutionPeriod();
            HtmlTable mainTable = new HtmlTable();
            container.addChild((HtmlComponent)mainTable);
            mainTable.setClasses(StudentCurricularPlanRenderer.this.getStudentCurricularPlanClass());
            if (StudentCurricularPlanRenderer.this.isOrganizedByGroups()) {
                this.generateRowsForGroupsOrganization(mainTable, (CurriculumGroup)((Object)this.studentCurricularPlan.getRoot()), 0);
            } else if (StudentCurricularPlanRenderer.this.isOrganizedByExecutionYears()) {
                this.generateRowsForExecutionYearsOrganization(mainTable);
            } else {
                throw new RuntimeException("Unexpected organization type");
            }
            return container;
        }

        private ExecutionYear initializeExecutionYear() {
            if (!this.studentCurricularPlan.getRegistration().hasConcluded()) {
                return ExecutionYear.readCurrentExecutionYear();
            }
            ExecutionYear lastApprovementExecutionYear = this.studentCurricularPlan.getLastApprovementExecutionYear();
            if (lastApprovementExecutionYear != null) {
                return lastApprovementExecutionYear;
            }
            ExecutionYear lastSCPExecutionYear = this.studentCurricularPlan.getLastExecutionYear();
            if (lastSCPExecutionYear != null) {
                return lastSCPExecutionYear;
            }
            return ExecutionYear.readCurrentExecutionYear();
        }

        private void generateRowsForExecutionYearsOrganization(HtmlTable mainTable) {
            List<Dismissal> dismissals;
            if (StudentCurricularPlanRenderer.this.isToShowEnrolments()) {
                TreeSet<ExecutionSemester> enrolmentExecutionPeriods = new TreeSet<ExecutionSemester>(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
                enrolmentExecutionPeriods.addAll(this.studentCurricularPlan.getEnrolmentsExecutionPeriods());
                for (ExecutionSemester enrolmentsExecutionPeriod : enrolmentExecutionPeriods) {
                    this.generateGroupRowWithText(mainTable, enrolmentsExecutionPeriod.getYear() + ", " + enrolmentsExecutionPeriod.getName(), true, 0, null);
                    this.generateEnrolmentRows(mainTable, this.studentCurricularPlan.getEnrolmentsByExecutionPeriod(enrolmentsExecutionPeriod), 0);
                }
            }
            if (StudentCurricularPlanRenderer.this.isToShowDismissals() && !(dismissals = this.studentCurricularPlan.getDismissals()).isEmpty()) {
                this.generateGroupRowWithText(mainTable, BundleUtil.getString((String)"resources.StudentResources", (String)"label.dismissals", (String[])new String[0]), true, 0, null);
                this.generateDismissalRows(mainTable, dismissals, 0);
            }
        }

        private HtmlText createHtmlTextItalic(String message) {
            HtmlText htmlText = new HtmlText(message);
            htmlText.setClasses("italic");
            return htmlText;
        }

        private void generateRowsForGroupsOrganization(HtmlTable mainTable, CurriculumGroup curriculumGroup, int level) {
            this.generateGroupRowWithText(mainTable, curriculumGroup.getName().getContent(), curriculumGroup.hasCurriculumLines(), level, curriculumGroup);
            this.generateCurriculumLineRows(mainTable, curriculumGroup, level + 1);
            this.generateChildGroupRows(mainTable, curriculumGroup, level + 1);
        }

        private void generateGroupRowWithText(HtmlTable mainTable, String text, boolean addHeaders, int level, CurriculumGroup curriculumGroup) {
            HtmlTableRow groupRow = mainTable.createRow();
            groupRow.setClasses(StudentCurricularPlanRenderer.this.getCurriculumGroupRowClass());
            StudentCurricularPlanRenderer.this.addTabsToRow(groupRow, level);
            HtmlTableCell cell = groupRow.createCell();
            cell.setClasses(StudentCurricularPlanRenderer.this.getLabelCellClass());
            Object body = curriculumGroup != null && curriculumGroup.isRoot() ? this.createDegreeCurricularPlanNameLink(curriculumGroup.getDegreeCurricularPlanOfDegreeModule(), this.executionPeriodContext) : new HtmlText(this.createGroupName(text, curriculumGroup).toString(), false);
            cell.setBody(body);
            if (!addHeaders) {
                cell.setColspan(Integer.valueOf(26 - level));
            } else {
                cell.setColspan(Integer.valueOf(17 - level));
                StudentCurricularPlanRenderer.this.generateHeadersForGradeWeightAndEctsCredits(groupRow);
                HtmlTableCell cellAfterEcts = groupRow.createCell();
                cellAfterEcts.setColspan(Integer.valueOf(6));
            }
        }

        private StringBuilder createGroupName(String text, CurriculumGroup curriculumGroup) {
            StringBuilder groupName = new StringBuilder(text);
            if (curriculumGroup != null && curriculumGroup.getDegreeModule() != null) {
                CreditsLimit creditsLimit = (CreditsLimit)((Object)curriculumGroup.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, this.executionYearContext));
                if (creditsLimit != null) {
                    groupName.append(" <span title=\"");
                    groupName.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.minCredits", (String[])new String[0]));
                    groupName.append(" \">m(");
                    groupName.append(creditsLimit.getMinimumCredits());
                    groupName.append(")</span>,");
                }
                groupName.append(" <span title=\"");
                groupName.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.creditsConcluded", (String[])new String[0]));
                groupName.append(" \"> c(");
                groupName.append(curriculumGroup.getCreditsConcluded(this.executionYearContext));
                groupName.append(")</span>");
                if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                    groupName.append(" <span title=\"");
                    groupName.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.approvedCredits", (String[])new String[0]));
                    groupName.append(" \">, ca(");
                    groupName.append(curriculumGroup.getAprovedEctsCredits());
                    groupName.append(")</span>");
                }
                if (creditsLimit != null) {
                    groupName.append("<span title=\"");
                    groupName.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.maxCredits", (String[])new String[0]));
                    groupName.append("\">, M(");
                    groupName.append(creditsLimit.getMaximumCredits());
                    groupName.append(")</span>");
                }
                if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan) && this.studentCurricularPlan.isBolonhaDegree() && creditsLimit != null) {
                    CurriculumModule.ConclusionValue value = curriculumGroup.isConcluded(this.executionYearContext);
                    groupName.append(" <em style=\"background-color:" + this.getBackgroundColor(value) + "; color:" + this.getColor(value) + "\"");
                    groupName.append(">");
                    groupName.append(value.getLocalizedName());
                    groupName.append("</em>");
                }
            }
            return groupName;
        }

        private String getBackgroundColor(CurriculumModule.ConclusionValue value) {
            switch (value) {
                case CONCLUDED: {
                    return "#dfb";
                }
                case UNKNOWN: {
                    return "#fff7bb";
                }
                case NOT_CONCLUDED: {
                    return "#ffeadd";
                }
            }
            return "";
        }

        private String getColor(CurriculumModule.ConclusionValue value) {
            switch (value) {
                case CONCLUDED: {
                    return "rgb(85, 85, 85)";
                }
                case UNKNOWN: {
                    return "rgb(85, 85, 85)";
                }
                case NOT_CONCLUDED: {
                    return "#c00";
                }
            }
            return "";
        }

        private void generateCurriculumLineRows(HtmlTable mainTable, CurriculumGroup curriculumGroup, int level) {
            if (StudentCurricularPlanRenderer.this.isToShowDismissals()) {
                this.generateDismissalRows(mainTable, curriculumGroup.getChildDismissals(), level);
            }
            if (StudentCurricularPlanRenderer.this.isToShowEnrolments()) {
                this.generateEnrolmentRows(mainTable, curriculumGroup.getChildEnrolments(), level);
            }
        }

        private void generateDismissalRows(HtmlTable mainTable, List<Dismissal> dismissals, int level) {
            TreeSet<Dismissal> sortedDismissals = new TreeSet<Dismissal>(Dismissal.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            sortedDismissals.addAll(dismissals);
            for (Dismissal dismissal : sortedDismissals) {
                this.generateDismissalRow(mainTable, dismissal, level);
            }
        }

        private void generateDismissalRow(HtmlTable mainTable, Dismissal dismissal, int level) {
            HtmlTableRow dismissalRow = mainTable.createRow();
            StudentCurricularPlanRenderer.this.addTabsToRow(dismissalRow, level);
            dismissalRow.setClasses(dismissal.getCredits().isTemporary() ? StudentCurricularPlanRenderer.this.getTemporaryDismissalRowClass() : StudentCurricularPlanRenderer.this.getDismissalRowClass());
            this.generateDismissalLabelCell(mainTable, dismissalRow, dismissal, level);
            this.generateCellsBetweenLabelAndGradeCell(dismissalRow);
            this.generateDismissalGradeCell(dismissalRow, dismissal);
            this.generateDismissalWeightCell(dismissalRow, dismissal);
            this.generateDismissalEctsCell(dismissalRow, dismissal);
            StudentCurricularPlanRenderer.this.generateCellWithText(dismissalRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getLastEnrolmentEvaluationTypeCellClass());
            this.generateExecutionYearCell(dismissalRow, dismissal);
            this.generateSemesterCell(dismissalRow, dismissal);
            this.generateDismissalApprovementlDateIfRequired(dismissalRow, dismissal.getApprovementDate());
            this.generateCreatorIfRequired(dismissalRow, dismissal.getCreatedBy());
            this.generateSpacerCellsIfRequired(dismissalRow);
        }

        private void generateDismissalWeightCell(HtmlTableRow dismissalRow, Dismissal dismissal) {
            StudentCurricularPlanRenderer.this.generateCellWithText(dismissalRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getWeightCellClass());
        }

        private void generateDismissalGradeCell(HtmlTableRow dismissalRow, Dismissal dismissal) {
            String gradeString;
            String gradeValue;
            String string = gradeValue = !StringUtils.isEmpty((String)dismissal.getCredits().getGivenGrade()) ? dismissal.getCredits().getGivenGrade() : null;
            if (gradeValue != null && NumberUtils.isNumber((String)gradeValue)) {
                DecimalFormat decimalFormat = new DecimalFormat("##.##");
                gradeString = decimalFormat.format(Double.valueOf(gradeValue));
            } else {
                gradeString = gradeValue != null ? gradeValue : EMPTY_INFO;
            }
            StudentCurricularPlanRenderer.this.generateCellWithText(dismissalRow, gradeString, StudentCurricularPlanRenderer.this.getGradeCellClass());
        }

        private void generateCellsBetweenLabelAndGradeCell(HtmlTableRow dismissalRow) {
            this.generateCellsWithText(dismissalRow, 3, EMPTY_INFO, new String[]{StudentCurricularPlanRenderer.this.getDegreeCurricularPlanCellClass(), StudentCurricularPlanRenderer.this.getEnrolmentTypeCellClass(), StudentCurricularPlanRenderer.this.getEnrolmentStateCellClass()});
        }

        private void generateCellsWithText(HtmlTableRow row, int numberOfCells, String text, String[] cssClasses) {
            for (int i = 0; i < numberOfCells; ++i) {
                StudentCurricularPlanRenderer.this.generateCellWithText(row, EMPTY_INFO, cssClasses[i]);
            }
        }

        private void generateDismissalEctsCell(HtmlTableRow dismissalRow, Dismissal dismissal) {
            StudentCurricularPlanRenderer.this.generateCellWithText(dismissalRow, dismissal.getEctsCredits() != null ? dismissal.getEctsCredits().toString() : StudentCurricularPlanLayout.EMPTY_INFO, StudentCurricularPlanRenderer.this.getEctsCreditsCellClass());
        }

        private void generateDismissalApprovementlDateIfRequired(HtmlTableRow enrolmentRow, YearMonthDay approvementDate) {
            if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                if (approvementDate != null) {
                    StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, approvementDate.toString(DATE_FORMAT), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.data.avaliacao", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                } else {
                    StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                }
            }
        }

        private void generateEvaluationDateIfRequired(HtmlTableRow externalEnrolmentRow, YearMonthDay evaluationDate) {
            if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                if (evaluationDate != null) {
                    StudentCurricularPlanRenderer.this.generateCellWithSpan(externalEnrolmentRow, evaluationDate.toString(DATE_FORMAT), BundleUtil.getString((String)"resources.ApplicationResources", (String)"creationDate", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                } else {
                    StudentCurricularPlanRenderer.this.generateCellWithText(externalEnrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                }
            }
        }

        private void generateCreatorIfRequired(HtmlTableRow enrolmentRow, String createdBy) {
            if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                if (!StringUtils.isEmpty((String)createdBy)) {
                    StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, createdBy, BundleUtil.getString((String)"resources.ApplicationResources", (String)"creator", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreatorCellClass());
                } else {
                    StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreatorCellClass());
                }
            }
        }

        private void generateDismissalLabelCell(HtmlTable mainTable, HtmlTableRow dismissalRow, Dismissal dismissal, int level) {
            HtmlTableCell cell = dismissalRow.createCell();
            cell.setColspan(Integer.valueOf(14 - level));
            cell.setClasses(StudentCurricularPlanRenderer.this.getLabelCellClass());
            HtmlInlineContainer container = new HtmlInlineContainer();
            cell.setBody((HtmlComponent)container);
            if (StudentCurricularPlanRenderer.this.isSelectable()) {
                HtmlCheckBox checkBox = new HtmlCheckBox();
                checkBox.setName(StudentCurricularPlanRenderer.this.getSelectionName());
                checkBox.setUserValue(dismissal.getExternalId().toString());
                container.addChild((HtmlComponent)checkBox);
            }
            HtmlText text = new HtmlText(BundleUtil.getString((String)"resources.StudentResources", (String)("label.dismissal." + ((Object)((Object)dismissal.getCredits())).getClass().getSimpleName()), (String[])new String[0]));
            container.addChild((HtmlComponent)text);
            CurricularCourse curricularCourse = dismissal.getCurricularCourse();
            if (curricularCourse != null) {
                String codeAndName = "";
                if (!StringUtils.isEmpty((String)curricularCourse.getCode())) {
                    codeAndName = codeAndName + curricularCourse.getCode() + " - ";
                }
                codeAndName = codeAndName + dismissal.getName().getContent();
                ExecutionCourse executionCourse = dismissal.getCurricularCourse().getExecutionCoursesByExecutionPeriod(dismissal.getExecutionPeriod()).stream().findAny().orElse(null);
                HtmlComponent executionCourseLink = this.createExecutionCourseLink(codeAndName, executionCourse);
                container.addChild((HtmlComponent)new HtmlText(": "));
                container.addChild(executionCourseLink);
            }
            if (StudentCurricularPlanRenderer.this.isDetailed()) {
                this.generateDismissalDetails(mainTable, dismissal, level);
            }
        }

        private void generateDismissalDetails(HtmlTable mainTable, Dismissal dismissal, int level) {
            for (IEnrolment enrolment : dismissal.getSourceIEnrolments()) {
                if (enrolment.isExternalEnrolment()) {
                    this.generateExternalEnrolmentRow(mainTable, (ExternalEnrolment)enrolment, level + 1, true);
                    continue;
                }
                this.generateEnrolmentRow(mainTable, (Enrolment)enrolment, level + 1, false, true, true);
            }
        }

        private void generateExternalEnrolmentRow(HtmlTable mainTable, ExternalEnrolment externalEnrolment, int level, boolean isFromDetail) {
            HtmlTableRow externalEnrolmentRow = mainTable.createRow();
            externalEnrolmentRow.setClasses(StudentCurricularPlanRenderer.this.getEnrolmentRowClass());
            StudentCurricularPlanRenderer.this.addTabsToRow(externalEnrolmentRow, level);
            this.generateExternalEnrolmentLabelCell(externalEnrolmentRow, externalEnrolment, level);
            this.generateCellsBetweenLabelAndGradeCell(externalEnrolmentRow);
            this.generateEnrolmentGradeCell(externalEnrolmentRow, externalEnrolment);
            this.generateEnrolmentWeightCell(externalEnrolmentRow, externalEnrolment, isFromDetail);
            this.generateExternalEnrolmentEctsCell(externalEnrolmentRow, externalEnrolment);
            StudentCurricularPlanRenderer.this.generateCellWithText(externalEnrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getLastEnrolmentEvaluationTypeCellClass());
            this.generateExecutionYearCell(externalEnrolmentRow, externalEnrolment);
            this.generateSemesterCell(externalEnrolmentRow, externalEnrolment);
            this.generateEvaluationDateIfRequired(externalEnrolmentRow, externalEnrolment.getEvaluationDate());
            this.generateCreatorIfRequired(externalEnrolmentRow, externalEnrolment.getCreatedBy());
            this.generateSpacerCellsIfRequired(externalEnrolmentRow);
        }

        private void generateExternalEnrolmentEctsCell(HtmlTableRow externalEnrolmentRow, ExternalEnrolment externalEnrolment) {
            StudentCurricularPlanRenderer.this.generateCellWithText(externalEnrolmentRow, externalEnrolment.getEctsCredits().toString(), StudentCurricularPlanRenderer.this.getEctsCreditsCellClass());
        }

        private void generateExternalEnrolmentLabelCell(HtmlTableRow externalEnrolmentRow, ExternalEnrolment externalEnrolment, int level) {
            StudentCurricularPlanRenderer.this.generateCellWithText(externalEnrolmentRow, externalEnrolment.getDescription(), StudentCurricularPlanRenderer.this.getLabelCellClass(), 14 - level);
        }

        private void generateEnrolmentRows(HtmlTable mainTable, List<Enrolment> childEnrolments, int level) {
            TreeSet<Enrolment> sortedEnrolments = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            sortedEnrolments.addAll(childEnrolments);
            for (Enrolment enrolment : sortedEnrolments) {
                if (StudentCurricularPlanRenderer.this.isToShowAllEnrolmentStates()) {
                    this.generateEnrolmentRow(mainTable, enrolment, level, true, false, false);
                    continue;
                }
                if (StudentCurricularPlanRenderer.this.isToShowApprovedOnly()) {
                    if (!enrolment.isApproved()) continue;
                    this.generateEnrolmentRow(mainTable, enrolment, level, true, false, false);
                    continue;
                }
                if (StudentCurricularPlanRenderer.this.isToShowApprovedOrEnroledStatesOnly()) {
                    if (!enrolment.isApproved() && !enrolment.isEnroled()) continue;
                    this.generateEnrolmentRow(mainTable, enrolment, level, true, false, false);
                    continue;
                }
                throw new RuntimeException("Unexpected enrolment state filter type");
            }
        }

        private void generateEnrolmentRow(HtmlTable mainTable, Enrolment enrolment, int level, boolean allowSelection, boolean isFromDetail, boolean isDismissal) {
            HtmlTableRow enrolmentRow = mainTable.createRow();
            StudentCurricularPlanRenderer.this.addTabsToRow(enrolmentRow, level);
            enrolmentRow.setClasses(StudentCurricularPlanRenderer.this.getEnrolmentRowClass());
            if (enrolment.isEnroled()) {
                this.generateEnrolmentWithStateEnroled(enrolmentRow, enrolment, level, allowSelection);
            } else {
                this.generateCurricularCourseCodeAndNameCell(enrolmentRow, enrolment, level, allowSelection);
                this.generateDegreeCurricularPlanCell(enrolmentRow, enrolment);
                this.generateEnrolmentTypeCell(enrolmentRow, enrolment);
                this.generateEnrolmentStateCell(enrolmentRow, enrolment);
                this.generateEnrolmentGradeCell(enrolmentRow, enrolment);
                this.generateEnrolmentWeightCell(enrolmentRow, enrolment, isFromDetail);
                this.generateEnrolmentEctsCell(enrolmentRow, enrolment, isFromDetail);
                this.generateEnrolmentLastEnrolmentEvaluationTypeCell(enrolmentRow, enrolment);
                this.generateExecutionYearCell(enrolmentRow, enrolment);
                this.generateSemesterCell(enrolmentRow, enrolment);
                this.generateStatisticsLinkCell(enrolmentRow, enrolment);
                this.generateLastEnrolmentEvaluationExamDateCellIfRequired(enrolmentRow, enrolment);
                this.generateGradeResponsibleIfRequired(enrolmentRow, enrolment);
                this.generateSpacerCellsIfRequired(enrolmentRow);
            }
            if (!isDismissal && StudentCurricularPlanRenderer.this.isDetailed() && StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan) && enrolment.getAllFinalEnrolmentEvaluations().size() > 1) {
                EvaluationSeason.all().sorted().forEachOrdered(s -> enrolment.getFinalEnrolmentEvaluationBySeason((EvaluationSeason)s).ifPresent(eval -> this.generateEnrolmentEvaluationRows(mainTable, (EnrolmentEvaluation)((Object)((Object)eval)), level + 1)));
            }
        }

        private void generateEnrolmentEvaluationRows(HtmlTable mainTable, EnrolmentEvaluation evaluation, int level) {
            if (evaluation == null) {
                return;
            }
            HtmlTableRow enrolmentRow = mainTable.createRow();
            StudentCurricularPlanRenderer.this.addTabsToRow(enrolmentRow, level);
            enrolmentRow.setClasses(StudentCurricularPlanRenderer.this.getEnrolmentRowClass());
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, evaluation.getEvaluationSeason().getName().getContent(), StudentCurricularPlanRenderer.this.getLabelCellClass(), 14 - level);
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, "", StudentCurricularPlanRenderer.this.getEnrolmentTypeCellClass(), 3);
            Grade grade = evaluation.getGrade();
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, grade.isEmpty() ? StudentCurricularPlanLayout.EMPTY_INFO : grade.getValue(), StudentCurricularPlanRenderer.this.getGradeCellClass());
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, "", StudentCurricularPlanRenderer.this.getEctsCreditsCellClass(), 3);
            if (evaluation.getExecutionPeriod() != null) {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, evaluation.getExecutionPeriod().getExecutionYear().getYear(), StudentCurricularPlanRenderer.this.getEnrolmentExecutionYearCellClass());
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, evaluation.getExecutionPeriod().getSemester().toString() + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.semester.short", (String[])new String[0]), StudentCurricularPlanRenderer.this.getEnrolmentSemesterCellClass());
            } else {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getEnrolmentSemesterCellClass());
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getEnrolmentSemesterCellClass());
            }
            if (evaluation != null && evaluation.getExamDateYearMonthDay() != null) {
                StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, evaluation.getExamDateYearMonthDay().toString(DATE_FORMAT), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.data.avaliacao", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreationDateCellClass());
            } else {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreationDateCellClass());
            }
            if (evaluation.getPersonResponsibleForGrade() != null) {
                Person person = evaluation.getPersonResponsibleForGrade();
                String username = this.getUsername(person);
                StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, username, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.responsiblePerson", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreatorCellClass());
            } else {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreatorCellClass());
            }
        }

        private void generateEnrolmentWithStateEnroled(HtmlTableRow enrolmentRow, Enrolment enrolment, int level, boolean allowSelection) {
            this.generateCurricularCourseCodeAndNameCell(enrolmentRow, enrolment, level, allowSelection);
            this.generateDegreeCurricularPlanCell(enrolmentRow, enrolment);
            this.generateEnrolmentTypeCell(enrolmentRow, enrolment);
            this.generateEnrolmentStateCell(enrolmentRow, enrolment);
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getGradeCellClass());
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getWeightCellClass());
            this.generateEnrolmentEctsCell(enrolmentRow, enrolment, false);
            this.generateEnrolmentEvaluationTypeCell(enrolmentRow, enrolment);
            this.generateExecutionYearCell(enrolmentRow, enrolment);
            this.generateSemesterCell(enrolmentRow, enrolment);
            if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreatorCellClass());
            }
            this.generateSpacerCellsIfRequired(enrolmentRow);
        }

        private void generateGradeResponsibleIfRequired(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                EnrolmentEvaluation lastEnrolmentEvaluation = enrolment.getFinalEnrolmentEvaluation();
                if (lastEnrolmentEvaluation != null && lastEnrolmentEvaluation.getPersonResponsibleForGrade() != null) {
                    Person person = lastEnrolmentEvaluation.getPersonResponsibleForGrade();
                    String username = this.getUsername(person);
                    StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, username, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.responsiblePerson", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreatorCellClass());
                } else {
                    StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreatorCellClass());
                }
            }
        }

        private String getUsername(Person person) {
            return person.getUsername();
        }

        private void generateLastEnrolmentEvaluationExamDateCellIfRequired(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            if (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan)) {
                EnrolmentEvaluation lastEnrolmentEvaluation = enrolment.getFinalEnrolmentEvaluation();
                if (lastEnrolmentEvaluation != null && lastEnrolmentEvaluation.getExamDateYearMonthDay() != null) {
                    StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, lastEnrolmentEvaluation.getExamDateYearMonthDay().toString(DATE_FORMAT), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.data.avaliacao", (String[])new String[0]), StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                } else {
                    StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getCreationDateCellClass());
                }
            }
        }

        private void generateSpacerCellsIfRequired(HtmlTableRow row) {
            int spacerColspan = this.calculateSpacerColspan();
            if (spacerColspan > 0) {
                HtmlTableCell spaceCells = row.createCell();
                spaceCells.setColspan(Integer.valueOf(spacerColspan));
                spaceCells.setText("");
            }
        }

        private int calculateSpacerColspan() {
            return 3 - (StudentCurricularPlanRenderer.this.isViewerAllowedToViewFullStudentCurriculum(this.studentCurricularPlan) ? 3 : 0);
        }

        private void generateSemesterCell(HtmlTableRow row, ICurriculumEntry entry) {
            String semester = entry.hasExecutionPeriod() ? entry.getExecutionPeriod().getSemester().toString() + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.semester.short", (String[])new String[0]) : EMPTY_INFO;
            StudentCurricularPlanRenderer.this.generateCellWithText(row, semester, StudentCurricularPlanRenderer.this.getEnrolmentSemesterCellClass());
        }

        private void generateStatisticsLinkCell(HtmlTableRow row, Enrolment enrolment) {
            ExecutionCourse executionCourse;
            if (enrolment.getStudent() == AccessControl.getPerson().getStudent() && enrolment.getStudent().hasAnyActiveRegistration() && (executionCourse = enrolment.getExecutionCourseFor(enrolment.getExecutionPeriod())) != null) {
                HtmlInlineContainer inlineContainer = new HtmlInlineContainer();
                inlineContainer.addChild((HtmlComponent)this.createExecutionCourseStatisticsLink(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.statistics", (String[])new String[0]), executionCourse));
                HtmlTableCell cell = row.createCell();
                cell.setClasses(StudentCurricularPlanRenderer.this.getStatisticsLinkCellClass());
                cell.setBody((HtmlComponent)inlineContainer);
            }
        }

        private void generateExecutionYearCell(HtmlTableRow row, ICurriculumEntry entry) {
            StudentCurricularPlanRenderer.this.generateCellWithText(row, entry.hasExecutionPeriod() ? entry.getExecutionYear().getYear() : StudentCurricularPlanLayout.EMPTY_INFO, StudentCurricularPlanRenderer.this.getEnrolmentExecutionYearCellClass());
        }

        private void generateEnrolmentLastEnrolmentEvaluationTypeCell(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            EnrolmentEvaluation lastEnrolmentEvaluation = enrolment.getFinalEnrolmentEvaluation();
            if (lastEnrolmentEvaluation != null && lastEnrolmentEvaluation.getEvaluationSeason() != null) {
                StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, lastEnrolmentEvaluation.getEvaluationSeason().getAcronym().getContent(), StudentCurricularPlanRenderer.this.getLastEnrolmentEvaluationTypeCellClass());
            } else {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getLastEnrolmentEvaluationTypeCellClass());
            }
        }

        private void generateEnrolmentEvaluationTypeCell(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            EvaluationSeason season = enrolment.getEvaluationSeason();
            if (season != null) {
                StudentCurricularPlanRenderer.this.generateCellWithSpan(enrolmentRow, season.getAcronym().getContent(), StudentCurricularPlanRenderer.this.getLastEnrolmentEvaluationTypeCellClass());
            } else {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getLastEnrolmentEvaluationTypeCellClass());
            }
        }

        private void generateEnrolmentEctsCell(HtmlTableRow enrolmentRow, Enrolment enrolment, boolean isFromDetail) {
            String ectsCredits = String.valueOf(isFromDetail ? enrolment.getEctsCreditsForCurriculum() : enrolment.getEctsCredits());
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, ectsCredits, StudentCurricularPlanRenderer.this.getEctsCreditsCellClass());
        }

        private void generateEnrolmentWeightCell(HtmlTableRow enrolmentRow, IEnrolment enrolment, boolean isFromDetail) {
            String weight = enrolment.getGrade() != null && !enrolment.getGrade().isEmpty() ? String.valueOf(isFromDetail ? enrolment.getWeigthForCurriculum() : enrolment.getWeigth()) : EMPTY_INFO;
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, weight, StudentCurricularPlanRenderer.this.getWeightCellClass());
        }

        private void generateEnrolmentGradeCell(HtmlTableRow enrolmentRow, IEnrolment enrolment) {
            Grade grade = enrolment.getGrade();
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, grade.isEmpty() ? StudentCurricularPlanLayout.EMPTY_INFO : grade.getValue(), StudentCurricularPlanRenderer.this.getGradeCellClass());
        }

        private void generateEnrolmentStateCell(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, enrolment.isApproved() ? StudentCurricularPlanLayout.EMPTY_INFO : BundleUtil.getString((String)"resources.EnumerationResources", (String)enrolment.getEnrollmentState().getQualifiedName(), (String[])new String[0]), StudentCurricularPlanRenderer.this.getEnrolmentStateCellClass());
        }

        private void generateEnrolmentTypeCell(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, enrolment.isEnrolmentTypeNormal() ? StudentCurricularPlanLayout.EMPTY_INFO : BundleUtil.getString((String)"resources.EnumerationResources", (String)enrolment.getEnrolmentTypeName(), (String[])new String[0]), StudentCurricularPlanRenderer.this.getEnrolmentTypeCellClass());
        }

        private void generateDegreeCurricularPlanCell(HtmlTableRow enrolmentRow, Enrolment enrolment) {
            if (enrolment.isFor(this.studentCurricularPlan.getRegistration())) {
                StudentCurricularPlanRenderer.this.generateCellWithText(enrolmentRow, EMPTY_INFO, StudentCurricularPlanRenderer.this.getDegreeCurricularPlanCellClass());
            } else {
                HtmlTableCell cell = enrolmentRow.createCell();
                cell.setClasses(StudentCurricularPlanRenderer.this.getDegreeCurricularPlanCellClass());
                cell.setBody(this.createDegreeCurricularPlanNameLink(enrolment.getDegreeCurricularPlanOfDegreeModule(), enrolment.getExecutionPeriod()));
            }
        }

        private HtmlComponent createDegreeCurricularPlanNameLink(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester) {
            if (degreeCurricularPlan.isPast() || degreeCurricularPlan.isEmpty()) {
                return new HtmlText(degreeCurricularPlan.getName());
            }
            String siteUrl = degreeCurricularPlan.getDegree().getSiteUrl();
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                return new HtmlText(degreeCurricularPlan.getName());
            }
            HtmlLink result = new HtmlLink();
            result.setText(degreeCurricularPlan.getName());
            result.setModuleRelative(false);
            result.setContextRelative(false);
            result.setTarget("_blank");
            result.setUrl(siteUrl);
            return result;
        }

        private void generateCurricularCourseCodeAndNameCell(HtmlTableRow enrolmentRow, Enrolment enrolment, int level, boolean allowSelection) {
            HtmlInlineContainer inlineContainer = new HtmlInlineContainer();
            if (StudentCurricularPlanRenderer.this.isSelectable() && allowSelection) {
                HtmlCheckBox checkBox = new HtmlCheckBox();
                checkBox.setName(StudentCurricularPlanRenderer.this.getSelectionName());
                checkBox.setUserValue(enrolment.getExternalId().toString());
                inlineContainer.addChild((HtmlComponent)checkBox);
            }
            ExecutionCourse executionCourse = enrolment.getExecutionCourseFor(enrolment.getExecutionPeriod());
            HtmlComponent executionCourseLink = this.createExecutionCourseLink(this.getPresentationNameFor(enrolment), executionCourse);
            inlineContainer.addChild(executionCourseLink);
            HtmlTableCell cell = enrolmentRow.createCell();
            cell.setClasses(StudentCurricularPlanRenderer.this.getLabelCellClass());
            cell.setColspan(Integer.valueOf(14 - level));
            cell.setBody((HtmlComponent)inlineContainer);
        }

        private String getPresentationNameFor(Enrolment enrolment) {
            String code;
            String string = code = !StringUtils.isEmpty((String)enrolment.getCurricularCourse().getCode()) ? enrolment.getCurricularCourse().getCode() + " - " : "";
            if (enrolment instanceof OptionalEnrolment) {
                OptionalEnrolment optionalEnrolment = (OptionalEnrolment)((Object)enrolment);
                return optionalEnrolment.getOptionalCurricularCourse().getName() + " (" + code + optionalEnrolment.getCurricularCourse().getName(optionalEnrolment.getExecutionPeriod()) + ")";
            }
            return code + enrolment.getName().getContent();
        }

        private HtmlComponent createExecutionCourseLink(String text, ExecutionCourse executionCourse) {
            if (executionCourse != null && executionCourse.getSiteUrl() != null) {
                HtmlLink result = new HtmlLink();
                result.setText(text);
                result.setModuleRelative(false);
                result.setContextRelative(false);
                result.setTarget("_blank");
                result.setUrl(executionCourse.getSiteUrl());
                return result;
            }
            return new HtmlText(text);
        }

        private HtmlLink createExecutionCourseStatisticsLink(String text, ExecutionCourse executionCourse) {
            HtmlLink result = new HtmlLink();
            result.setBody((HtmlComponent)new HtmlText(text));
            result.setParameter("executionCourseId", executionCourse.getExternalId());
            result.setParameter("method", "showExecutionCourseStatistics");
            result.setModuleRelative(false);
            result.setUrl("/student/showStudentStatistics.do");
            return result;
        }

        private void generateChildGroupRows(HtmlTable mainTable, CurriculumGroup parentGroup, int level) {
            TreeSet<CurriculumGroup> sortedCurriculumGroups = new TreeSet<CurriculumGroup>(CurriculumGroup.COMPARATOR_BY_CHILD_ORDER_AND_ID);
            sortedCurriculumGroups.addAll(parentGroup.getCurriculumGroups());
            for (CurriculumGroup childGroup : sortedCurriculumGroups) {
                if (!StudentCurricularPlanRenderer.this.canGenerate(childGroup, this.studentCurricularPlan)) continue;
                this.generateRowsForGroupsOrganization(mainTable, childGroup, level);
            }
        }
    }

    public static enum OrganizationType {
        GROUPS,
        EXECUTION_YEARS;


        public String getName() {
            return this.name();
        }

        public String getFullyQualifiedName() {
            return ((Object)((Object)this)).getClass() + "." + this.name();
        }

        public static OrganizationType[] getValues() {
            return OrganizationType.values();
        }
    }

    public static enum ViewType {
        ALL,
        ENROLMENTS,
        DISMISSALS;


        public String getName() {
            return this.name();
        }

        public String getFullyQualifiedName() {
            return ((Object)((Object)this)).getClass() + "." + this.name();
        }

        public static ViewType[] getValues() {
            return ViewType.values();
        }
    }

    public static enum EnrolmentStateFilterType {
        ALL,
        APPROVED,
        APPROVED_OR_ENROLED;


        public String getName() {
            return this.name();
        }

        public String getFullyQualifiedName() {
            return ((Object)((Object)this)).getClass().getName() + "." + this.name();
        }

        public static EnrolmentStateFilterType[] getValues() {
            return EnrolmentStateFilterType.values();
        }
    }
}

