/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.student;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.curriculumLine.CurriculumLineLocationBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class CurriculumGroupsProviderForMoveCurriculumLines
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        CurriculumLineLocationBean bean = (CurriculumLineLocationBean)source;
        Student student = bean.getStudent();
        HashSet<Object> result = new HashSet<Object>();
        for (Registration registration : student.getRegistrationsSet()) {
            if (!registration.isBolonha()) {
                result.addAll(registration.getLastStudentCurricularPlan().getAllCurriculumGroups());
                continue;
            }
            StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
            result.addAll(studentCurricularPlan.getNoCourseGroupCurriculumGroups());
            for (CycleCurriculumGroup cycle : studentCurricularPlan.getCycleCurriculumGroups()) {
                if (bean.isWithRules() && this.isConcluded(student, cycle)) continue;
                result.addAll(cycle.getAllCurriculumGroups());
            }
        }
        final Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, Authenticate.getUser()).collect(Collectors.toSet());
        return Collections2.filter(result, (Predicate)new Predicate<CurriculumGroup>(){

            public boolean apply(CurriculumGroup group) {
                return programs.contains(group.getDegreeCurricularPlanOfStudent().getDegree());
            }
        });
    }

    private boolean isConcluded(Student student, CycleCurriculumGroup cycle) {
        return cycle.getConclusionProcess() != null || cycle.isExternal() && student.hasRegistrationFor(cycle.getDegreeCurricularPlanOfDegreeModule());
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

