/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.fenixedu.academic.domain.Grade;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class GradeRenderer
extends OutputRenderer {
    private boolean showGradeScale = true;
    private String gradeClasses;
    private String gradeScaleClasses;

    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                Grade grade = (Grade)object;
                if (grade == null || grade.isEmpty()) {
                    return new HtmlText();
                }
                HtmlInlineContainer container = new HtmlInlineContainer();
                HtmlText gradeValue = new HtmlText(grade.getValue());
                gradeValue.setClasses(GradeRenderer.this.getGradeClasses());
                container.addChild((HtmlComponent)gradeValue);
                if (GradeRenderer.this.isShowGradeScale()) {
                    HtmlText gradeScale = new HtmlText("(" + RenderUtils.getEnumString((Enum)grade.getGradeScale()) + ")");
                    gradeScale.setClasses(GradeRenderer.this.getGradeScaleClasses());
                    container.addChild((HtmlComponent)gradeScale);
                }
                return container;
            }
        };
    }

    public boolean isShowGradeScale() {
        return this.showGradeScale;
    }

    public void setShowGradeScale(boolean showGradeScale) {
        this.showGradeScale = showGradeScale;
    }

    public String getGradeClasses() {
        return this.gradeClasses;
    }

    public void setGradeClasses(String gradeClasses) {
        this.gradeClasses = gradeClasses;
    }

    public String getGradeScaleClasses() {
        return this.gradeScaleClasses;
    }

    public void setGradeScaleClasses(String gradeScaleClasses) {
        this.gradeScaleClasses = gradeScaleClasses;
    }
}

