/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopyFields;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.CandidacySummaryFile;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.servlet.PdfFiller;
import org.fenixedu.academic.servlet.ProcessCandidacyPrintAllDocumentsFilter$callable$associateSummaryFile;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.SimpleHtmlSerializer;
import org.htmlcleaner.TagNode;
import org.joda.time.YearMonthDay;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xml.sax.SAXException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.ResponseWrapper;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ProcessCandidacyPrintAllDocumentsFilter
implements Filter {
    private static final Set<PdfFiller> pdfFillersSet;
    private static final Logger logger;
    private static final String ACADEMIC_ADMIN_SHEET_REPORT_KEY = "processOpeningAndUpdating";
    private ServletContext servletContext;
    public static final Advice advice$associateSummaryFile;

    private String getMail(Person person) {
        if (person.hasInstitutionalEmailAddress()) {
            return person.getInstitutionalEmailAddressValue();
        }
        String emailForSendingEmails = person.getEmailForSendingEmails();
        return emailForSendingEmails != null ? emailForSendingEmails : "";
    }

    public void init(FilterConfig arg0) throws ServletException {
        this.servletContext = arg0.getServletContext();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
        arg2.doFilter(arg0, arg1);
        HttpServletRequest request = (HttpServletRequest)arg0;
        if ("doOperation".equals(request.getParameter("method")) && "PRINT_ALL_DOCUMENTS".equals(request.getParameter("operationType"))) {
            try {
                ResponseWrapper response = (ResponseWrapper)arg1;
                String responseHtml = this.clean(response.getContent());
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(responseHtml.getBytes(StandardCharsets.UTF_8)));
                this.patchLinks(doc, request);
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocument(doc, "");
                renderer.layout();
                ByteArrayOutputStream pdfStream = new ByteArrayOutputStream();
                renderer.createPDF((OutputStream)pdfStream);
                Person person = (Person)((Object)request.getAttribute("person"));
                StudentCandidacy candidacy = this.getCandidacy(request);
                ByteArrayOutputStream finalPdfStream = this.concatenateDocs(pdfStream.toByteArray(), person);
                byte[] pdfByteArray = finalPdfStream.toByteArray();
                this.associateSummaryFile(pdfByteArray, person.getStudent().getNumber().toString(), candidacy);
                response.reset();
                response.sendRedirect(this.buildRedirectURL(request, candidacy));
                response.flushBuffer();
            }
            catch (ParserConfigurationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (DocumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void associateSummaryFile(byte[] byArray, String string, StudentCandidacy studentCandidacy) {
        Object object = advice$associateSummaryFile.perform((Callable)new ProcessCandidacyPrintAllDocumentsFilter$callable$associateSummaryFile(this, byArray, string, studentCandidacy));
    }

    static /* synthetic */ void advised$associateSummaryFile(ProcessCandidacyPrintAllDocumentsFilter this_, byte[] pdfByteArray, String studentNumber, StudentCandidacy studentCandidacy) {
        studentCandidacy.setSummaryFile(new CandidacySummaryFile(studentNumber + ".pdf", pdfByteArray, studentCandidacy));
    }

    private String clean(String dirtyHtml) {
        try {
            HtmlCleaner cleaner = new HtmlCleaner();
            TagNode root = cleaner.clean(dirtyHtml);
            return new SimpleHtmlSerializer(cleaner.getProperties()).getAsString(root);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private void patchLinks(Document doc, HttpServletRequest request) {
        String appContext = request.getContextPath();
        NodeList linkNodes = doc.getElementsByTagName("link");
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            Element link = (Element)linkNodes.item(i);
            String href = link.getAttribute("href");
            if (appContext.length() > 0 && href.contains(appContext)) {
                href = href.substring(appContext.length());
            }
            try {
                String realPath = this.servletContext.getResource(href).toString();
                link.setAttribute("href", realPath);
                continue;
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        NodeList imageNodes = doc.getElementsByTagName("img");
        for (int i = 0; i < imageNodes.getLength(); ++i) {
            Element img = (Element)imageNodes.item(i);
            String src = img.getAttribute("src");
            if (appContext != null && appContext.length() > 0 && src.contains(appContext)) {
                src = src.substring(appContext.length() + 1);
            }
            try {
                String realPath = this.servletContext.getResource(src).toString();
                img.setAttribute("src", realPath);
                continue;
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ByteArrayOutputStream concatenateDocs(byte[] originalDoc, Person person) throws IOException, DocumentException {
        ByteArrayOutputStream concatenatedPdf = new ByteArrayOutputStream();
        PdfCopyFields copy = new PdfCopyFields((OutputStream)concatenatedPdf);
        try {
            copy.addDocument(new PdfReader(this.createAcademicAdminProcessSheet(person)));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        copy.addDocument(new PdfReader(originalDoc));
        for (PdfFiller pdfFiller : pdfFillersSet) {
            copy.addDocument(new PdfReader(pdfFiller.getFilledPdf(person).toByteArray()));
        }
        copy.close();
        return concatenatedPdf;
    }

    public static void registerFiller(PdfFiller pdfFiller) {
        pdfFillersSet.add(pdfFiller);
    }

    private byte[] createAcademicAdminProcessSheet(Person person) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Student student = person.getStudent();
            Registration registration = this.findRegistration(student);
            map.put("executionYear", ExecutionYear.readCurrentExecutionYear().getYear());
            if (registration != null) {
                map.put("course", registration.getDegree().getNameI18N().toString());
            }
            map.put("studentNumber", student.getNumber().toString());
            map.put("fullName", person.getName());
            try {
                map.put("photo", new ByteArrayInputStream(person.getPersonalPhotoEvenIfPending().getDefaultAvatar()));
            }
            catch (Exception e) {
                // empty catch block
            }
            map.put("sex", BundleUtil.getString((String)"resources.EnumerationResources", (String)person.getGender().name(), (String[])new String[0]));
            map.put("maritalStatus", person.getMaritalStatus().getPresentationName());
            map.put("profession", person.getProfession());
            map.put("idDocType", person.getIdDocumentType().getLocalizedName());
            map.put("idDocNumber", person.getDocumentIdNumber());
            YearMonthDay emissionDate = person.getEmissionDateOfDocumentIdYearMonthDay();
            if (emissionDate != null) {
                map.put("idDocEmissionDate", emissionDate.toString(DateTimeFormat.forPattern((String)"dd/MM/yyyy")));
            }
            map.put("idDocExpirationDate", person.getExpirationDateOfDocumentIdYearMonthDay().toString(DateTimeFormat.forPattern((String)"dd/MM/yyyy")));
            map.put("idDocEmissionLocation", person.getEmissionLocationOfDocumentId());
            String nif = person.getSocialSecurityNumber();
            if (nif != null) {
                map.put("NIF", nif);
            }
            map.put("birthDate", person.getDateOfBirthYearMonthDay().toString(DateTimeFormat.forPattern((String)"dd/MM/yyyy")));
            map.put("nationality", person.getCountryOfBirth().getCountryNationality().toString());
            map.put("parishOfBirth", person.getParishOfBirth());
            map.put("districtSubdivisionOfBirth", person.getDistrictSubdivisionOfBirth());
            map.put("districtOfBirth", person.getDistrictOfBirth());
            map.put("countryOfBirth", person.getCountryOfBirth().getName());
            map.put("fathersName", person.getNameOfFather());
            map.put("mothersName", person.getNameOfMother());
            map.put("address", person.getAddress());
            map.put("postalCode", person.getPostalCode());
            map.put("locality", person.getAreaOfAreaCode());
            map.put("cellphoneNumber", person.getDefaultMobilePhoneNumber());
            map.put("telephoneNumber", person.getDefaultPhoneNumber());
            map.put("emailAddress", this.getMail(person));
            map.put("currentDate", new SimpleDateFormat("'Lisboa, 'dd' de 'MMMM' de 'yyyy", new Locale("PT", "pt")).format(new Date()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ReportsUtils.generateReport(ACADEMIC_ADMIN_SHEET_REPORT_KEY, map, null).getData();
    }

    private Registration findRegistration(Student student) {
        return student.getLastRegistration();
    }

    private StudentCandidacy getCandidacy(HttpServletRequest request) {
        return (StudentCandidacy)FenixFramework.getDomainObject((String)request.getParameter("candidacyID"));
    }

    private String buildRedirectURL(HttpServletRequest request, StudentCandidacy candidacy) {
        String url = "/candidate/degreeCandidacyManagement.do?method=showCandidacyDetails&candidacyID=" + candidacy.getExternalId();
        String urlWithChecksum = GenericChecksumRewriter.injectChecksumInUrl((String)request.getContextPath(), (String)url, (HttpSession)request.getSession());
        return request.getContextPath() + urlWithChecksum;
    }

    static {
        advice$associateSummaryFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        pdfFillersSet = new HashSet<PdfFiller>();
        logger = LoggerFactory.getLogger(ProcessCandidacyPrintAllDocumentsFilter.class);
    }
}

