/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.strategy.groupEnrolment.strategys;

import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.GroupEnrolmentStrategy;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IGroupEnrolmentStrategy;

public class AtomicGroupEnrolmentStrategy
extends GroupEnrolmentStrategy
implements IGroupEnrolmentStrategy {
    @Override
    public Integer enrolmentPolicyNewGroup(Grouping grouping, int numberOfStudentsToEnrole, Shift shift) {
        if (this.checkNumberOfGroups(grouping, shift)) {
            Integer maximumCapacity = grouping.getMaximumCapacity();
            Integer minimumCapacity = grouping.getMinimumCapacity();
            Integer nrStudents = numberOfStudentsToEnrole;
            if (maximumCapacity == null && minimumCapacity == null) {
                return 1;
            }
            if (minimumCapacity != null && nrStudents.compareTo(minimumCapacity) < 0) {
                return -2;
            }
            if (maximumCapacity != null && nrStudents.compareTo(maximumCapacity) > 0) {
                return -3;
            }
        } else {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean checkNumberOfGroupElements(Grouping grouping, StudentGroup studentGroup) {
        boolean result = false;
        Integer minimumCapacity = grouping.getMinimumCapacity();
        if (minimumCapacity == null) {
            result = true;
        } else {
            int numberOfGroupElements = studentGroup.getAttendsSet().size();
            if (numberOfGroupElements > minimumCapacity) {
                result = true;
            }
        }
        return result;
    }
}

