/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadShiftsByExecutionPeriodAndExecutionDegreeAndCurricularYear$callable$run;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadShiftsByExecutionPeriodAndExecutionDegreeAndCurricularYear {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List<InfoShift> run(AcademicInterval academicInterval, InfoExecutionDegree infoExecutionDegree, InfoCurricularYear infoCurricularYear) {
        return (List)advice$run.perform((Callable)new ReadShiftsByExecutionPeriodAndExecutionDegreeAndCurricularYear$callable$run(academicInterval, infoExecutionDegree, infoCurricularYear));
    }

    static /* synthetic */ List<InfoShift> advised$run(AcademicInterval academicInterval, InfoExecutionDegree infoExecutionDegree, InfoCurricularYear infoCurricularYear) {
        AccessControl.check(RolePredicates.RESOURCE_ALLOCATION_MANAGER_PREDICATE);
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)infoExecutionDegree.getExternalId());
        DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
        CurricularYear curricularYear = (CurricularYear)FenixFramework.getDomainObject((String)infoCurricularYear.getExternalId());
        ArrayList<InfoShift> infoShifts = new ArrayList<InfoShift>();
        List<ExecutionCourse> executionCourses = ExecutionCourse.filterByAcademicIntervalAndDegreeCurricularPlanAndCurricularYearAndName(academicInterval, degreeCurricularPlan, curricularYear, "%");
        for (ExecutionCourse executionCourse : executionCourses) {
            for (Shift shift : executionCourse.getAssociatedShifts()) {
                InfoShift infoShift = new InfoShift(shift);
                infoShifts.add(infoShift);
            }
        }
        return infoShifts;
    }
}

