/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.person;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.service.services.person.SearchPerson$callable$runSearchPerson;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SearchPerson
implements Serializable {
    private static final SearchPerson serviceInstance;
    public static final Advice advice$runSearchPerson;

    public CollectionPager<Person> run(SearchParameters searchParameters, Predicate predicate) {
        Collection<Person> persons;
        Person person;
        if (searchParameters.emptyParameters()) {
            return new CollectionPager<Person>(new ArrayList(), 25);
        }
        if (searchParameters.getUsername() != null && searchParameters.getUsername().length() > 0) {
            person = Person.readPersonByUsername(searchParameters.getUsername());
            persons = new ArrayList<Person>();
            if (person != null) {
                persons.add(person);
            }
        } else if (searchParameters.getDocumentIdNumber() != null && searchParameters.getDocumentIdNumber().length() > 0) {
            persons = Person.findPersonByDocumentID(searchParameters.getDocumentIdNumber());
        } else if (searchParameters.getStudentNumber() != null) {
            Student student = Student.readStudentByNumber(searchParameters.getStudentNumber());
            persons = new ArrayList<Person>();
            if (student != null) {
                persons.add(student.getPerson());
            }
        } else if (searchParameters.getEmail() != null && searchParameters.getEmail().length() > 0) {
            person = Person.readPersonByEmailAddress(searchParameters.getEmail());
            persons = new ArrayList<Person>();
            if (person != null) {
                persons.add(person);
            }
        } else if (searchParameters.getName() != null) {
            Department department;
            persons = new ArrayList<Person>();
            persons.addAll(Person.findPerson(searchParameters.getName()));
            RoleType roleBd = searchParameters.getRole();
            if (roleBd != null) {
                Iterator<Person> peopleIterator = persons.iterator();
                while (peopleIterator.hasNext()) {
                    Person person2 = peopleIterator.next();
                    if (roleBd.isMember(person2.getUser())) continue;
                    peopleIterator.remove();
                }
            }
            if ((department = searchParameters.getDepartment()) != null) {
                Iterator<Person> peopleIterator = persons.iterator();
                while (peopleIterator.hasNext()) {
                    Person person3 = peopleIterator.next();
                    Teacher teacher = person3.getTeacher();
                    if (teacher != null && teacher.getDepartment() == department) continue;
                    peopleIterator.remove();
                }
            }
        } else if (!StringUtils.isEmpty((String)searchParameters.getPaymentCode())) {
            persons = new ArrayList<Person>();
            PaymentCode paymentCode = PaymentCode.readByCode(searchParameters.getPaymentCode());
            if (paymentCode != null && paymentCode.getPerson() != null) {
                persons.add(paymentCode.getPerson());
            }
        } else {
            persons = new ArrayList<Person>(0);
        }
        TreeSet result = new TreeSet(Person.COMPARATOR_BY_NAME_AND_ID);
        result.addAll(CollectionUtils.select(persons, (Predicate)predicate));
        return new CollectionPager<Person>(result, 25);
    }

    public static CollectionPager<Person> runSearchPerson(SearchParameters searchParameters, Predicate predicate) {
        return (CollectionPager)advice$runSearchPerson.perform((Callable)new SearchPerson$callable$runSearchPerson(searchParameters, predicate));
    }

    static /* synthetic */ CollectionPager<Person> advised$runSearchPerson(SearchParameters searchParameters, Predicate predicate) {
        return serviceInstance.run(searchParameters, predicate);
    }

    static {
        advice$runSearchPerson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new SearchPerson();
    }

    public static class SearchPersonPredicate
    implements Predicate {
        private final SearchParameters searchParameters;

        public SearchPersonPredicate(SearchParameters searchParameters) {
            this.searchParameters = searchParameters;
        }

        public boolean evaluate(Object arg0) {
            Person person = (Person)((Object)arg0);
            return this.verifyActiveState(this.searchParameters.getActivePersons(), person) && this.verifySimpleParameter(person.getDocumentIdNumber(), this.searchParameters.getDocumentIdNumber()) && this.verifyUsernameEquality(this.searchParameters.getUsername(), person) && SearchPersonPredicate.verifyNameEquality(this.searchParameters.getNameWords(), person) && this.verifyAnyEmailAddress(this.searchParameters.getEmail(), person) && this.verifyDegreeType(this.searchParameters.getDegree(), this.searchParameters.getDegreeType(), person) && this.verifyStudentNumber(this.searchParameters.getStudentNumber(), person) && SearchPersonPredicate.verifyPaymentCodes(this.searchParameters.getPaymentCode(), person);
        }

        protected boolean verifyAnyEmailAddress(String email, Person person) {
            return email == null || email.trim().isEmpty() || person.hasEmailAddress(email);
        }

        protected boolean verifyIdDocumentType(IDDocumentType idDocumentType, Person person) {
            return idDocumentType == null || person.getIdDocumentType() == idDocumentType;
        }

        protected boolean verifyStudentNumber(Integer studentNumber, Person person) {
            return studentNumber == null || person.getStudent() != null && person.getStudent().getNumber().equals(studentNumber);
        }

        protected boolean verifyActiveState(Boolean activePersons, Person person) {
            return activePersons == null || Boolean.valueOf(RoleType.PERSON.isMember(person.getUser())).equals(activePersons);
        }

        protected boolean verifyUsernameEquality(String usernameToSearch, Person person) {
            if (usernameToSearch == null) {
                return true;
            }
            String normalizedUsername = StringNormalizer.normalize((String)usernameToSearch.trim());
            String normalizedAlias = StringNormalizer.normalize((String)person.getUsername());
            return normalizedAlias.indexOf(normalizedUsername) != 1;
        }

        protected boolean verifyDegreeType(Degree degree, DegreeType degreeType, Person person) {
            return degreeType == null || this.verifyDegreeType(degree, person.getStudentByType(degreeType));
        }

        private boolean verifyDegreeType(Degree degree, Registration registrationByType) {
            return registrationByType != null && (degree == null || this.verifyDegree(degree, registrationByType));
        }

        private boolean verifyDegree(Degree degree, Registration registrationByType) {
            StudentCurricularPlan studentCurricularPlan = registrationByType.getActiveStudentCurricularPlan();
            return studentCurricularPlan != null && degree == studentCurricularPlan.getDegreeCurricularPlan().getDegree();
        }

        protected boolean verifySimpleParameter(String parameter, String searchParameter) {
            return searchParameter == null || parameter != null && this.simpleNnormalizeAndCompare(parameter, searchParameter);
        }

        private boolean verifyParameter(String parameter, String searchParameter) {
            return searchParameter == null || parameter != null && this.normalizeAndCompare(parameter, searchParameter);
        }

        private boolean simpleNnormalizeAndCompare(String parameter, String searchParameter) {
            String personParameter = parameter;
            return personParameter.indexOf(searchParameter) != -1;
        }

        private boolean normalizeAndCompare(String parameter, String searchParameter) {
            String personParameter = StringNormalizer.normalize((String)parameter.trim());
            return personParameter.indexOf(searchParameter) != -1;
        }

        protected static boolean verifyNameEquality(String[] nameWords, Person person) {
            return person.verifyNameEquality(nameWords);
        }

        protected static boolean verifyPaymentCodes(String paymentCode, Person person) {
            return StringUtils.isEmpty((String)paymentCode) || person.getPaymentCodeBy(paymentCode) != null;
        }

        public SearchParameters getSearchParameters() {
            return this.searchParameters;
        }
    }

    public static class SearchParameters
    implements Serializable {
        private String email;
        private String username;
        private String documentIdNumber;
        private IDDocumentType idDocumentType;
        private String name;
        private String[] nameWords;
        private RoleType role;
        private Degree degree;
        private Department department;
        private DegreeType degreeType;
        private Boolean activePersons;
        private Integer studentNumber;
        private String paymentCode;

        public SearchParameters() {
        }

        public SearchParameters(String name, String email, String username, String documentIdNumber, String idDocumentType, String roleType, String degreeTypeString, String degreeId, String departmentId, Boolean activePersons, Integer studentNumber) {
            this(name, email, username, documentIdNumber, idDocumentType, roleType, degreeTypeString, degreeId, departmentId, activePersons, studentNumber, null);
        }

        public SearchParameters(String name, String email, String username, String documentIdNumber, String idDocumentType, String roleType, String degreeTypeString, String degreeId, String departmentId, Boolean activePersons, Integer studentNumber, String paymentCode) {
            this();
            this.setActivePersons(activePersons);
            this.setName(name);
            this.setEmail(email);
            this.setUsername(username);
            this.setDocumentIdNumber(documentIdNumber);
            if (!StringUtils.isEmpty((String)idDocumentType)) {
                this.setIdDocumentType(IDDocumentType.valueOf(idDocumentType));
            }
            this.setStudentNumber(studentNumber);
            this.setPaymentCode(paymentCode);
            if (roleType != null && roleType.length() > 0) {
                this.role = RoleType.valueOf(roleType);
            }
            if (!StringUtils.isEmpty((String)degreeId)) {
                this.degree = (Degree)FenixFramework.getDomainObject((String)degreeId);
            }
            if (degreeTypeString != null && degreeTypeString.length() > 0) {
                this.degreeType = (DegreeType)FenixFramework.getDomainObject((String)degreeTypeString);
            }
            if (!StringUtils.isEmpty((String)departmentId)) {
                this.department = (Department)FenixFramework.getDomainObject((String)departmentId);
            }
        }

        public boolean emptyParameters() {
            return StringUtils.isEmpty((String)this.email) && StringUtils.isEmpty((String)this.username) && StringUtils.isEmpty((String)this.documentIdNumber) && this.role == null && this.degree == null && this.department == null && this.degreeType == null && this.nameWords == null && this.studentNumber == null && this.idDocumentType == null && StringUtils.isEmpty((String)this.getPaymentCode());
        }

        private static String[] getNameWords(String name) {
            String[] nameWords = null;
            if (name != null && !StringUtils.isEmpty((String)name.trim())) {
                nameWords = StringNormalizer.normalize((String)name).trim().split(" ");
            }
            return nameWords;
        }

        public Degree getDegree() {
            return this.degree;
        }

        public DegreeType getDegreeType() {
            return this.degreeType;
        }

        public Department getDepartment() {
            return this.department;
        }

        public String getDocumentIdNumber() {
            return this.documentIdNumber;
        }

        public IDDocumentType getIdDocumentType() {
            return this.idDocumentType;
        }

        public String getEmail() {
            return this.email;
        }

        public String[] getNameWords() {
            return this.nameWords;
        }

        public String getName() {
            return this.name;
        }

        public RoleType getRole() {
            return this.role;
        }

        public String getUsername() {
            return this.username;
        }

        public Boolean getActivePersons() {
            return this.activePersons;
        }

        public Integer getStudentNumber() {
            return this.studentNumber;
        }

        public void setEmail(String email) {
            this.email = email != null && !email.equals("") ? StringNormalizer.normalize((String)email.trim()) : null;
        }

        public void setUsername(String username) {
            this.username = username != null && !username.equals("") ? StringNormalizer.normalize((String)username.trim()) : null;
        }

        public void setDocumentIdNumber(String documentIdNumber) {
            this.documentIdNumber = documentIdNumber != null && !documentIdNumber.equals("") ? documentIdNumber.trim() : null;
        }

        public void setIdDocumentType(IDDocumentType idDocumentType) {
            this.idDocumentType = idDocumentType;
        }

        public void setName(String name) {
            this.name = name != null && !name.equals("") ? name : null;
            this.nameWords = name != null && !name.equals("") ? SearchParameters.getNameWords(name) : null;
        }

        public void setRole(RoleType role) {
            this.role = role;
        }

        public void setDegree(Degree degree) {
            this.degree = degree;
        }

        public void setDepartment(Department department) {
            this.department = department;
        }

        public void setDegreeType(DegreeType degreeType) {
            this.degreeType = degreeType;
        }

        public void setActivePersons(Boolean activePersons) {
            this.activePersons = activePersons;
        }

        public void setStudentNumber(Integer studentNumber) {
            this.studentNumber = studentNumber;
        }

        public String getPaymentCode() {
            return this.paymentCode;
        }

        public void setPaymentCode(String paymentCode) {
            this.paymentCode = paymentCode;
        }
    }
}

