/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.accounting;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.fenixedu.academic.domain.accounting.CreditNote;
import org.fenixedu.academic.domain.accounting.CreditNoteEntry;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class CreditNoteDocument
extends FenixReport {
    private final CreditNote creditNote;
    private final boolean original;
    private static final long serialVersionUID = 1L;

    public CreditNoteDocument(CreditNote creditNote, boolean original) {
        this.creditNote = creditNote;
        this.original = original;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        this.addParameter("documentIdType", this.creditNote.getReceipt().getPerson().getIdDocumentType().getLocalizedName());
        this.addParameter("documentIdNumber", this.creditNote.getReceipt().getPerson().getDocumentIdNumber());
        this.addParameter("name", this.creditNote.getReceipt().getPerson().getName());
        this.addParameter("ownerUnitPhone", Bennu.getInstance().getInstitutionUnit().getDefaultPhoneNumber());
        this.addParameter("creditNoteNumber", this.creditNote.getNumber() + "/" + this.creditNote.getYear().toString());
        this.addParameter("receiptNumber", this.creditNote.getReceipt().getNumberWithSeries() + "/" + this.creditNote.getReceipt().getYear().toString());
        this.addParameter("annulled", this.creditNote.isAnnulled());
        this.addParameter("creditNoteDate", this.creditNote.getWhenCreated().toString("dd MMMM yyyy", this.getLocale()));
        this.addParameter("total", this.creditNote.getTotalAmount().toPlainString());
        this.addParameter("original", this.original);
        this.addParameter("studentNumber", this.creditNote.getReceipt().getPerson().getStudent() != null ? this.creditNote.getReceipt().getPerson().getStudent().getNumber().toString() : null);
        this.addDataSourceElements(this.buildEntries());
    }

    private List<CreditNoteDocumentEntry> buildEntries() {
        TreeSet<CreditNoteEntry> sortedEntries = new TreeSet<CreditNoteEntry>(CreditNoteEntry.COMPARATOR_BY_WHEN_REGISTERED);
        sortedEntries.addAll(this.creditNote.getCreditNoteEntriesSet());
        ArrayList<CreditNoteDocumentEntry> result = new ArrayList<CreditNoteDocumentEntry>();
        for (CreditNoteEntry each : sortedEntries) {
            result.add(new CreditNoteDocumentEntry(each.getAccountingEntry().getDescription().toString(), each.getAmount().toPlainString()));
        }
        return result;
    }

    @Override
    public String getReportFileName() {
        return "CreditNote-" + new DateTime().toString("yyyyMMddHHmmss", this.getLocale());
    }

    public static class CreditNoteDocumentEntry {
        private String description;
        private String amount;

        public CreditNoteDocumentEntry(String description, String amount) {
            this.description = description;
            this.amount = amount;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAmount() {
            return this.amount;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
}

