/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExtraCurricularCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;

public class ExtraCurricularCertificateRequestDocument
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected ExtraCurricularCertificateRequestDocument(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    protected ExtraCurricularCertificateRequest getDocumentRequest() {
        return (ExtraCurricularCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        this.addParameter("enrolmentsInfo", this.getEnrolmentsInfo());
    }

    @Override
    protected String getDegreeDescription() {
        return this.getDocumentRequest().getRegistration().getDegreeDescription(null, this.getLocale());
    }

    private final String getEnrolmentsInfo() {
        StringBuilder result = new StringBuilder();
        ExtraCurricularCertificateRequest request = this.getDocumentRequest();
        TreeSet enrolments = new TreeSet(Enrolment.COMPARATOR_BY_EXECUTION_YEAR_AND_NAME_AND_ID);
        enrolments.addAll(request.getEnrolmentsSet());
        for (Enrolment enrolment : enrolments) {
            result.append(FenixStringTools.multipleLineRightPadWithSuffix(this.getPresentationNameFor(enrolment).toUpperCase(), 64, '-', this.getCreditsAndGradeInfo(enrolment, enrolment.getExecutionYear()))).append("\n");
        }
        result.append(this.generateEndLine());
        return result.toString();
    }
}

