/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.DegreeSpecializationArea;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.EctsGraduationGradeConversionTable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.ExtraCurricularActivity;
import org.fenixedu.academic.domain.student.curriculum.ExtraCurricularActivityType;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class DiplomaSupplement
extends AdministrativeOfficeDocument {
    public static final Comparator<DiplomaSupplementEntry> COMPARATOR = new Comparator<DiplomaSupplementEntry>(){

        @Override
        public int compare(DiplomaSupplementEntry o1, DiplomaSupplementEntry o2) {
            int c = o1.getExecutionYear().compareTo(o2.getExecutionYear());
            return c == 0 ? Collator.getInstance().compare(o1.getName(), o2.getName()) : c;
        }
    };

    protected DiplomaSupplement(IDocumentRequest documentRequest, Locale locale) {
        super(documentRequest, locale);
    }

    @Override
    public String getReportTemplateKey() {
        return this.getClass().getName();
    }

    @Override
    protected IDiplomaSupplementRequest getDocumentRequest() {
        return (IDiplomaSupplementRequest)this.documentRequestDomainReference;
    }

    @Override
    protected void fillReport() {
        this.addParameter("bundle", ResourceBundle.getBundle(this.getBundle(), this.getLocale()));
        this.addParameter("name", StringFormatter.prettyPrint(this.getDocumentRequest().getPerson().getName().trim()));
        this.fillGroup1();
        this.fillGroup2();
        this.fillGroup3();
        this.fillGroup4();
        this.fillGroup5();
        this.fillGroup6();
        this.fillGroup7();
        this.fillGroup8();
    }

    protected void fillGroup8() {
        this.addParameter("langSuffix", this.getLanguage().getLanguage());
    }

    protected void fillGroup7() {
        UniversityUnit institutionsUniversityUnit = UniversityUnit.getInstitutionsUniversityUnit();
        this.addParameter("day", new YearMonthDay().toString("dd/MM/yyyy", this.getLocale()));
        this.addParameter("universityPrincipal", (Object)institutionsUniversityUnit.getCurrentPrincipal());
    }

    protected void fillGroup6() {
        this.addExtraCurricularActivities();
    }

    protected void fillGroup5() {
        StringBuilder access = new StringBuilder();
        if (this.getDocumentRequest().getRequestedCycle() == CycleType.THIRD_CYCLE) {
            access.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.five.one.three", (String[])new String[0]));
        } else {
            String degreeDesignation = this.getDegreeDesignation();
            access.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.five.one.one", (String[])new String[0])).append(" ");
            access.append(degreeDesignation).append(" ");
            access.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.five.one.two", (String[])new String[0]));
        }
        this.addParameter("accessToHigherLevelOfEducation", access.toString());
        this.addProfessionalStatus();
    }

    protected void fillGroup4() {
        String degreeDesignation = this.getDegreeDesignation();
        this.addProgrammeRequirements(degreeDesignation);
        this.addEntriesParameters();
        this.addParameter("classificationSystem", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.four.four.one", (String[])new String[0]));
        this.addParameter("finalAverage", this.getDocumentRequest().getFinalAverage());
        String finalAverageQualified = this.getDocumentRequest().getFinalAverageQualified(this.getLocale());
        if (finalAverageQualified != null) {
            this.addParameter("finalAverageQualified", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)finalAverageQualified, (String[])new String[0]));
        }
        EctsGraduationGradeConversionTable table = this.getDocumentRequest().getGraduationConversionTable();
        if (this.getDocumentRequest().isRequestForPhd()) {
            this.addParameter("thesisFinalGrade", ((PhdDiplomaSupplementRequest)this.getDocumentRequest()).getThesisFinalGrade(this.getLocale()));
        }
        this.addParameter("ectsGradeConversionTable", table.getEctsTable());
        this.addParameter("ectsGradePercentagesTable", table.getPercentages());
    }

    protected void fillGroup3() {
        this.addParameter("qualificationLevel", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)("diploma.supplement.qualification." + (Object)((Object)this.getDocumentRequest().getRequestedCycle())), (String[])new String[0]));
        this.addParameter("years", this.getDocumentRequest().getNumberOfCurricularYears());
        this.addParameter("semesters", this.getDocumentRequest().getNumberOfCurricularSemesters());
        this.addParameter("weeksOfStudyPerYear", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)("diploma.supplement.weeksOfStudyPerYear." + (Object)((Object)this.getDocumentRequest().getRequestedCycle())), (String[])new String[0]));
        double ectsCreditsValue = this.getDocumentRequest().getEctsCredits();
        String ectsCredits = (double)((long)ectsCreditsValue) == ectsCreditsValue ? "" + Long.toString((long)ectsCreditsValue) : Double.toString(ectsCreditsValue);
        this.addParameter("ectsCredits", ectsCredits);
    }

    protected String fillGroup2() {
        UniversityUnit institutionsUniversityUnit = this.getUniversity(this.getDocumentRequest().getRequestDate());
        String degreeDesignation = this.getDegreeDesignation();
        String graduateTitleNative = this.getDocumentRequest().getGraduateTitle(this.getLocale()).split(" ")[0];
        this.addParameter("graduateTitle", degreeDesignation + "\n" + graduateTitleNative);
        this.addParameter("prevailingScientificArea", this.getDocumentRequest().getPrevailingScientificArea(this.getLocale()));
        this.addParameter("universityName", institutionsUniversityUnit.getName());
        this.addParameter("universityStatus", BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)(AcademicalInstitutionType.class.getSimpleName() + "." + institutionsUniversityUnit.getInstitutionType().getName()), (String[])new String[0]));
        this.addParameter("institutionName", Bennu.getInstance().getInstitutionUnit().getName());
        this.addParameter("institutionStatus", BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)Bennu.getInstance().getInstitutionUnit().getType().getName(), (String[])new String[0]) + " " + BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.of", (String[])new String[0]) + " " + institutionsUniversityUnit.getName());
        if (CycleType.FIRST_CYCLE.equals((Object)this.getDocumentRequest().getRequestedCycle())) {
            this.addParameter("languages", BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)"pt", (String[])new String[0]));
        } else {
            this.addParameter("languages", BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)"pt", (String[])new String[0]) + " " + BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.and", (String[])new String[0]).toLowerCase() + " " + BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)"en", (String[])new String[0]));
        }
        return degreeDesignation;
    }

    protected void fillGroup1() {
        this.addParameter("dummyDataSource", Arrays.asList(Boolean.TRUE));
        Person person = this.getDocumentRequest().getPerson();
        this.addParameter("familyName", person.getFamilyNames());
        this.addParameter("givenName", person.getGivenNames());
        this.addParameter("birthDay", person.getDateOfBirthYearMonthDay().toString("dd/MM/yyyy", this.getLocale()));
        this.addParameter("nationality", StringFormatter.prettyPrint(person.getCountry().getCountryNationality().getContent(this.getLocale())));
        this.addParameter("documentIdType", this.applyMessageArguments(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.one.five.one", (String[])new String[0]), BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)person.getIdDocumentType().getName(), (String[])new String[0])));
        this.addParameter("documentIdNumber", person.getDocumentIdNumber());
        this.addParameter("registrationNumber", this.getDocumentRequest().getRegistrationNumber());
        this.addParameter("isExemptedFromStudy", this.getDocumentRequest().isExemptedFromStudy());
        this.addParameter("isForPhd", this.getDocumentRequest().isRequestForPhd());
        this.addParameter("isForRegistration", this.getDocumentRequest().isRequestForRegistration());
    }

    private String getDegreeDesignation() {
        Optional<CourseGroup> courseGroup;
        IDiplomaSupplementRequest request = this.getDocumentRequest();
        Degree degree = this.getDocumentRequest().getRegistration().getDegree();
        ArrayList<String> res = new ArrayList<String>();
        String graduationLevel = request.getProgramConclusion().getGraduationLevel().getContent(this.getLocale());
        if (!Strings.isNullOrEmpty((String)graduationLevel)) {
            res.add(graduationLevel);
            res.add(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.in", (String[])new String[0]));
        }
        if ((courseGroup = request.getProgramConclusion().groupFor(request.getRegistration()).map(CurriculumGroup::getDegreeModule)).isPresent()) {
            res.add(courseGroup.get().getDegreeNameWithTitleSuffix(request.getConclusionYear(), this.getLocale()));
        } else {
            res.add(degree.getNameI18N(request.getConclusionYear()).getContent(this.getLocale()));
        }
        return Joiner.on((String)" ").join(res);
    }

    private void addProgrammeRequirements(String graduateDegree) {
        String programmeRequirements;
        String labelThe = CycleType.FIRST_CYCLE.equals((Object)this.getDocumentRequest().getRequestedCycle()) ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.the.female", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.the.male", (String[])new String[0]);
        double ectsCreditsValue = this.getDocumentRequest().getEctsCredits();
        String ectsCredits = (double)((long)ectsCreditsValue) == ectsCreditsValue ? "" + Long.toString((long)ectsCreditsValue) : Double.toString(ectsCreditsValue);
        DegreeOfficialPublication dr = this.getDocumentRequest().getDegreeOfficialPublication();
        if (dr == null) {
            throw new DomainException("error.DiplomaSupplement.degreeOfficialPublicationNotFound", new String[0]);
        }
        String officialPublication = dr.getOfficialReference();
        if (this.getDocumentRequest().isRequestForPhd()) {
            programmeRequirements = this.applyMessageArguments(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.four.two.programmerequirements.template.noareas.with.official.publication", (String[])new String[0]), labelThe, graduateDegree, ectsCredits, officialPublication);
        } else if (this.getDocumentRequest().getRequestedCycle().equals((Object)CycleType.FIRST_CYCLE) || dr.getSpecializationAreaSet().size() == 0) {
            programmeRequirements = this.applyMessageArguments(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.four.two.programmerequirements.template.noareas", (String[])new String[0]), labelThe, graduateDegree, ectsCredits);
        } else {
            ArrayList<String> areas = new ArrayList<String>();
            for (DegreeSpecializationArea area : dr.getSpecializationAreaSet()) {
                areas.add(area.getName().getContent(this.getLanguage()));
            }
            programmeRequirements = this.applyMessageArguments(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.four.two.programmerequirements.template.withareas", (String[])new String[0]), labelThe, graduateDegree, ectsCredits, Integer.toString(areas.size()), StringUtils.join(areas, (String)"; "), officialPublication);
        }
        programmeRequirements = programmeRequirements.substring(0, 1).toUpperCase() + programmeRequirements.substring(1);
        this.addParameter("programmeRequirements", programmeRequirements);
    }

    protected void addProfessionalStatus() {
        DiplomaSupplementRequest request;
        String degreeSigla;
        String professionalStatus = !CycleType.SECOND_CYCLE.equals((Object)this.getDocumentRequest().getRequestedCycle()) ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.professionalstatus.notapplicable", (String[])new String[0]) : ((degreeSigla = (request = (DiplomaSupplementRequest)this.getDocumentRequest()).getRegistration().getDegree().getSigla()).equals("MA") ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.professionalstatus.credited.arquitect.withintership", (String[])new String[0]) : (degreeSigla.equals("MMA") || degreeSigla.equals("MQ") || degreeSigla.equals("MUOT") || degreeSigla.equals("MPOT") || degreeSigla.equals("MFarm") ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.professionalstatus.notapplicable", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.professionalstatus.credited.engineer", (String[])new String[0])));
        this.addParameter("professionalStatus", professionalStatus);
    }

    private void addExtraCurricularActivities() {
        Student student = this.getDocumentRequest().getStudent();
        if (!student.getExtraCurricularActivitySet().isEmpty()) {
            ArrayList<String> activities = new ArrayList<String>();
            HashMap activityMap = new HashMap();
            for (ExtraCurricularActivity extraCurricularActivity : student.getExtraCurricularActivitySet()) {
                if (!activityMap.containsKey((Object)extraCurricularActivity.getType())) {
                    activityMap.put(extraCurricularActivity.getType(), new ArrayList());
                }
                ((List)activityMap.get((Object)extraCurricularActivity.getType())).add(extraCurricularActivity);
            }
            for (Map.Entry entry : activityMap.entrySet()) {
                StringBuilder activityText = new StringBuilder();
                activityText.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.six.one.extracurricularactivity.heading", (String[])new String[0]));
                activityText.append(" ");
                activityText.append(((ExtraCurricularActivityType)((Object)entry.getKey())).getName().getContent(this.getLanguage()));
                activityText.append(" ");
                ArrayList<String> activityTimings = new ArrayList<String>();
                for (ExtraCurricularActivity activity : (List)entry.getValue()) {
                    activityTimings.add(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.six.one.extracurricularactivity.time.heading", (String[])new String[0]) + " " + activity.getStart().toString("MM-yyyy") + " " + BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.six.one.extracurricularactivity.time.separator", (String[])new String[0]) + " " + activity.getEnd().toString("MM-yyyy"));
                }
                activityText.append(StringUtils.join(activityTimings, (String)", "));
                activities.add(activityText.toString());
            }
            this.addParameter("extraCurricularActivities", StringUtils.join(activities, (char)'\n') + ".");
        } else {
            this.addParameter("extraCurricularActivities", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.supplement.six.one.extracurricularactivity.none", (String[])new String[0]));
        }
    }

    private String applyMessageArguments(String message, String ... args) {
        for (int i = 0; i < args.length; ++i) {
            message = message.replaceAll("\\{" + i + "\\}", args[i]);
        }
        return message;
    }

    private void addEntriesParameters() {
        ArrayList<AcademicUnitEntry> identifiers = new ArrayList<AcademicUnitEntry>();
        if (this.getDocumentRequest().hasRegistration()) {
            Registration registration = this.getDocumentRequest().getRegistration();
            ArrayList<DiplomaSupplementEntry> entries = new ArrayList<DiplomaSupplementEntry>();
            HashMap<Unit, String> academicUnitIdentifiers = new HashMap<Unit, String>();
            for (ICurriculumEntry iCurriculumEntry : registration.getCurriculum(this.getDocumentRequest().getRequestedCycle()).getCurriculumEntries()) {
                entries.add(new DiplomaSupplementEntry(iCurriculumEntry, academicUnitIdentifiers));
            }
            Collections.sort(entries);
            this.addParameter("entries", entries);
            for (Map.Entry entry : academicUnitIdentifiers.entrySet()) {
                identifiers.add(new AcademicUnitEntry(entry));
            }
        } else {
            this.addParameter("entries", new ArrayList());
        }
        this.addParameter("academicUnitIdentifiers", identifiers);
    }

    public class AcademicUnitEntry {
        private final String identifier;
        private final String name;

        public AcademicUnitEntry(Map.Entry<Unit, String> entry) {
            this.identifier = entry.getValue();
            Unit unit = entry.getKey();
            String name = DiplomaSupplement.this.getMLSTextContent(unit.getNameI18n());
            List univs = unit.getParentUnits().stream().filter(u -> u.isUniversityUnit()).collect(Collectors.toList());
            if (!univs.isEmpty()) {
                UniversityUnit institutionsUniversityUnit = DiplomaSupplement.this.getUniversity(DiplomaSupplement.this.getDocumentRequest().getRequestDate());
                name = univs.contains((Object)institutionsUniversityUnit) ? DiplomaSupplement.this.getMLSTextContent(institutionsUniversityUnit.getNameI18n()) + ", " + name : DiplomaSupplement.this.getMLSTextContent(((Unit)((Object)univs.iterator().next())).getNameI18n()) + ", " + name;
            }
            this.name = name;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }
    }

    public class DiplomaSupplementEntry
    implements Comparable<DiplomaSupplementEntry> {
        private final ICurriculumEntry entry;
        private final String executionYear;
        private final String name;
        private final String type;
        private final String duration;
        private final BigDecimal ectsCreditsForCurriculum;
        private final String gradeValue;
        private final String ectsScale;
        private final String academicUnitId;

        public DiplomaSupplementEntry(ICurriculumEntry entry, Map<Unit, String> academicUnitIdentifiers) {
            this.entry = entry;
            this.executionYear = entry.getExecutionYear().getYear();
            this.name = DiplomaSupplement.this.getMLSTextContent(entry.getPresentationName());
            DateTime processingDate = this.computeProcessingDateToLockECTSTableUse();
            if (entry instanceof IEnrolment) {
                IEnrolment enrolment = (IEnrolment)entry;
                this.type = BundleUtil.getString((String)"resources.EnumerationResources", (Locale)DiplomaSupplement.this.getLocale(), (String)enrolment.getEnrolmentTypeName(), (String[])new String[0]);
                this.duration = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)DiplomaSupplement.this.getLocale(), (String)(enrolment.isAnual() ? "diploma.supplement.annual" : "diploma.supplement.semestral"), (String[])new String[0]);
                this.ectsScale = enrolment.getEctsGrade(DiplomaSupplement.this.getDocumentRequest().getRegistration().getLastStudentCurricularPlan(), processingDate).getValue();
            } else if (entry instanceof Dismissal && ((Dismissal)entry).getCredits().isEquivalence()) {
                Dismissal dismissal = (Dismissal)entry;
                this.type = BundleUtil.getString((String)"resources.EnumerationResources", (Locale)DiplomaSupplement.this.getLocale(), (String)dismissal.getEnrolmentTypeName(), (String[])new String[0]);
                this.duration = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)DiplomaSupplement.this.getLocale(), (String)(dismissal.isAnual() ? "diploma.supplement.annual" : "diploma.supplement.semestral"), (String[])new String[0]);
                this.ectsScale = dismissal.getEctsGrade(processingDate).getValue();
            } else {
                throw new Error("The roof is on fire");
            }
            this.ectsCreditsForCurriculum = entry.getEctsCreditsForCurriculum();
            this.academicUnitId = this.obtainAcademicUnitIdentifier(academicUnitIdentifiers);
            this.gradeValue = entry.getGrade().getValue();
        }

        private DateTime computeProcessingDateToLockECTSTableUse() {
            DateTime date = DiplomaSupplement.this.documentRequestDomainReference.getProcessingDate();
            return date != null ? date : new DateTime();
        }

        public ICurriculumEntry getEntry() {
            return this.entry;
        }

        public String getExecutionYear() {
            return this.executionYear;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDuration() {
            return this.duration;
        }

        public BigDecimal getEctsCreditsForCurriculum() {
            return this.ectsCreditsForCurriculum;
        }

        public String getGradeValue() {
            return this.gradeValue;
        }

        public String getEctsScale() {
            return this.ectsScale;
        }

        public String getAcademicUnitId() {
            return this.academicUnitId;
        }

        private String obtainAcademicUnitIdentifier(Map<Unit, String> academicUnitIdentifiers) {
            Unit unit = this.entry instanceof ExternalEnrolment ? ((ExternalEnrolment)this.entry).getAcademicUnit() : Bennu.getInstance().getInstitutionUnit();
            return DiplomaSupplement.this.getAcademicUnitIdentifier(academicUnitIdentifiers, unit);
        }

        @Override
        public int compareTo(DiplomaSupplementEntry o) {
            return COMPARATOR.compare(this, o);
        }
    }
}

